local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local Gauss = {}
Gauss.Do = 0;
Gauss.Queue = 310;

Gauss.material = 0;
Gauss.renderObj = 0;

function Gauss:Initialize(host, size)
  self.sigma = mathfunction.vector1(0.0);

  self.SIGMA = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "SIGMA");
  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TARGETSIZE");

  --local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/gauss.material");
  --self.Do = host:CreateRenderObject(pathout);
  self.material = host:CreateMaterial("comm:documents/material/gauss.material");
  self.renderObj = host:CreateRenderObject();

  -- self.Do:SetParameter(self.TARGETSIZE,size);
  -- self.Do:SetParameter(self.SIGMA, self.sigma);
  self.material:SetParameter(self.TARGETSIZE,size);
  self.material:SetParameter(self.SIGMA, self.sigma);

  host:RegisterScriptParameter(self, "sigma");
  return self.Queue;
end



function Gauss:Resizeview(size)
  self.material:SetParameter(self.TARGETSIZE,size);
end

-- function Gauss:Process(pipeline, Original, Scene, Output)
function Gauss:Process(context, Original, Scene, Output)
  -- Output:PushRenderTarget();
  -- Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(Output,apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

  self.material:SetParameter(self.SIGMA, self.sigma);
	--self.Do:Draw(pipeline);
  context:Draw(self.renderObj,self.material);
  context:EndRenderPass();
end

return Gauss;