#DEFPARAMS
CURL        = {"CURL", TEXTURE2D, "CURL"},
VELOCITY    = {"VELOCITY", TEXTURE2D, "VELOCITY"},
TEXEL_SIZE  = {"TEXEL_SIZE", VEC2, "64.0, 64.0"},
CURL_CONFIG = {"CURL_CONFIG", FLOAT, "30.0"},
TIME_STEP   = {"TIME_STEP", FLOAT, "0.01"},
FLOAT_MIN   = {"FLOAT_MIN", FLOAT, "-100.0"},
FLOAT_MAX   = {"FLOAT_MAX", FLOAT, "100.0"},
#END

#DEFTAG
ShaderName  = "VorticityStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 center_uv: TEXCOORD0;
    float2 left_uv:   TEXCOORD1;
    float2 right_uv:  TEXCOORD2;
    float2 top_uv:    TEXCOORD3;
    float2 bottom_uv: TEXCOORD4;

    float4 vertex : SV_POSITION;
};

Texture2D CURL;
Texture2D VELOCITY;
SamplerState CURL_Sampler;
SamplerState VELOCITY_Sampler;
float2    TEXEL_SIZE;
float     CURL_CONFIG;
float     TIME_STEP;
float     FLOAT_MIN;
float     FLOAT_MAX;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);

    o.center_uv = v.uv.xy;
    o.left_uv   = o.center_uv - float2(TEXEL_SIZE.x, 0.0);
    o.right_uv  = o.center_uv + float2(TEXEL_SIZE.x, 0.0);
    o.top_uv    = o.center_uv + float2(0.0, TEXEL_SIZE.y);
    o.bottom_uv = o.center_uv - float2(0.0, TEXEL_SIZE.y);

    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float range  = FLOAT_MAX - FLOAT_MIN;
    float center = CURL.Sample(CURL_Sampler, i.center_uv).x * range + FLOAT_MIN;
    float left   = CURL.Sample(CURL_Sampler, i.left_uv).x * range + FLOAT_MIN;
    float right  = CURL.Sample(CURL_Sampler, i.right_uv).x * range + FLOAT_MIN;
    float top    = CURL.Sample(CURL_Sampler, i.top_uv).x * range + FLOAT_MIN;
    float bottom = CURL.Sample(CURL_Sampler, i.bottom_uv).x * range + FLOAT_MIN;

    float2 force = 0.5 * float2(abs(top) - abs(bottom), abs(right) - abs(left));
    force       /= (length(force) + 0.0001);
    force       *= CURL_CONFIG * center;
    force.y     *= -1.0;

    float2 vel = VELOCITY.Sample(VELOCITY_Sampler, i.center_uv).xy * range + FLOAT_MIN;
    vel        = vel + force * TIME_STEP;
    vel        = (vel - float2(FLOAT_MIN, FLOAT_MIN)) / range;
    mainColor = float4(vel, 0.0, 1.0);
}
ENDCG
#END