#SHADER_DEFINE BezierCurve2Point

	FUNCTION_INPUT = 
	{
		{ BEZIER_CONTROL_POINT_1,	LOW,	VEC4,		"in_ControlP1"},
    { BEZIER_CONTROL_POINT_2,	LOW,	VEC4,		"in_ControlP2"},
    { BEZIER_CONTROL_POINT_3,	LOW,	VEC4,		"in_ControlP3"},
    { BEZIER_CONTROL_POINT_4,	LOW,	VEC4,		"in_ControlP4"},
    { SAMPLE_TIME_FRACTOR,            LOW,  FLOAT,   "in_SampleT"},        
	}

	FUNCTION_OUTPUT = 
	{
		{ BEZIER_OUTPUT,	LOW,	VEC4,		"out_Bezier" },
	}
	
#SHADER_CODE
    float t = in_SampleT;
    float t2 = t * t;
    float one_minus_t = 1.0 - t;
    float one_minus_t2 = one_minus_t * one_minus_t;
    vec4 out_Bezier = in_ControlP1 * one_minus_t2 * one_minus_t + in_ControlP2 * 3.0 * t * one_minus_t2 + in_ControlP3 * 3.0 * t2 * one_minus_t + in_ControlP4 * t2 * t;
#END_CODE
#END_DEFINE