

#DEFPARAMS
#END

#DEFTAG
ShaderName = "Mosaic"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 TARGETSIZE;
float2 MOSAIC_SIZE;
float2 MOSAIC_CENTER;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float2 singleMosaic = TARGETSIZE / MOSAIC_SIZE;
    float2 realCenter = MOSAIC_CENTER * TARGETSIZE;
	//将纹理坐标映射到分辨率的大小
    float2 uv = i.uv * TARGETSIZE;
	//根据马赛克块大小进行取整
    uv = floor( (uv - realCenter) / singleMosaic) * singleMosaic + realCenter;
	//把坐标重新映射回0,1的范围之内
    float2 output_uv = uv / TARGETSIZE;
    if (MOSAIC_SIZE.x <= 1.0) {
        output_uv.x = i.uv.x;
    }
    if (MOSAIC_SIZE.y <= 1.0) {
        output_uv.y = i.uv.y;
    }
    mainColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, output_uv);
}
ENDCG
#END
