#DEFPARAMS
#END

#DEFTAG
ShaderName = "hair_color_resolve"
RenderQueue = "Transparent"
#END

#DEFPASS Hair_Color_Resolve
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_BLEND, ONE, SRC_ALPHA, ZERO, ONE}
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "hairLighting.inc"


struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
};



Texture2D InvAlphaTexure;
Texture2D HairColorTexure;
SamplerState InvAlphaTexure_Sampler;
SamplerState HairColorTexure_Sampler;


v2f vert(appdata v)
{
  v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
	return o;
}


void frag(in v2f v, out float4 mainColor : SV_Target0)
{
    float fInvAlpha = InvAlphaTexure.Sample(InvAlphaTexure_Sampler, v.uv).r;
    float fAlpha = 1.0 - fInvAlpha;

    if(fAlpha < SHORTCUT_MIN_ALPHA)
      discard;

    float4 fcolor = HairColorTexure.Sample(HairColorTexure_Sampler, v.uv);
    fcolor.xyz = fcolor.xyz / fcolor.w;
    fcolor.xyz = fcolor.xyz * fAlpha;
    fcolor.w = fInvAlpha;
   
    mainColor = fcolor;
}
ENDCG
#END
