#DEFPARAMS
[Keywords(ALPHAPREMULTIPLY_ON, ALPHAPREMULTIPLY_OFF)]
_AlphaPreMultiply = {"Alpha Pre Multiply", FLOAT, "1.0"},
[Keywords(ALPHATEST_ON, ALPHATEST_OFF)]
_ALPHATEST_ON = {"Alpha Test On", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "StandardPbrDeferred"
RenderQueue = "%_RenderQueue"
#END


#DEFPASS DeferredStencil
COLOR_MASK = COLOR_NONE
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_ON, -1,  
STENCIL_FUNCTION_ALWAYS, 0, -1, STENCIL_OPERATION_KEEP, STENCIL_OPERATION_INCR, STENCIL_OPERATION_KEEP,
STENCIL_FUNCTION_ALWAYS, 0, -1, STENCIL_OPERATION_KEEP, STENCIL_OPERATION_INCR, STENCIL_OPERATION_KEEP }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd
#include "lightpbr.inc"
#include "lightdeferred.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
    ANI_ATTRIBUTE
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};



v2f vert(appdata v)
{

    COMPUTE_BONE_MATERIX(v);
    v2f o;

    float4 pos = ObjectToClipPos(v.vertex);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;

    return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
    outColor = float4(0,0,0,0);
    return;
}

ENDCG

#END






