CGPROGRAM
#pragma compute _Boundary

#include "fluid_simulation.inc"

float3 _borderMin;
float3 _borderMax;

RWStructuredBuffer<float4>  _Obstacles;

// fieldDstS -> obstacle

[numthreads(THREAD_SIZE, THREAD_SIZE, THREAD_SIZE)]
void _Boundary(int3 id : SV_DispatchThreadID)
{
  int idx = id.x + id.y*_Size.x + id.z*_Size.w;
	
	int3 borderMin = int3(_borderMin);
	int3 borderMax = int3(_borderMax);
  
  if (id.x < borderMin.x 
	|| id.x > (int)_Size.x - borderMax.x - 1 
	|| id.y < borderMin.y 
	|| id.y > (int)_Size.y - borderMax.y - 1 
	|| id.z < borderMin.z 
	||id.z > (int)_Size.z - borderMax.z - 1)
	{
		_Obstacles[idx] = float4(1.0f,0.0f,0.0f,0.0f);
	}
	else
	{
		_Obstacles[idx] = float4(0.0f,0.0f,0.0f,0.0f);
	}

}

ENDCG

