local Object = require "classic"
local detectservice = Object:extend();
--local mlcnnseg = require "likeapp"
local videodetect = require "videodecet.videodecet"
local videodefined = require"videodecet.defined"
local apolloengine = require "apolloengine"
local vc = require "venuscore"
local maskOutW = 128;
local detection =nil;
local DetectShell = nil;
local mf = require "mathfunction"
local likeapp = require "likeapp"


function detectservice:ToRelativeCoordinates(pixel_x, pixel_y)
  return pixel_x / self.w * 2 - 1, 1 - pixel_y / self.h * 2;
end

function detectservice:SetDetectShell()
    detection = require "machinelearningservice"
    DetectShell = detection.MachinelearningService;
end

function detectservice:new()
  self.DetectMark = false;
  self:initPara();
  self:SetDetectShell();
end
function detectservice:initPara()
  self.w = 0;
  self.h = 0;
  self.DetectInit = false;
  self.lastdef = 0;
  self.EMPTY_KEYPOINTS_ARRAY = mf.vector2array();
end

function detectservice:InitCnnDetection( w, h)
  
  if( detection == nil or DetectShell == nil) then
    ERROR("detection="..tostring(detection).."; DetectShell="..toString(DetectShell));
    return;
  end
  self:initPara();
  self.detection = DetectShell();
  if (self.detection and DetectShell.SetType) then
    self.detection:SetType(self.detectType - videodefined.detectType.DetectTypeBegin);
  end
  if _PLATFORM_WINDOWS then  --只有windows需要设置模型路径
    self.detection:SetModelAndParamsWin(
            self.detectType - videodefined.detectType.DetectTypeBegin ,
            vc.IFileSystem:PathAssembly(videodefined.bvt_model_path));
  end
  local r =self.detection:Init(w,h);
  if(r ~= videodefined.iris_detect_flag.SUCCESS) then
    ERROR("detection:Init fail r="..r)
    self.DetectInit = false;
  else
    self.DetectInit = true;
    self.w = w;
    self.h = h;
  end
end

function detectservice:SetType(detectType)
    self.detectType = detectType;
end


-- mark a new coming frame, startNewUpdate -> Update -> _Update
function detectservice:startNewUpdate()
  if( detection == nil or DetectShell == nil) then
    return;
  end
   self.newupd = true;
end


function detectservice:SetDetectionMark(mark)
  if( detection == nil or DetectShell == nil) then
    return;
  end
  self.detectMark = mark;
end


function detectservice:SetCnnSegMark(mark)
  if( detection == nil or DetectShell == nil) then
    return;
  end
  self.detectMark = mark;
end

function detectservice:OnResizeView(w,h)
  if( detection == nil or DetectShell == nil) then
    return;
  end
  --if(self.w ~= w or self.h ~= h)
  --then
  --  self.DetectInit = false;
  --end
  --由于异步初始化 这里不直接调用venus修改分辨率
  --venus在每次self.detection:Run的时候 根据 tsPara的分辨率修改
  LOG("detectservice ("..self.w..","..self.h..")->("..w..","..h..")" );
  self.w = w ;
  self.h = h ;
end

function detectservice:Update(ts,def)
  if( detection == nil or DetectShell == nil) then
    return nil;
  end
  self:_Update(ts,def);
  return self.pointarray,self.confidencearray;  --返回关键点和关键点的置信度
end


function detectservice:_Update(ts,def)
   
  if( detection == nil or DetectShell == nil) then
    return;
  end
  
  if(not self.newupd) then
    return;
  end

  if(not (self.detectMark and self.DetectInit == true)) then
    return;
  end
  
  local pointarray = nil;
  local inputs = nil;
  --local faceInfoes = videodetect:GetFaces();
  --get face point array as the library needs
  inputs = videodetect:GetPixelFacekeypointArray();

  if inputs == nil then
    inputs = self.EMPTY_KEYPOINTS_ARRAY;
    WARNING("Empty face keypoints");
  end

  if(ts ~= nil) then -- 如果没有图像 不做任何处理
    pointarray , self.confidencearray = self.detection:Run(inputs,ts);
  else
    WARNING("detectservice:_Update NO ts");
  end

  if(pointarray == nil) then
    return;
  end

  if self.detectType ~= videodefined.detectType.HandClassify then
    --转换为屏幕坐标
    local screenPointArray = {};
    local pointarraysize = pointarray:Size();
    for i = 1,pointarraysize do
      local pixelPoint = pointarray:Get(i);
      local sx,sy = self:ToRelativeCoordinates(pixelPoint:x(),pixelPoint:y());
      table.insert(screenPointArray,{sx,sy});
    end
    self.pointarray = screenPointArray;
    self.newupd = false;
  else
    -- 手势检测模块 返回对应的 vector<vector2f> 数据定义格式由detect.lua解析
    self.pointarray = pointarray;
    self.newupd = false;
  end

end

function detectservice:GetCount(datatype)

  if( detection == nil or DetectShell == nil) then
    return 0 ;
  end

  if(not (self.detectMark and self.DetectInit == true)) then
    return 0 ;
  end

  if (self.detection:GetInitStatus() == videodefined.MLInitStatus.INITING) then
    --LOG("bvt initing")
    LOG("INITING");
    return 0 ;
  end

  --self.detection:ClearCache();
  --self.detection:EndOfFrame();
  --self.detection:SetMode(videodefined.MLDetectMode.IMAGE);


  local count = self.detection:GetCount(datatype);

  return count ;

end

function detectservice:GetData(index, datatype)

  if( detection == nil or DetectShell == nil) then
    return nil;
  end

  if(not (self.detectMark and self.DetectInit == true)) then
    return nil;
  end

  --LOG("index = "..tostring(index)..","..tostring(datatype))
  local data = self.detection:GetData(index, datatype);
  return data ;

end


return detectservice;