local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local defined = require "superme3d.defined"
local beholder = require "superme3d.observer"
local utility = require "superme3d.utility"
local Object = require "classic"
local TransNode = require "apolloutility.apollonode.trasnnode"
local apolloDefine = require "apolloutility.defiend"

local NodeManager = {}

local function _CreateSmallCube()
  local target = apollonode.MeshNode();
  target:CreateResource(
    "comm:documents/model/cube.mesh", 
    "comm:documents/material/lightingonly.material");
  target:SetBindBox(
    mathfunction.Aabbox3d(
      mathfunction.vector3(-0.5,-0.5,-0.5),
      mathfunction.vector3(0.5,0.5,0.5)));
  target:SetLocalScale( mathfunction.vector3(0.13,0.13,0.13) );
  return target;
end

function NodeManager:Initialize()
  self.parentNode = apollonode.TransNode();
  --self.parentNode:SetLocalScale(mathfunction.vector3(0.8,0.8,0.8));
  --self.parentNode:SetLocalPosition(mathfunction.vector3(0,0.02,0.0));
  self.itemType2meshNodes = {};
  self.itemType2exclusionType = {};
  self.softbodies = {};
  self.skeletonNode = nil;
  self.blendshape_nodes = {};
  self.emoji = TransNode();

  --注册监听事件
  self:RegisterEvents();
  

  
end

function NodeManager:RegisterEvents()
  self.OnCreateMeshNodeEvent = utility:CreateInovation(self,self.ChangeMeshNode)
  self.OnCreateMeshNodeFinishedEvent = utility:CreateInovation(self,self.ChangeMeshNodeFinished);
  self.OnCreateSkeletonFinishedEvent = utility:CreateInovation(self,self.SkeletonLoaded);
  self.OnCreateBulletFinishedEvent = utility:CreateInovation(self,self.BulletLoaded);
  self.OnUpdateEvent = utility:CreateInovation(self,self.Update);
  self.OnUpdateIKEvent = utility:CreateInovation(self,self.UpdateIK);
  self.OnUpdateCLEvent = utility:CreateInovation(self,self.UpdateCL);
  self.OnUpdatePoseEvent = utility:CreateInovation(self,self.UpdatePose);
  self.OnCreateBlendshapeNodeEvent = utility:CreateInovation(self,self.BlendshapeNodeCreated);
  self.OnUpdateExpression = utility:CreateInovation(self,self.UpdateExpression);

  beholder.observe(defined.Event.ON_CREATE_MESH_NODE,self.OnCreateMeshNodeEvent);
  beholder.observe(defined.Event.ON_CREATE_MESH_NODE_FINISHED,self.OnCreateMeshNodeFinishedEvent);
  beholder.observe(defined.Event.ON_CREATE_SKELETON_FINISHED,self.OnCreateSkeletonFinishedEvent);
  beholder.observe(defined.Event.ON_CREATE_BULLET_FINISHED,self.OnCreateBulletFinishedEvent);
  beholder.observe(defined.Event.ON_UPDATE,self.OnUpdateEvent);
  beholder.observe(defined.Event.ON_UPDATE_IK,self.OnUpdateIKEvent);
  beholder.observe(defined.Event.ON_UPDATE_CL,self.OnUpdateCLEvent);
  beholder.observe(defined.Event.ON_UPDATE_POSE,self.OnUpdatePoseEvent);
  beholder.observe(defined.Event.ON_CREATE_BLENDSHAPE_NODE,self.OnCreateBlendshapeNodeEvent);
  beholder.observe(defined.Event.ON_UPDATE_EXPRESSION,self.OnUpdateExpression);
end



function NodeManager:_ProcessDefaultUnits()
  for k,v in pairs(self.itemType2exclusionType) do
    local itemType = k;
    local exclusionList = v;
    for i = 1, #exclusionList do
      local exclusionType = exclusionList[i];
      if self.itemType2meshNodes[exclusionType] ~= nil then
        self.itemType2meshNodes[itemType]:SetShow(false);
      end
    end
  end
end


function NodeManager:ChangeMeshNodeFinished()
  self:_ProcessDefaultUnits();  --处理默认部件显示与否
end

--骨骼和动画解析完毕
function NodeManager:SkeletonLoaded(SkeletonNodeInfo)
  --skeletonNode
  self.skeletonNode = SkeletonNodeInfo[2];
  self.skeletonNodePose = SkeletonNodeInfo[3];
  self.skinNodes = {};
  for k,v in pairs(self.itemType2meshNodes) do
    --skinrendernode
    v:SetSkeleton(SkeletonNodeInfo);
    if k == "skirt" or k == "DollHair" then
      table.insert(self.skinNodes, v);
    end 
  end
  
    self.cubes = {}
  --for _, name in ipairs(bonenamemapping) do
   -- local cube = _CreateSmallCube()
   -- self.cubes[name] = cube;
  --  self.cubes[name]:SetShow(false);
  --end
  
  self.neckJ = self.skeletonNode.skeleton:GetHostNode():GetNodeByName("m_avg_Neck");
  --for i = 1, #self.blendshape_nodes do
  --    self.neckJ:AttachNode(self.blendshape_nodes[i].node);
  --end

end

function NodeManager:BulletLoaded(Bulletnode)
	table.insert(self.softbodies, Bulletnode);
end


function NodeManager:ChangeMeshNode(meshNodeInfo)
  local itemType = meshNodeInfo[1];   --itemType是部件分类（比如：上装，下装，鞋子，袜子..)
  local exclusionInfo = meshNodeInfo[2];  --这里面包含的部件被夹在，则此部件隐藏（换装方案)
  local meshNode = meshNodeInfo[3];
  
  local currentNode = self.itemType2meshNodes[itemType];
  if currentNode then
    currentNode:SetShow(false);
    currentNode = nil; --释放？
  end
  self.itemType2meshNodes[itemType] = meshNode;
  self.parentNode:AttachNode(meshNode);
  if exclusionInfo then
    self.itemType2exclusionType[itemType] = exclusionInfo;
  end
  
  meshNode:SetShow(true);
end

function NodeManager:GetMeshNode(itemType,idx)
  return self.itemType2meshNodes[itemType]:GetSubNode(idx);
end
--{def, pos3d}

function NodeManager:UpdatePose(data)
  local pos3d = data[2];
  local cameraT = data[3];
  local cameraR = data[4];
  local targets = nil;
  local rootrot = nil;
  if self.skeletonNodePose then 
    targets,rootrot = self.skeletonNodePose:UpdateSkeleton(pos3d,cameraT,cameraR);
  else
    targets,rootrot = self.skeletonNode:UpdateSkeleton(pos3d,cameraT,cameraR);
    self.skeletonNode:CorrectArmsTwist();
  end
  self.skeletonNode:UpdateTwist();
end

function NodeManager:Update(data)
  local def = data[1]
  if self.softbodies ~= nil then
    def = 1/30;
  
    local scene = apolloengine.SceneManager:GetNativeScene(apolloDefine.default_scene_name);
    local physicsworld = scene:GetPhysicWorld();
    physicsworld:Update(def,20,1/300);
    for k,v in pairs(self.softbodies) do
      v:update();
    end
  end
  
end

function NodeManager:UpdateExpression(data)
  local position = data[2];
  if position ~= nil then
    self.neckJ:GetComponent(apolloengine.Node.CT_TRANSFORM):SetWorldRotation(position.rotation);
    --self.emoji:SetLocalRotation(position.rotation);
  end
  for i = 1, #self.blendshape_nodes do
    self.blendshape_nodes[i]:UpdateExpression(data[3]);
  end
end

function NodeManager:UpdateCL(data)
  local scene = apolloengine.SceneManager:GetNativeScene(apolloDefine.default_scene_name);
  local physicsworld = scene:GetPhysicWorld();
  local collisionInfo = physicsworld:GetPhysicsCollisionInfo()
  if self.skeletonNodePose then
    self.skeletonNodePose:HandleCollider(collisionInfo)
  else
    self.skeletonNode:HandleCollider(collisionInfo)
  end
end

function NodeManager:UpdateIK(data)
  local cameraT = data[1];
  local cameraR = data[2];
  local scores  = data[3];
  if self.skeletonNodePose then
    local curtargets,rootRot = self.skeletonNodePose:GetTargets()
    self.skeletonNode:UpdateTargetsAndKinematics(curtargets,rootRot,cameraT,cameraR,scores)
    --self.skeletonNode:CorrectArmsTwist();
  end
end

function NodeManager:ReleaseResource()
  self.itemType2meshNodes = {};
  self.skeletonNode = nil;
  self.parentNode = nil;
end

function NodeManager:GetSoftbodies()
    return self.softbodies;
end

function NodeManager:BlendshapeNodeCreated(modelInfo)
  table.insert(self.blendshape_nodes, modelInfo[1]);
  self.emoji:AttachNode(modelInfo[1]);
end

NodeManager:Initialize();

return NodeManager;


