local apolloDefine = require "apolloutility.defiend"
apolloDefine.default_scene_name = "facecuteScene"

local venuscore = require "venuscore"

--if _KRATOSEDITOR then
--  local path = venuscore.IFileSystem:PathAssembly("scrs:fakelikeapp.lua");
--  local f = loadfile(path);
--  package.preload["likeapp"] = f
--end

local particleupdateservice = require "apolloutility.apollonode.asyncparticle.particleupdateservice"
local textureloader = require "apolloutility.asynctexture.textureloader"
local asynctexture = require "apolloutility.asynctexture.asynctexture"

local facelift;

local GestureAnimation = require "gesturemagic.gestureanimation"
local renderqueue = require "apolloutility.renderqueue"
local pbrlighting = require "apolloutility.pbrlighting"
local scenetimerender = require "apolloutility.scenetimerender"
local apollonode = require "apolloutility.apollonode"
local emptyimage = require "apolloutility.emptyimage"
local blendshape = require "emoji.emoji"
local lightgame = require "lightgame.lightgame"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local facecute = require "facecute"
local filter = require "filter"
local pupil = require "pupil.pupilmanager"
local likeapp = require "likeapp"
local soundplayer = require "soundplayer"
local faceinfo = require "videodecet.faceinfo";
require "utility"
local faceseg = require "videodecet.faceseg"
local posture = require "facecute.estimates.transposture";
--local avatar = require "avatar.avatartest"
local photomood = require "photomood.photomoodmanager"
local biugo = require "biugo.biugomanager"
local stylishFilter = require "stylish_filter.stylish_filters"
local vj = require "venusjson"
local nefelivfx = require "nefelivfx"
local blingeffect = require "blingbling.blingbling"
local lineeffect = require "lineeffect.line"
local posteffectfilter = require "posteffect_filter"
local videodefined = require"videodecet.defined"
local editorscene = require "editorscene.editorscenemanager"
--local editorscene = require "editorscene.editorscenemanager"
--local EditorSticker = require "editorscene.stickermanager"
local SceneLoader = require "editorscene.sceneloader"
local editormakeup = require "editorscene.editormakeupmanager"
local EditorStylish = require "editorscene.editor_stylish_manager"
local makeup = require"beauty.facecute_makeup"
local AsyncImageLoader = require "apolloutility.async_image_loader.async_image_loader"
local facedefined = require "facecute.facechange.facedefined"
local detectmagic = require "newmagic.detectmagic"
local venusjson = require "venusjson"
local Record = require "event.record"
local UserCall = require "event.user_call_event"
local TC = require "bluecore.base.transaction_center"
local ObjectStateWrapper = require "object_state_wrapper"
local Keyboard = require "apolloengine.inputdelegate.keyboarddelegate"
local ED = require "bluecore.eventdispatcher"
local BD = require "bluecore.bluedefined"
local ProfileScope = venuscore.ProfileScope

local faceReshape;

local face_beauty;

math.randomseed(tostring(os.time()):reverse():sub(1, 6))
  
--local verbo = require("jit.v")
--verbo.start()

--暂时关闭JIT防止JIT失败导致的效率下降
if _PLATFORM_ANDROID or _PROFILER then
  jit.off();
  jit.flush();
  LOG("turn off jit")
end

if _PLATFORM_WINDOWS then
  collectgarbage("setpause",200);
  collectgarbage("setstepmul",3000);
end

-- local LAYER_EDITOR_MAKE_UP   = renderqueue.CAMERA_LAYER_FIRST + 1
-- local LAYER_FACE_LIFT = renderqueue.CAMERA_LAYER_FIRST + 2
-- local LAYER_SHARPEN = renderqueue.CAMERA_LAYER_FIRST + 3
-- local LAYER_STYLISH = renderqueue.CAMERA_LAYER_FIRST + 4
-- local LAYER_MAKE_UP = renderqueue.CAMERA_LAYER_ZERO + 9
-- local LAYER_STICKER = renderqueue.CAMERA_LAYER_ZERO
-- local LAYER_LAST = renderqueue.CAMERA_LAYER_LAST

local LAYER_FACE_BEAUTY = "FaceBeautify"
local LAYER_EDITOR_MAKE_UP   = "EditorMakeUp"
local LAYER_MAKE_UP = "MakeUp"
local LAYER_FACE_LIFT = "FaceLift"
local LAYER_SHARPEN = "Sharpen"
local LAYER_STYLISH = "Stylish"
local LAYER_STICKER = "Sticker"
local LAYER_LAST = "Output"


local RESOURCE_TYPE_FILTER = 1;
local RESOURCE_TYPE_MAKEUP = 2;
local RESOURCE_TYPE_STICKER = 3;
local RESOURCE_TYPE_STYLISH = 3;
local RESOURCE_TYPE_FACE_BEAUTY = 4;

local main = {}

_NeedPause = function()
  main:_NeedPause();
end

if _KRATOSEDITOR then
  main._Agent = main;
else  
  g_callbackhandle = main;
  gMain = main
  
  --初始化回调
  main.servicecallbacks = {}
  main.callbackindex = 1;
  setmetatable(main.servicecallbacks, {__mode = "v"}) --弱引用 
  --以下为固定接口
  function main:RegisterCallback(func)
    local index = self.callbackindex;
    self.callbackindex = self.callbackindex + 1;
    self.servicecallbacks[index] = func;
    return self._Agent, index;
  end

  function main:CallbackFunction(index, ...)
    --_COROUTINES_ON();
    local func = self.servicecallbacks[index];
    local res = true;
    if func then
      res = func(...);
    end
    --_COROUTINES_OFF();
    return res;
  end

  
  function main:Exec(command)
    local f = load("return gMain:" .. command)
    if f == nil then
        return false
    end
    return f()
  end
end

function main:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;

  self.cumtime = self.cumtime + def;
  self.fps = self.fps + 1;
  if self.cumtime > 5 then
    local fps = self.fps / self.cumtime;
    self.fps = 0;
    self.cumtime = 0;
    LOG("logic fps "..fps);
  end
  --防止间隔过长导致效果突变太大效果不自然
  def = def < 0.1 and def or 0.03;
  return def;
end

function main:OnResizeView(x,y,w,h)
  facecute:OnResizeView(w,h);
  if facelift ~= nil then
  	facelift:OnResizeView(w,h)
  end
end

function main:PreloadingMaterial()
  self.preloadservice = venuscore.IServicesSystem:Create("apolloutility.preloadservice");
  self.preloadservice:Loading();
end

--size,video表示视屏纹理尺寸和id,size为table
function main:Initialize()
  _COROUTINES_ON();
  
  --创建一个facecute的场景
  self.facecuteScene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  
  
  self.isloaded = false;
  --初始化服务回掉注册体系
  textureloader:Initialize();
  --self:PreloadingMaterial();
  local mainCamera = self:_CreateCameras(
    0.01,
    20,
    mathfunction.vector3(0,0,0),
		mathfunction.vector3(0,0,-1),
    mathfunction.vector3(0,1,0)
  );

  emptyimage:Initialize();
  pbrlighting:Initialize();--对PBR材质中的贴图的slot进行初始化
  scenetimerender:Initialize();
  
  
  renderqueue:Initialize(mainCamera);
  renderqueue:Activate(LAYER_LAST);
  videodecet:Initialize("test:palm/","output%04d.jpg", "point.txt");
  facecute:Initialize(mainCamera);
  SceneLoader:Initialize();
  lightgame:Initialize(mainCamera);  
  filter:Initialize(LAYER_LAST); 
  biugo:Initialize(mainCamera);
  pupil:Initialize(mainCamera);
  photomood:Initialize(mainCamera);
  particleupdateservice:Initialize();
  blendshape:Initialize();
  stylishFilter:Initialize(LAYER_STYLISH);
  nefelivfx:Initialize(LAYER_LAST);
  blingeffect:Initialize(LAYER_STYLISH)
  lineeffect:Initialize(LAYER_STYLISH)
  posteffectfilter:Initialize(LAYER_STYLISH)
  editorscene:Initialize(LAYER_STICKER,RESOURCE_TYPE_STICKER);
  editormakeup:Initialize(LAYER_EDITOR_MAKE_UP,RESOURCE_TYPE_MAKEUP); --加载编辑器贴纸传入前一个layer（商汤美妆layer）
  EditorStylish:Initialize(LAYER_STYLISH,RESOURCE_TYPE_STYLISH);
  detectmagic:Initialize(LAYER_STICKER,RESOURCE_TYPE_STICKER);
  
  self.resourceNodesId = {};
  if _PLATFORM_WINDOWS then
    
    --local node = apollonode.VirtualNode();
    --renderqueue:Queue("Sticker-1",node);
    --self:FacecuteLoadResource("test:2011/cutme.json");
    --self:FacecuteLoadResource("test:2859/detectmagic_blink/detectmagic.json");
    --加载场景
    --editorscene:LoadSceneByFilePath("test:kiki/kiki_0814_beta1.scene","scrs:../../")
    --self:SetMakeupForType(facedefined.makeupType.editorlip,"test:499/scene.json");
    --self:LoadStylishFilter("docs:soft_light_3/soft_light_3.json");
    --测试使用 强制打开人脸检测 (放在facecute后面)
    faceseg:SetSegMark(videodefined.detectType.Face,true)
  else
    --asynctexture.SetMaxfps(15);
  end
  
  apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "SyncUpdate");--添加同步更新
  apolloengine.Framework:AddKeyboardCallback(self._Agent, "OnKeyboard");
  apolloengine.Framework:AddTouchCallback(self._Agent, "OnTouch");

  self.running = false;

  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.cumtime = 0;
  self.fps = 0;  

  --瘦脸是否开启
  self.faceliftopen = false;
  self.faceliftloading = false;
  
  --磨皮是否开启 
  self.skinsmoothopen = false;
  self.skinsmoothloading = false;
  --美白是否开启
  self.skinbrightopen = false;
  self.skinbrightloading = false;
  
  --是否有美妆
  self.ismakeup = false;
  self.isedimakeup = false;
  --self:SetMakeupForType(facedefined.makeupType.cosmetic,"E:/work/facecute_project/TestResource/currentscene/scene.json");
  --self:SetMakeupForType(facedefined.makeupType.editorlip,"test:fugunew/scene.json");

  -- 蓝图onRecordStart Cnt避免在update间隔start stop多次
  self.recordStartCnt = 0 ;
  self.recordStopCnt = 0 ;

  -- 美颜微调是否开启
  self.facebeautyloaded  = false;
  self.facebeautyloading = false;

  -- 微整形算法
  self.facereshapeloading = false;
  self.facereshapeloaded  = false;
  self.facereshapeversion = 0;

  LOG("initialize done");
  
  -- self:SetFaceliftLevelforType(4, 500, 1)
  -- self:SetFaceliftLevel(220, 140, 1, 0, 0, true)
  --renderqueue:TestInsertCameras()

  TC:SetOnRequest( function(requestType, requestId, timeout, jsonData)
    if likeapp.AI.OnRequest then
      likeapp.AI:OnRequest(requestType, requestId, timeout, jsonData)
    end
  end );

  _PROFILER_START();
  _COROUTINES_OFF();
  return true;
end


function main:_DispatchScreenRotation()
  local staticID = BD.Event.ScreenRotationChangePath
  if ED:HasCompListener(staticID) then
    -- someone want rotation data
    local type = BD.Event.ScreenRotationEvent.SCREEN_ROTATION_CHANGE
    local hasRotation = ED:HasEventListener(staticID, type);
    if hasRotation then
      local rotation = likeapp.AI:GetScreenRotation();
      local event = {
        staticID = staticID;
        eventType = type;
        params = rotation;
      };
      ED:PushEvent(event);
    end
  end
end

-- 手势缩放 和 旋转
function main:_DispatchTouchGesture()

  local eBegin = BD.Event.GestureGlobalEvent.GESTURE_BEGIN
  local eKeep  = BD.Event.GestureGlobalEvent.GESTURE_KEEP
  local eEnd   = BD.Event.GestureGlobalEvent.GESTURE_END

  local tBegin = apolloengine.SensorsTrackingComponent.VALUE_GESTURE_BEGIN
  local tKeep = apolloengine.SensorsTrackingComponent.VALUE_GESTURE_KEEP
  local tEnd = apolloengine.SensorsTrackingComponent.VALUE_GESTURE_END

  local staticID = BD.Event.GestureScalePath
  local actionSystem = apolloengine.IActionSystem

  if ED:HasCompListener(staticID) then

    local sensorType = apolloengine.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_SCALE

    local number = actionSystem:GetSensorDataCount(sensorType)
    for i = 1, number do
      local result = actionSystem:GetSensorDataByIndex(sensorType, i);
      local eventType
      if result.value == tBegin then
        eventType = eBegin
      elseif   result.value == tKeep then
        eventType = eKeep
      elseif result.value == tEnd then
        eventType = eEnd
      end
      if eventType ~= nil then
        local event = {
          staticID = staticID;
          eventType = eventType;
          params = result ; -- params is {value = KEEP, code = scaleValue, x = 0.0, y = 0.0 } -- scale center or rotate center
        };
        ED:PushEvent(event);
      end
    end

  end


  staticID = BD.Event.GestureRotatePath
  if ED:HasCompListener(staticID) then

    local sensorType = apolloengine.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_ROTATE

    local number = actionSystem:GetSensorDataCount(sensorType)
    for i = 1, number do
      local result = actionSystem:GetSensorDataByIndex(sensorType, i);
      local eventType
      if result.value == tBegin then
        eventType = eBegin
      elseif   result.value == tKeep then
        eventType = eKeep
      elseif result.value == tEnd then
        eventType = eEnd
      end
      if eventType ~= nil then
        local event = {
          staticID = staticID;
          eventType = eventType;
          params = result ; -- params is {value = KEEP, code = scaleValue, x = 0.0, y = 0.0 } -- scale center or rotate center
        };
        ED:PushEvent(event);
      end
    end

  end

end

function main:OnTouch(touchinfo)

  if ED:HasCompListener(BD.Event.TouchGlobalPath) then

    local ePress = BD.Event.TouchGlobalEvent.TOUCH_PRESS
    local eMove = BD.Event.TouchGlobalEvent.TOUCH_MOVE
    local eRelease = BD.Event.TouchGlobalEvent.TOUCH_RELEASE
    local path = BD.Event.TouchGlobalPath

    local tPress = apolloengine.TouchInfo.TT_PRESS
    local tMove = apolloengine.TouchInfo.TT_MOVE
    local tRelease = apolloengine.TouchInfo.TT_RELEASE

    local hasPress = ED:HasEventListener(path, ePress)
    local hasMove = ED:HasEventListener(path, eMove)
    local hasRelease = ED:HasEventListener(path, eRelease )

    local PointCount = touchinfo:GetPointCount();
    for i = 1, PointCount do

      local touchType = touchinfo:GetTouchType(i);

      if touchType == tPress then

        if hasPress then
          local event = {
            staticID = BD.Event.TouchGlobalPath;
            eventType = ePress;
            params = {
              index = touchinfo:GetTouchID(i),
              point = touchinfo:GetTouchPoint(i) -- vector2f
            };
          };
          ED:PushEvent(event);
        end

      elseif touchType == tMove then

        if hasMove then
          local event = {
            staticID = BD.Event.TouchGlobalPath;
            eventType = eMove;
            params = {
              index = touchinfo:GetTouchID(i),
              point = touchinfo:GetTouchPoint(i) -- vector2f
            };
          };
          ED:PushEvent(event);
        end

      elseif touchType == tRelease then

        if hasRelease then
          local event = {
            staticID = BD.Event.TouchGlobalPath;
            eventType = eRelease;
            params = {
              index = touchinfo:GetTouchID(i),
              point = touchinfo:GetTouchPoint(i) -- vector2f
            };
          };
          ED:PushEvent(event);
        end

      end
    end
  end
end


function main:Exit()
  --WARNING("*************************************************************main recoder");
  apolloengine.Framework:RemoveSynchronizeUpdateCallback(self._Agent, "SyncUpdate");
  apolloengine.Framework:RemoveTouchCallback(self._Agent,"OnTouch");
  apolloengine.Framework:RemoveKeyboardCallback(self._Agent,"OnKeyboard");

  self:UnLoadFaceReshape();
  self:UnLoadFaceBeauty();

  local sceneID = self.facecuteScene:GetStaticID();
  apolloengine.SceneManager:DeleteSceneByID(sceneID);
  SceneLoader:ReleaseAllResource();
  --SceneLoader:ReleaseSticker();
  --apolloengine.SceneManager:DeleteScene(apolloDefine.default_scene_name);
  return true;
end

function main:OnKeyboard(key,status)
  _COROUTINES_ON();
  Keyboard:OnKeyboard(key,status);
  _COROUTINES_OFF();
  return true;
end

function main:_CreateCameras(near, far, pos, lookat, up)
  local maincamera = apollonode.CameraNode();--新建摄像机
  --maincamera:CreatePerspectiveProjection(near, far);
  maincamera:SetName("MainCamera")
  maincamera:CreateRealCameraProjection(near, far);--设置摄像机
  maincamera:LookAt(pos, lookat, up);
  maincamera:Recalculate();--手动更新矩阵
  --maincamera:SetClearColor(mathfunction.Color(0.0,1.0,1.0,1));
  --maincamera:Activate();--激活主摄像机
  return maincamera
end

--设置摄像机FBO
function main:AttachRenderTarget(fbo, texture)
  LOG("platform android, fbo:"..fbo);
  self.rendertarget = apolloengine.RenderTargetEntity();--创建一个FBO
  self.rendertarget:PushMetadata(--设置FBO格式
          apolloengine.RenderTargetResourceMetadata(
                  apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
                  apolloengine.Framework:GetResolution(),--分辨率
                  fbo));
  self.outputtexture = self.rendertarget:MakeTextureAttachment(
          apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  self.outputtexture:PushMetadata(--创建纹理
          apolloengine.TextureResourceMetadata(
                  apolloengine.Framework:GetResolution(),
                  texture));
  self.rendertarget:CreateResource();
  renderqueue:SetOutputRenderTarget(self.rendertarget, self.outputtexture)
  return true ; 
end

--设置摄像机采集图片尺寸和id
function main:SetVideoTexture(size, video)
  videodecet:SetTexture(size, video);
  apolloengine.DeviceResource:PushDeviceResource(
    apolloengine.DeviceResource.DEVICE_CAPTURE,
    videodecet:GetVideoTexture());

  likeapp.AI:OnUpdateStream(videodecet:GetVideoFrame());

  collectgarbage();

  return true;
end

function main:SetMaskVideoTexture(texid,size)
  biugo:SetMaskVideoTexture(texid,size);
  photomood:SetMaskVideoTexture(texid,size);
  return true;
end

function main:DoMorph(indiceslist, showtimelist, transtimelist)
  return biugo:DoMorph(indiceslist, showtimelist, transtimelist);
end

function main:UpdateMuglifeMaterial()
  return biugo:UpdateMuglifeMaterial();
end

function main:SetLyric(lyricTextureID,lyricColor,lyricDuration,lyricSize,lyricPosition,isNew)
  photomood:SetLyric(lyricTextureID,lyricColor,lyricDuration,lyricSize,lyricPosition,isNew);
  return true;
end

function main:SetQuotation(lyricTextureID,lyricColor,lyricDuration,lyricSize,lyricPosition,isNew)
  photomood:SetQuotation(lyricTextureID,lyricColor,lyricDuration,lyricSize,lyricPosition,isNew);
  return true;
end


function main:ShowLyric(isShow)
  photomood:ShowLyric(isShow);
  return true;
end

function main:ClearLyric()
  photomood:ClearLyric();
  return true;
end

function main:ShowQuotation(isShow)
  photomood:ShowQuotation(isShow);
  return true;
end

function main:ClearQuotation()
  photomood:ClearQuotation();
  return true;
end

--重置detectmagic 漫画效果(回到第一阶段)
function main:ResetStickerEffect()
  
  return detectmagic:ResetStickerEffect();
end

--重置detectmagic时间线 倒计时类型的漫画贴纸
function main:ResetTimeline()
  return detectmagic:ResetTimeline();
end


function main:ThreadExit()
    LOG("[ThreadExit] collectgarbage start");
    textureloader:Clear();
    collectgarbage();
    LOG("[ThreadExit] collectgarbage end");
    return true ;
end


function main:GetStickerResult()
  return lightgame:GetStickerResult();
end

--如何触发重新加载素材？
--重新加载素材需要素材路径，到这怎么传递
--并不是所有的贴纸都需要重新加载
function main:OnRecordStart()
  lightgame:OnRecordStart();
  filter:OnRecordStart();
  stylishFilter:OnRecordStart()
  SceneLoader:OnRecordStartSticker(); --目前只处理贴纸，其他暂不处理
  EditorStylish:OnRecordStart()
  self.recordStartCnt = self.recordStartCnt + 1 ;
  return true;
end

function main:OnRecordStop()
  lightgame:OnRecordStop();
  self.recordStopCnt = self.recordStopCnt + 1;
  return true;
end

function main:UserCall(EventType, extraInfo)
  UserCall:Call(EventType, extraInfo);
  return true -- 目前事件是同步处理的
end

function main:PushResponse(request_type, request_id, jsonData)
  WARNING("[PushResponse] "..tostring(request_type)..","..tostring(request_id)..","..tostring(jsonData))
  TC:Response(request_type, request_id, jsonData)
end

--加载换脸配置表
function main:FacecuteLoadResource(path)
  _COROUTINES_ON();
  --self.facecuteScene:Begin("Sticker");
  if not venuscore.IFileSystem:isFileExist(path) then
    ERROR("FacecuteLoadResource "..tostring(path).." not exist");
    return false ;
  end

  videodecet:resetDetectFlag();
  local res =
    facecute:LoadConfig(path)
    and lightgame:LoadConfig(path)
    and filter:LoadConfig(path)
    --and pupil:LoadConfig(path) 有内存释放BUG，6个node未释放。
    and photomood:LoadConfig(path)
    and biugo:LoadConfig(path)
    and blendshape:LoadConfig(path)
    and SceneLoader:LoadAsSticker(path)
    and detectmagic:LoadConfig(path)
  res = nefelivfx:LoadConfig(path) or res
  if res then
    particleupdateservice:AsyncUpdate();    
  end
  self.isloaded = res;
  videodecet:launchDetectFlag();

  --防止时间间隔过长导致第一次update曲线取值跳跃太大
  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  --self.facecuteScene:End("Sticker");
  collectgarbage();

  _COROUTINES_OFF();
  return self.isloaded;
end
--释放换脸资源
function main:FacecuteUnloadResource()
  _COROUTINES_ON();
  self.isloaded = false;
  self.recordStartCnt = 0;
  self.recordStopCnt = 0 ;
  asynctexture.Wait();
  videodecet:resetDetectFlag();
  facecute:ReleaseResource();
  lightgame:ReleaseResource();
  filter:ReleaseResource();
  pupil:ReleaseResource();
  photomood:ReleaseResource();
  biugo:ReleaseResource();
  blendshape:ReleaseResource();
  nefelivfx:ReleaseResource();
  SceneLoader:ReleaseSticker();
  --editorscene:ReleaseResource();
  detectmagic:ReleaseResource();
  --renderqueue:Clear(LAYER_STICKER, LAYER_LAST)
  renderqueue:Deactivate(LAYER_STICKER)
  asynctexture.Clear();
  particleupdateservice:Clear();
  venuscore.IFileSystem:SetResourcePath("");
  collectgarbage();
  _COROUTINES_OFF();
  self:UpdateMakeup();
  
  return true;
end


function main:_Running()
  _COROUTINES_ON();
  --local def = self:Timespan();
  --soundplayer.ResetVolume();

  if self.recordStopCnt ~= 0 or self.recordStartCnt ~= 0 then
    if self.recordStartCnt > self.recordStopCnt then
      Record:OnRecordStart();
    else
      Record:OnRecordStop();
    end
    self.recordStopCnt = 0 ;
    self.recordStartCnt = 0;
  end

  self:_DispatchScreenRotation();
  self:_DispatchTouchGesture();

  local def = self.def;
  local cnnsegMark = faceseg and faceseg:GetSegmentMark() or false;
  if(not cnnsegMark ) 
  then
     videodecet:Update(def);
  end
  
  if self.isMakeup or self.isloaded then
    posture:Reset();
  end

  if self.isMakeup then
    makeup:Update(def);
  end

  --更新makeup美妆mask node，由于mask node是动态创建的，无法通过scene来调用update，在此处调用
  --apolloengine.SceneManager:UpdateMakeupMask(def);
  self:UpdateMakeupMask(def)
  
  if self.isedimakeup then
    editormakeup:Update(def);
  end

  self:UpdateFaceBeauty(def);

  if self.facereshapeversion > 1 then
    self:UpdateFaceReshape(def);
  end

  --avatar:Update(def);
  if self.isloaded and not self.running then--and likeapp.AI:RefreshedRawarray() then
    --if(soundplayer.ResetVolume) then
    --  soundplayer.ResetVolume();
    --end
    self.running = true;
    --posture:Reset();
    
    --收集贴纸的node
    ObjectStateWrapper.Update()
    facecute:Update(def,mainCamera);
    blendshape:Update(def);
    lightgame:Update(def);
    filter:Update(def);
    pupil:Update(def);
    biugo:Update(def);
    photomood:Update(def);
    nefelivfx:Update(def)
    SceneLoader:UpdateSticker(def);
    detectmagic:Update(def);
    particleupdateservice:AsyncUpdate();

    TC:Update(def);
    self.running = false;
  end
  
  --收集风格滤镜的node
  stylishFilter:Update(def)
  blingeffect:Update()
  lineeffect:Update()
  posteffectfilter:Update(def)
  EditorStylish:Update(def)
  _PROFILER_UPDATE();
  _COROUTINES_OFF();
end

function main:Ontime()
  self:_Running();
end

function main:Update() 
  self:_Running();
end

function main:SyncUpdate()
  --_COROUTINES_ON();
  local def = self:Timespan();
  self.def = def;
  local cnnsegMark = faceseg and faceseg:GetSegmentMark() or false;
  --  LOG("cnnsegMark = "..tostring(cnnsegMark).." self.runningsync = "..tostring(self.runningsync))
  if(not self.runningsync)
  then
      self.runningsync = true;  -- androidvideodetect -- faceseg --facecnndetect--mldetection--C++Obj
                                --                               --haircnnseg--mlseg--C++Obj
      if cnnsegMark then        -- 有检测模块被使能 -- 检测106,动态表情,手势
        videodecet:Update(def); -- faceseg 根据mask来确定 mldetection是否检测
        faceseg:RunSegment();   -- faceseg 根据mask并且 facecnndetect/haircnnseg 根据servicecallbacks存在并回调返回ture才检测
      end
      self.runningsync = false;
  end  
  self:_Running();
  --_COROUTINES_OFF();
end

function main:EnablePostEffect(enable)
  if enable == true then
    if not self.post then
      self.post = renderqueue:GetCamera("Output"):CreatePostEffect();
      self.post:CreateResource("comm:script/apolloengine/posteffect/pdenoise.lua")
    else
      self.post:Enable();
    end    
  else
    if self.post then
      self.post:Disable()
    end    
  end
  collectgarbage();
  return true;
end


function main:SetFaceliftLevel(eyecoef,facecoef,chincoef,nosecoef,mouthcoef,isNew)
  LOG("SetFaceliftLevel " .. string.format("%f %f %f %f %f", eyecoef,facecoef,chincoef,nosecoef,mouthcoef))
  self.eyecoef = eyecoef;
  self.facecoef = facecoef;
  self.chincoef = chincoef;
  self.nosecoef = nosecoef
  self.mouthcoef = mouthcoef
  if not self.faceliftloading then --这个修改是解决服务重入导致facelift多次初始化的问题
    if self.faceliftopen == false then

      facelift = require "beauty.newfacelift"
      self.faceliftopen = true;
      self.faceliftloading = true;
      renderqueue:Activate(LAYER_FACE_LIFT)
      
      --收集瘦脸的node
      --self.facecuteScene:Begin("Facelift");
      facelift:Initialize(renderqueue:GetCamera(LAYER_FACE_LIFT));
      --self.facecuteScene:End("Facelift");
     
      if isNew and isNew == true then
        facelift:setWarpLevel(self.eyecoef,self.facecoef,self.chincoef,self.nosecoef,self.mouthcoef);
      else
        facelift:setWarpLevel(self.eyecoef,self.facecoef,self.chincoef);
      end
      videodecet:AddNewframeCallback(facelift:NewframeCallback());
      self.faceliftloading = false;
    else
      if isNew and isNew == true then
        facelift:setWarpLevel(self.eyecoef,self.facecoef,self.chincoef,self.nosecoef,self.mouthcoef);
      else
        facelift:setWarpLevel(self.eyecoef,self.facecoef,self.chincoef);
      end
    end
	return true
  else
    LOG("skip")
	return false
  end
  return true;
end

-- version num: 0 for likee, 1 for live, 2 for autotoucher
function main:SetFaceliftLevelforType(typeid, coef, versionnum)

  -- NOTE(Yang Min): set face reshape coef with autotoucher process
  if versionnum > 1 then
      self:SetFaceReshapeStrengthWithType(typeid, coef);
      self.facereshapeversion = versionnum;
      return true;
  end

  if self.faceliftopen == false then
    if versionnum == 0 then
      facelift = require "beauty.facelift_likee"
    else
      facelift = require "beauty.facelift_live"
    end
    self.faceliftopen = true;
    renderqueue:Activate(LAYER_FACE_LIFT)
    
    --收集瘦脸的node
    facelift:Initialize(renderqueue:GetCamera(LAYER_FACE_LIFT), versionnum);
    
    videodecet:AddNewframeCallback(facelift:NewframeCallback());
  end
  facelift:setWarpLevelforType(typeid, coef, versionnum);
  return true;
end

function main:InitFaceLift(isNew)

    if self.facereshapeversion > 1 then
        return true;
    end

    facelift = require "beauty.newfacelift"
    renderqueue:Activate(LAYER_FACE_LIFT)
    
    --收集瘦脸的node
    --self.facecuteScene:Begin("Facelift");
    facelift:Initialize(renderqueue:GetCamera(LAYER_FACE_LIFT))
    --self.facecuteScene:End("Facelift");
    
    facelift:setWarpLevel(0,0,0,0,0);
    videodecet:AddNewframeCallback(facelift:NewframeCallback())
    self.faceliftopen = true
    return true
end

function main:ReleaseFaceLift()

  if self.facereshapeversion > 1 then
    -- self:UnLoadFaceReshape();
    self.facereshapeversion = 0;
    return true;
  end

  if self.faceliftopen == true then
    videodecet:RemoveNewframeCallback(facelift:GetNewframeCallback())
    facelift:Release()
    renderqueue:Deactivate(LAYER_FACE_LIFT)
    self.faceliftopen = false
    --self.facecuteScene:ReleaseAsset("Facelift");
    collectgarbage();
    --apolloengine.Framework:ForceClear();
  end
  return true
end

function main:SetParameterOfFaceLift(eyecoef, facecoef, chincoef)
    if not self.faceliftopen then
      return false
    end
    facelift:setWarpLevel(eyecoef, facecoef, chincoef);
    return true
end

function main:SetParameterOfFaceLiftEye(eyecoef)
    if not self.faceliftopen then
      return false
    end
    facelift:setEyeParam(eyecoef);
    return true
end

function main:SetParameterOfFaceLiftFace(facecoef)
    if not self.faceliftopen then
      return false
    end
    facelift:setFaceParam(facecoef);
    return true
end

function main:SetParameterOfFaceLiftChin(facecoef)
    if not self.faceliftopen then
      return false
    end
    facelift:setChinParam(facecoef);
    return true
end

function main:SetShowFaceLift(show)

  if self.facereshapeversion > 1 then
    self:SetShowFaceReshape(show);
  end

  if not self.faceliftopen then
    return false
  end
  if show then
    facelift:Enable()
  else
    facelift:Disable()
  end
  return true
end

--[[
function main:SetSkinSmoothLevel(param)
  LOG("SetSkinSmoothLevel");
  if not self.skinsmoothloading then
    if self.skinsmoothopen == false then
      self.skinsmoothopen = true;
      self.skinsmoothloading = true;
      self.smoothskin = apollonode.PostEffect(); 
      self.smoothskin:CreateResource("scrs:beauty/beauty_smooth.lua");
      self.smoothskin:RegisterParameter("intensity")
      self.smoothskin["intensity"](self.smoothskin, param)
      renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):AttachPostEffect(self.smoothskin)
      renderqueue:Activate(renderqueue.CAMERA_LAYER_FIRST)
      self.skinsmoothloading = false;
    else
      self.smoothskin["intensity"](self.smoothskin, param)
    end
    return true
  else
    LOG("skip")
    return false
  end
  return true;
end

function main:InitSkinSmooth()
    LOG("InitSkinSmooth");
    self.smoothskin = apollonode.PostEffect(); 
    self.smoothskin:CreateResource("scrs:beauty/beauty_smooth.lua");
    self.smoothskin:RegisterParameter("intensity")
    self.smoothskin["intensity"](self.smoothskin, 0.0)
    renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):AttachPostEffect(self.smoothskin)
    renderqueue:Activate(renderqueue.CAMERA_LAYER_FIRST)
    self.skinsmoothopen = true;
    self.skinsmoothstatus = true;
    return true
end

function main:SetParameterOfSkinSmooth(param)
    LOG("SetParameterOfSkinSmooth param:"..param);
    if not self.skinsmoothopen then
      return false
    end
    self.smoothskin["intensity"](self.smoothskin, param/100)
    
    if param == 0 and self.skinsmoothstatus then
      self.smoothskin:Disable()
      self.skinsmoothstatus = false;
      return true;
    elseif param ~= 0 and not self.skinsmoothstatus then
      self.smoothskin:Enable()
      self.skinsmoothstatus = true;
      return true;
    end
    
    return true
end

function main:SetShowSkinSmooth(show)
  if not self.skinsmoothopen then
    return false
  end
  if show then
    self.smoothskin:Enable()
  else
    self.smoothskin:Disable()
  end
  return true
end

function main:ReleaseSkinSmooth()
    if self.smoothskin == nil then
        return true
    end
    renderqueue:Deactivate(renderqueue.CAMERA_LAYER_FIRST)
    renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):DetachPostEffect(self.smoothskin)
    self.smoothskin = nil
    return true
end


function main:SetSkinBrightLevel(param)
  LOG("SetSkinBrightLevel");
  if not self.skinbrightloading then --这个修改是解决服务重入导致facelift多次初始化的问题
    if self.skinbrightopen == false then
      self.skinbrightopen = true;
      self.skinbrightloading = true;
      self.brightskin = apollonode.PostEffect(); 
      self.brightskin:CreateResource("comm:script/apolloutility/posteffect/skinbright.lua");
      self.brightskin:RegisterParameter("intensity")
      self.brightskin["intensity"](self.brightskin, param)
      renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):AttachPostEffect(self.brightskin)
      renderqueue:Activate(renderqueue.CAMERA_LAYER_FIRST)
      self.skinbrightloading = false;
    else
      self.brightskin["intensity"](self.brightskin, param)
    end
    return true
  else
    LOG("skip")
    return false
  end
  return true;
end


function main:InitSkinBright()
    LOG("InitSkinBright");
    self.brightskin = apollonode.PostEffect(); 
    self.brightskin:CreateResource("comm:script/apolloutility/posteffect/skinbright.lua");
    self.brightskin:RegisterParameter("intensity")
    self.brightskin["intensity"](self.brightskin, 0.0)
    renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):AttachPostEffect(self.brightskin)
    renderqueue:Activate(renderqueue.CAMERA_LAYER_FIRST)
    self.skinbrightopen = true;
    self.skinbrightstatus = true;
    return true
end

function main:SetParameterOfSkinBright(param)
    LOG("SetParameterOfSkinBright param:"..param);
    if not self.skinbrightopen then
      return false
    end
    self.brightskin["intensity"](self.brightskin, param/100)
    
    if param == 0 and self.skinbrightstatus then
      self.brightskin:Disable()
      self.skinbrightstatus = false;
      return true;
    elseif param ~= 0 and not self.skinbrightstatus then
      self.brightskin:Enable()
      self.skinbrightstatus = true;
      return true;
    end
    
    return true
end

function main:SetShowSkinBright(show)
  if not self.skinbrightopen then
    return false
  end
  if show then
    self.brightskin:Enable()
  else
    self.brightskin:Disable()
  end
  return true
end


function main:ReleaseSkinBright()
    if self.brightskin == nil then
        return true
    end
    renderqueue:Deactivate(renderqueue.CAMERA_LAYER_FIRST)
    renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):DetachPostEffect(self.brightskin)
    self.brightskin = nil
    return true
end
]]--


function main:InitSharpen()
  if self.sharpen ~= nil then
      return true
  end
  renderqueue:Activate(LAYER_SHARPEN)
  local sharpen = renderqueue:GetCamera(LAYER_SHARPEN):CreatePostEffect();
  if sharpen:CreateResource("comm:script/apolloengine/posteffect/laplacesharp.lua") then
    sharpen:RegisterParameter("sharpStrength")
    sharpen:sharpStrength(mathfunction.vector1(0))
    self.sharpen = sharpen
    return true
  else
    renderqueue:Deactivate(LAYER_SHARPEN)
    return false
  end
end

function main:ReleaseSharpen()
  if self.sharpen == nil then
      return true
  end
  renderqueue:GetCamera(LAYER_SHARPEN):DeletePostEffect(self.sharpen)
  renderqueue:Deactivate(LAYER_SHARPEN)
  self.sharpen = nil
  return true
end

function main:SetParameterOfSharpen(strength)
    if self.sharpen ~= nil then
        self.sharpen:sharpStrength(mathfunction.vector1(strength))
        return true
    end
    return false
end

function main:SetShowSharpen(show)
  if self.sharpen == nil then
    return false
  end
  if show then
    self.sharpen:Enable()
  else
    self.sharpen:Disable()
  end
  return true
end

function main:LoadStylishFilter(path)
    LOG("LoadStylishFilter")
    --收集风格滤镜的node
    --self.facecuteScene:Begin("StylishFilter");
    if self.stylishFilterLoaded then
      self:UnloadStylishFilter()
    end
    local res = false
    renderqueue:Activate(LAYER_STYLISH)
    res = stylishFilter:LoadConfig(path) or res
    res = blingeffect:LoadConfig(path) or res
    res = lineeffect:LoadConfig(path) or res
    res = posteffectfilter:LoadConfig(path) or res
    res = EditorStylish:LoadConfig(path) or res
    if res then
        self.stylishFilterLoaded = true
    else
        self.stylishFilterLoaded = false
        renderqueue:Deactivate(LAYER_STYLISH)
    end
    --self.facecuteScene:End("StylishFilter");
    return true
end

function main:UnloadStylishFilter()
    LOG("UnloadStylishFilter")
    stylishFilter:ReleaseResource()
    blingeffect:ReleaseResource()
    lineeffect:ReleaseResource()
    posteffectfilter:ReleaseResource()
    EditorStylish:ReleaseResource();
    self.stylishFilterLoaded = false
    renderqueue:Deactivate(LAYER_STYLISH)
    
    --释放风格滤镜的Node
    --self.facecuteScene:ReleaseAsset("StylishFilter");
    collectgarbage()
    return true
end

function main:SetShowStylishFilter(show)
    if not self.stylishFilterLoaded then
        return false
    end
    stylishFilter:SetShow(show)
    blingeffect:SetShow(show)
    lineeffect:SetShow(show)
    posteffectfilter:SetShow(show)
    EditorStylish:SetShow(show)
    return true
end

function main:SetDebugPointShow(isShow)
  if _PLATFORM_WINDOWS then
    videodecet:SetDebugPointShow(isShow)
  else
    WARNING("only windows support SetDebugPointShow ");
  end
end

function main:GetNewFaceLandMark()
    return videodecet:GetNewFaceLandMark();
end

function main:SetElapsedTime(def)
  biugo:SetElapsedTime(def);
  return true;
end

--加载美妆
function main:SetMakeupForType(makeuptype,path)
  LOG("SetMakeup Type:"..makeuptype.." Path:"..path);
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig.scene then
    self.PrePath = venuscore.IFileSystem:GetResourcePath();
    renderqueue:Activate(LAYER_EDITOR_MAKE_UP)
    editormakeup:LoadConfig(path,makeuptype,rootconfig)
    self.isedimakeup = true;
    venuscore.IFileSystem:SetResourcePath(self.PrePath);
    return true;
  end

  if _PLATFORM_WINDOWS then
    faceseg:SetSegMark(videodefined.detectType.Face,true)
  end
  
  renderqueue:Activate(LAYER_MAKE_UP)
  makeup:LoadMakeup(makeuptype,path,rootconfig,renderqueue:GetCamera(LAYER_MAKE_UP));
  self.isMakeup = true;
  return true;
end


--移除美妆
function main:RemoveMakeupByType(makeuptype)
  LOG("RemoveMakeup Type:"..makeuptype);
  
  local isEditorMakeup = editormakeup:ReleaseResource(makeuptype);
  if isEditorMakeup == true then
    if not editormakeup:IsExistMakeup() then
      self.isedimakeup = false;
      renderqueue:Deactivate(LAYER_EDITOR_MAKE_UP)
    end
    return true;
  end
  
  local makeupList = makeup:ReleaseMakeup(makeuptype)
  if makeupList == nil or #makeupList < 1 then
    self.isMakeup = false;
    if not self.isloaded then
      if _PLATFORM_WINDOWS then
        faceseg:SetSegMark(videodefined.detectType.Face,false)
      end
      renderqueue:Deactivate(LAYER_MAKE_UP)
    end
  end
  

  return true;
end

function main:LuaGC()
  collectgarbage();
end

--更改美妆强度
function main:SetStrengthForType(maketype, strength)
  LOG("SetStrength Type:"..maketype.." Strength:"..strength);
  if editormakeup:SetMakeupStrength(strength, maketype) then
    return true;
  end
  makeup:SetMakeupStrength(strength, maketype)
  return true;
end

function main:GetMakeupStrengthByType(type)
  return editormakeup:GetMakeupStrengthByType(type)
end

function main:UpdateMakeup()
  if _PLATFORM_WINDOWS then
    if self.isMakeup then
      faceseg:SetSegMark(videodefined.detectType.Face,true)
    end
  end
end

-- face beautify
function main:LoadFaceBeauty()
  LOG("Load FaceBeauty AT");
  if _PLATFORM_ANDROID or _PLATFORM_IOS then

    if not self.facebeautyloading then
        if self.facebeautyloaded == false then
          self.facebeautyloading = true;

          renderqueue:Activate(LAYER_FACE_BEAUTY);
          local camera  = renderqueue:GetCamera(LAYER_FACE_BEAUTY);

          face_beauty = require "facebeautyutils.face_beauty"
          face_beauty:Create(camera:GetSequence(), self.facecuteScene);

          self.facebeautyloading = false;
          self.facebeautyloaded  = true;
        end
        return true;
    end

  end

  return false;
end

function main:UnLoadFaceBeauty()
    if self.facebeautyloading == true then
        return false;
    end

    if self.facebeautyloaded == true then
        face_beauty:Destroy();
        renderqueue:Deactivate(LAYER_FACE_BEAUTY);

        collectgarbage();
        self.facebeautyloaded = false;
    end

    return true;
end

function main:UpdateFaceBeauty(def)
    if not self.facebeautyloaded then
      return;
    end
    local valid = face_beauty:PreUpdate(def);
    if not valid then
        renderqueue:Deactivate(LAYER_FACE_BEAUTY);
    else
        if not renderqueue:IsActive(LAYER_FACE_BEAUTY) then
            renderqueue:Activate(LAYER_FACE_BEAUTY);
        end

        local camera  = renderqueue:GetCamera(LAYER_FACE_BEAUTY);
        local texture = renderqueue:GetLinkedTexture(LAYER_FACE_BEAUTY);

        face_beauty:Update(camera:GetSequence(), texture);
        camera:Activate();
    end
end

--[[
    beauty type:
      1 - brighten eye(0-1)
      2 - nasolabial removal(0-1)
      3 - eyebag removal(0-1)
      4 - whiten teeth(0-1)
]]

function main:SetStrengthForFaceBeauty(beauty_type, strength)
    local loaded = self:LoadFaceBeauty();
    if not loaded then
        return false;
    end
    return face_beauty:SetBeautyStrength(beauty_type, strength);
end

function main:SetShowFaceBeauty(is_show)
    if not self.facebeautyloaded then
      return false
    end
    face_beauty:SetShow(is_show);
    return true;
end

-- face reshape
function main:LoadFaceReshape()
  if not self.facereshapeloading then
      if not self.facereshapeloaded then
        LOG("Load FaceReshape ");
         self.facereshapeloading = true;

         renderqueue:Activate(LAYER_FACE_LIFT);
         local camera  = renderqueue:GetCamera(LAYER_FACE_LIFT);

         faceReshape = require "atfacereshape.face_reshape"

         faceReshape:Create(camera:GetSequence(), self.facecuteScene);

         self.facereshapeloading = false;
         self.facereshapeloaded  = true;
      end
      return true;
  end

  return false;
end

-- if you call this function, please read ::~AutoToucherManager first
function main:UnLoadFaceReshape()

    if self.facereshapeloading == true then
        return false;
    end

    if self.facereshapeloaded == true then
        faceReshape:Destroy();
        renderqueue:Deactivate(LAYER_FACE_LIFT);

        collectgarbage();
        self.facereshapeloaded = false;
    end

    return true;
end

function main:UpdateFaceReshape(def)

    if not self.facereshapeloaded then
        return;
    end

    local preUpdateValid = faceReshape:PreUpdate(def);
    if not preUpdateValid then
        -- renderqueue:Deactivate(LAYER_FACE_LIFT);
    else

      if not renderqueue:IsActive(LAYER_FACE_LIFT) then
          renderqueue:Activate(LAYER_FACE_LIFT);
      end

      local camera   = renderqueue:GetCamera(LAYER_FACE_LIFT);
      local texture  = renderqueue:GetLinkedTexture(LAYER_FACE_LIFT);
      local sequence = camera:GetSequence();

      faceReshape:Update(texture, sequence);

      camera:Activate();

    end
end

function main:SetFaceReshapeStrengthWithType(typeid, coef)

    local loaded = self:LoadFaceReshape();
    if not loaded then
        return false;
    end

    return faceReshape:SetFaceReshapeStrengthWithType(typeid, coef);
end

function main:SetShowFaceReshape(is_show)
    if not self.facereshapeloaded then
      return false
    end
    faceReshape:SetShow(is_show);
    return true;
end
-- end face reshape

function main:UpdateMakeupMask(diff)
  apolloengine.SceneManager:UpdateMakeupMask(diff)
end

main.SyncUpdate              = ProfileScope(main.SyncUpdate,                  "Lua#main:SyncUpdate")
main.Timespan                = ProfileScope(main.Timespan,                    "Lua#main:Timespan")
faceseg.GetSegmentMark       = ProfileScope(faceseg.GetSegmentMark,           "Lua#faceseg:GetSegmentMark")
faceseg.RunSegment           = ProfileScope(faceseg.RunSegment,               "Lua#faceseg:RunSegment")
videodecet.Update            = ProfileScope(videodecet.Update,                "Lua#videodecet:Update")
main._Running                = ProfileScope(main._Running,                    "Lua#main:_Running")
Record.OnRecordStart         = ProfileScope(Record.OnRecordStart,             "Lua#Record:OnRecordStart")
Record.OnRecordStop          = ProfileScope(Record.OnRecordStop,              "Lua#Record:OnRecordStop")
main._DispatchScreenRotation = ProfileScope(main._DispatchScreenRotation,     "Lua#main:_DispatchScreenRotation")
posture.Reset                = ProfileScope(posture.Reset,                    "Lua#posture:Reset")
makeup.Update                = ProfileScope(makeup.Update,                    "Lua#makeup:Update")
main.UpdateMakeupMask        = ProfileScope(main.UpdateMakeupMask,            "Lua#main:UpdateMakeupMask")
editormakeup.Update          = ProfileScope(editormakeup.Update,              "Lua#editormakeup:Update")
main.UpdateFaceBeauty        = ProfileScope(main.UpdateFaceBeauty,            "Lua#main:UpdateFaceBeauty")
ObjectStateWrapper.Update    = ProfileScope(ObjectStateWrapper.Update,        "Lua#ObjectStateWrapper.Update")
facecute.Update              = ProfileScope(facecute.Update,                  "Lua#facecute:Update")
blendshape.Update            = ProfileScope(blendshape.Update,                "Lua#blendshape:Update")
lightgame.Update             = ProfileScope(lightgame.Update,                 "Lua#lightgame:Update")
filter.Update                = ProfileScope(filter.Update,                    "Lua#filter:Update")
pupil.Update                 = ProfileScope(pupil.Update,                     "Lua#pupil:Update")
biugo.Update                 = ProfileScope(biugo.Update,                     "Lua#biugo:Update")
photomood.Update             = ProfileScope(photomood.Update,                 "Lua#photomood:Update")
nefelivfx.Update             = ProfileScope(nefelivfx.Update,                 "Lua#nefelivfx:Update")
SceneLoader.UpdateSticker    = ProfileScope(SceneLoader.UpdateSticker,        "Lus#SceneLoader:UpdateSticker")
detectmagic.Update           = ProfileScope(detectmagic.Update,               "Lua#detectmagic:Update")
particleupdateservice.AsyncUpdate = ProfileScope(particleupdateservice.AsyncUpdate, "Lua#particleupdateservice:AsyncUpdate")
TC.Update                    = ProfileScope(TC.Update,                        "Lua#TC:Update")
stylishFilter.Update         = ProfileScope(stylishFilter.Update,             "Lua#stylishFilter:Update")
blingeffect.Update           = ProfileScope(blingeffect.Update,               "Lua#blingeffect:Update")
lineeffect.Update            = ProfileScope(lineeffect.Update,                "Lua#lineeffect:Update")
posteffectfilter.Update      = ProfileScope(posteffectfilter.Update,          "Lua#posteffectfilter:Update")
EditorStylish.Update         = ProfileScope(EditorStylish.Update,             "Lua#EditorStylish:Update")
main.UpdateFaceReshape       = ProfileScope(main.UpdateFaceReshape,           "Lua#main:UpdateFaceReshape")

return main;
