local Object        = require "classic"
local apolloengine  = require "apolloengine"
local apollonode    = require "apolloutility.apollonode"
local mf            = require "mathfunction"
local defined       = require "facemorph.defined"

local WarpFilter = Object:extend();

function WarpFilter:new()  
  self:_GenerateRenderContexts();
end

function WarpFilter:Clear()  
  if self.renderNode ~= nil
  then
    self.renderNode:Destroy();
  end
end

function WarpFilter:SetRenderSequence(seq)
  if self.renderNode ~= nil 
  then
    self.renderNode:SetSequence(seq);
  end
end

function WarpFilter:SetHomoGraphyMatrix(mat)
  if (mat ~= nil) 
  then 
    self.renderNode:SetParameter(self.homoGraphyMatSlot, mat);
  end
end

-- Update texture 
function WarpFilter:SetTexture(tex)  
  if (tex ~= nil) 
  then
    self.renderNode:SetParameter(self.texSlot, tex); 
  end
end

-- Setshow 
function WarpFilter:SetShow(show)
  if self.renderNode ~= nil then
    self.renderNode:SetShow(show);
  end
end

function WarpFilter:SetSize(size)
  self.renderNode:SetParameter(self.widthSlot, mf.vector1(size:x()));
  self.renderNode:SetParameter(self.heightSlot, mf.vector1(size:y()));
end

-- Generate Render Contexts
-- 1. Init vertex/indices stream
-- 2. Load material
-- 3. Create RenerNode
function WarpFilter:_GenerateRenderContexts()    
  self.vtxStream, self.idxStream     =  self:_InitStreams();  
  
  self.texSlot        =  apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "TEXTURE0");                                                        
  self.homoGraphyMatSlot    =   apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "HOMOGRAPHYMAT");
  
  self.widthSlot     =   apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "WIDTH");  
  self.heightSlot    =   apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "HEIGHT");
  
  self.renderNode     =  apollonode.RenderNode(); 
  local materialPath  = "docs:facemorph/material/warperspective.material";
  local renderMode    =  apolloengine.RenderComponent.RM_TRIANGLE_STRIP;

  self.renderNode:CreateResource(materialPath, renderMode, self.vtxStream, self.idxStream);    
  --self.renderNode:SetSequence(defined.SEQUENCE);
  self.renderNode:SetShow(false);
end

-- Initialize the vertex stream and indicies stream
function WarpFilter:_InitStreams()  
  local meshCoord =
  {
    mf.vector2( 1.0,  1.0),
    mf.vector2(-1.0,  1.0),
    mf.vector2(-1.0, -1.0),
    mf.vector2( 1.0, -1.0),
  };

  local texCoord =
  {
    mf.vector2(1.0, 1.0),
    mf.vector2(0.0, 1.0),
    mf.vector2(0.0, 0.0),
    mf.vector2(1.0, 0.0),
  };
  
  local indices = 
  {
    0, 1, 3, 2
  };
  
  local vtxstream     = apolloengine.VertexStream();
  local idxStream = apolloengine.IndicesStream();
  
  -- set vertex format
  vtxstream:SetVertexType(  apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
                            apolloengine.VertexBufferEntity.DT_FLOAT,
                            apolloengine.VertexBufferEntity.DT_FLOAT,
                            2);
  vtxstream:SetVertexType(  apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
                            apolloengine.VertexBufferEntity.DT_FLOAT,
                            apolloengine.VertexBufferEntity.DT_FLOAT,
                            2);   

  idxStream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  
  for i = 1, #meshCoord do
    vtxstream:PushVertexData(
            apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
            meshCoord[i])
  end
  
  for i = 1, #texCoord do
    vtxstream:PushVertexData(
            apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
            texCoord[i])
  end
  
  for i = 1, #indices do
    idxStream:PushIndicesData(indices[i])
  end
  
  return vtxstream, idxStream;
end

return WarpFilter;
