local renderqueue = require "apolloutility.renderqueue"
local venusjson = require "venusjson"
local Object = require "classic"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local apolloDefine = require "apolloutility.defiend"

local physicspaser = Object:extend();

function physicspaser:new(phyxConfigPath,model,headnode)
    self.model = model;
    self.headnode = headnode;
    self.rigidBodies = {};
    self.joints = {};
    
    self.phyxConfig = nil;

    
    self.renders = {};
    self.nodes = {};
    self.trans = {};

    self:SetupPhysxToModel(phyxConfigPath,model,headnode);
    self.isenable = false;

end

function physicspaser:findNode(name)
    local joint = nil;
    if self.model==nil then
        return joint;
    end
    local skeNode = self.model.skeletonNode.node;
    if name == "head" then
        joint = self.headnode;
    else
        joint = skeNode:GetNodeByName(name);
    end 
    return joint;
end;

function physicspaser:AttachDebugRender(joint)

    local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
    local node = scene:CreateNode(apolloengine.Node.CT_NODE);
    --local node = apolloengine.Node();
    local cube = node:CreateComponent(apolloengine.Node.CT_RENDER);
    local trans = node:CreateComponent(apolloengine.Node.CT_TRANSFORM);
    cube:PushMetadata(
      apolloengine.RenderObjectMaterialMetadata(
        apolloengine.PathMetadata("comm:documents/material/lightingonly.material")));  
    cube:PushMetadata(
          apolloengine.RenderObjectMeshFileMetadate("comm:documents/model/cube.mesh"));  
    cube:CreateResource();
    joint:AttachNode(node);
    trans:SetLocalScale(mathfunction.vector3(0.02,0.02,0.02));
    trans:SetLocalPosition(mathfunction.vector3(0,0,0));
    table.insert(self.renders, cube);
    table.insert(self.nodes, node);
    table.insert(self.trans, trans);
  end

function physicspaser:SetupPhysxToModel(phyxConfigPath,model,headnode)
    self.model = model;
    local skeletonComponent = model.skeletonNode.skeleton;
    self.phyxConfig = venusjson.LaodJsonFile(phyxConfigPath);

    if self.phyxConfig.cull == true then
        renderqueue:After(model);  
    else
        renderqueue:Queue("Sticker",model);  
    end

    local RigidsCfg = self.phyxConfig.rigidBody;
  
    local rigidNodes = {};
    for _, perCfg in ipairs(RigidsCfg) do
        local joint = self:findNode(perCfg.joint );

        local size ,shape;
        local rigid = joint:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
        if perCfg.shape==1 then
            size = mathfunction.vector3(perCfg.size[1],perCfg.size[2],perCfg.size[3]);
            rigid:SetCollisionShape(apolloengine.RigidBodyComponent.CST_BOX);
            shape = rigid:GetCollisionShape();
            shape.BoxHalfExtent = size;
            --shape = apolloengine.BoxShape(size);
        elseif perCfg.shape==2 then
            --size = mathfunction.vector3(perCfg.size[1],perCfg.size[2],perCfg.size[3]);
            rigid:SetCollisionShape(apolloengine.RigidBodyComponent.CST_CAPSULE);
            shape = rigid:GetCollisionShape();
            shape.CapsuleRadius = perCfg.size[1];
            shape.CapsuleHeight = perCfg.size[2];
            --shape = apolloengine.CapsuleShape(perCfg.size[1],perCfg.size[2]);
        end

        --local rigid = joint:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
      
        --rigid:Initialize(shape, perCfg.mass); 
        
        if perCfg.kinematic ~= nil then
        	rigid:SetKinematic(perCfg.kinematic);
				end
        rigid:Awake();
--[[
        if perCfg.joint~="head" then
            self:AttachDebugRender(joint); 
        end]]
        rigid:DisableCollision();
        rigid:DisableSimulation();
        table.insert(self.rigidBodies, rigid);
        table.insert(rigidNodes, joint);
    end

    local springJointCfg = self.phyxConfig.springJoint;
    local configJointCfg = self.phyxConfig.configJoint;
    if  springJointCfg~=nil  then
        for _, perCfg in ipairs(springJointCfg) do
            local joint1 = rigidNodes[perCfg.jointA];
            local joint2 = rigidNodes[perCfg.jointB];
    
            local stiffLinear = mathfunction.vector3( perCfg.stiffLinear[1],perCfg.stiffLinear[2],perCfg.stiffLinear[3]);
            local stiffAngular = mathfunction.vector3(perCfg.stiffAngular[1],perCfg.stiffAngular[2],perCfg.stiffAngular[3]);
            local dampingLinear = mathfunction.vector3(perCfg.dampingLinear[1],perCfg.dampingLinear[2],perCfg.dampingLinear[3]);
            local dampingAugular = mathfunction.vector3(perCfg.dampingAngular[1],perCfg.dampingAngular[2],perCfg.dampingAngular[3]);
            local linearLow = mathfunction.vector3(perCfg.LinearLow[1],perCfg.LinearLow[2],perCfg.LinearLow[3]);
            local linearHigh = mathfunction.vector3(perCfg.LinearHigh[1],perCfg.LinearHigh[2],perCfg.LinearHigh[3]);
            local angularLow = mathfunction.vector3(perCfg.AngularLow[1],perCfg.AngularLow[2],perCfg.AngularLow[3]);
            local angularHigh = mathfunction.vector3(perCfg.AngularHigh[1],perCfg.AngularHigh[2],perCfg.AngularHigh[3]);


            local spring = joint1:CreateComponent(apolloengine.Node.CT_SPRING_JOINT);
            table.insert(self.joints, spring);
            local joint2Body = joint2:GetComponent(apolloengine.Node.CT_RIGID_BODY);
            spring.ConnectBody = joint2Body;--约束是限制connect的这个物体的
            spring:SetStiffness(stiffLinear,stiffAngular);
            spring:SetDamping(dampingLinear,dampingAugular);
            spring:SetLinearLimit(linearLow,linearHigh);
            spring:SetAngularLimit(angularLow,angularHigh);
            spring:SetEquilibriumPoint(); 
        end
    end
    if  configJointCfg~=nil  then
        for _, perCfg in ipairs(configJointCfg) do
            local joint1 = rigidNodes[perCfg.jointA];
            local joint2 = rigidNodes[perCfg.jointB];

            local linearLow = mathfunction.vector3(perCfg.LinearLow[1],perCfg.LinearLow[2],perCfg.LinearLow[3]);
            local linearHigh = mathfunction.vector3(perCfg.LinearHigh[1],perCfg.LinearHigh[2],perCfg.LinearHigh[3]);
            local angularLow = mathfunction.vector3(perCfg.AngularLow[1],perCfg.AngularLow[2],perCfg.AngularLow[3]);
            local angularHigh = mathfunction.vector3(perCfg.AngularHigh[1],perCfg.AngularHigh[2],perCfg.AngularHigh[3]);


            local spring = joint1:CreateComponent(apolloengine.Node.CT_CONFIGURABLE_JOINT);
            table.insert(self.joints, spring);
            local joint2Body = joint2:GetComponent(apolloengine.Node.CT_RIGID_BODY);
            spring.ConnectBody = joint2Body;--约束是限制connect的这个物体的
            spring:SetLinearLimit(linearLow,linearHigh);
            spring:SetAngularLimit(angularLow,angularHigh);
        end
    end
   
end

function physicspaser:AttachNode(nodeA,nodeB)
--[[
    local transformcom = nodeB:GetComponent(apolloengine.Node.CT_TRANSFORM)

    local worldpos = transformcom:GetWorldPosition();
    local worldquat = transformcom:GetWorldRotation();
    --self.model.skeletonNode.node:DetachNode(nodeB);
    --nodeA:AttachNode(nodeB);
    transformcom:SetInherit(true);
    transformcom:SetWorldPosition(worldpos);
    transformcom:SetWorldRotation(worldquat);]]
end

function physicspaser:DetachNode(nodeA,nodeB)
  --[[
    local transformcom = nodeB:GetComponent(apolloengine.Node.CT_TRANSFORM)
    local worldpos = transformcom:GetWorldPosition();
    local worldquat = transformcom:GetWorldRotation();
    --nodeA:DetachNode(nodeB);
    --self.model.skeletonNode.node:AttachNode(nodeB);
    transformcom:SetInherit(false);
    transformcom:SetWorldPosition(worldpos);
    transformcom:SetWorldRotation(worldquat);]]
    
end


function physicspaser:DisablePhysics()
    if self.isenable ==false then
        return;
    end
    self.isenable =false;
    local skeletonComponent = self.model.skeletonNode.skeleton;

    local RigidsCfg = self.phyxConfig.rigidBody;
    for _, perCfg in ipairs(RigidsCfg) do
        if perCfg.disableAnimation then
            --skeletonComponent:SetBoneAnimationMask("take 001",perCfg.joint,1.0);
         end
    end

    for _, rigidbody in ipairs( self.rigidBodies) do
        rigidbody:DisableCollision();
        rigidbody:DisableSimulation();
    end

    local springJointCfg = self.phyxConfig.springJoint;
    if  springJointCfg~=nil then
        for _, perCfg in ipairs(springJointCfg) do
            if perCfg.breakJointBParent~=nil then
                local nodep = self:findNode(perCfg.breakJointBParent[1]); 
                local nodec = self:findNode(perCfg.breakJointBParent[2]); 
                self:AttachNode(nodep,nodec);
            end
        end
    end
   
    local configJointCfg = self.phyxConfig.configJoint;
    if  configJointCfg~=nil then
        for _, perCfg in ipairs(configJointCfg) do
            if perCfg.breakJointBParent~=nil then
                local nodep = self:findNode(perCfg.breakJointBParent[1]); 
                local nodec = self:findNode(perCfg.breakJointBParent[2]); 
                self:AttachNode(nodep,nodec);
            end
        end
    end
end


function physicspaser:EnablePhysics()
    if self.isenable ==true then
        return;
    end
    self.isenable =true;
    self.model:Reset(0);
    self.model:UpdateAnimation(0);
    local skeletonComponent = self.model.skeletonNode.skeleton;

    local RigidsCfg = self.phyxConfig.rigidBody;
    for _, perCfg in ipairs(RigidsCfg) do
        if perCfg.disableAnimation then
            --skeletonComponent:SetBoneAnimationMask("take 001",perCfg.joint,0.0);
        end
    end

    for _, rigidbody in ipairs( self.rigidBodies) do
        rigidbody:EnableCollision();
        rigidbody:EnableSimulation();
        rigidbody:CleanMotion();
    end

    local springJointCfg = self.phyxConfig.springJoint;
    if  springJointCfg~=nil then
        for _, perCfg in ipairs(springJointCfg) do
            if perCfg.breakJointBParent~=nil then
                local nodep = self:findNode(perCfg.breakJointBParent[1]); 
                local nodec = self:findNode(perCfg.breakJointBParent[2]); 
                self:DetachNode(nodep,nodec);
            end
        end
    end
    
    local configJointCfg = self.phyxConfig.configJoint;
    if  configJointCfg~=nil then
        for _, perCfg in ipairs(configJointCfg) do
            if perCfg.breakJointBParent~=nil then
                local nodep = self:findNode(perCfg.breakJointBParent[1]); 
                local nodec = self:findNode(perCfg.breakJointBParent[2]); 
                self:DetachNode(nodep,nodec);
            end
        end
    end
end

function physicspaser:OnHeadIndexChange()
    if self.isenable ==true then
        self:DisablePhysics();
        self:EnablePhysics();
        print("reset motion!")
    end

   
end

function physicspaser:ReleaseResource()

end
return physicspaser;