require "venusdebug"
local defined = require "facecute.defined"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"

local particlenode = require "facecute.particle.particlenode"
local particle = require "facecute.particle.particle"
local rendernode = require "apolloutility.apollonode.rendernode"
local renderqueue = require "apolloutility.renderqueue"
local particle3New = particle:extend();


function particle3New:new(maincamera)
  particle3New.super.new(self,maincamera);
  self.postureDisplaying = true
  self.selfVisible = true
  self.withHandAction = false
end


local function IsHandPosture(postype)
  for name, type in pairs(defined.positionTypeHand) do
    if type == postype then
      return true;
    end
  end
  return false
end

function particle3New:ParseConfig(config, param)

  local res = true;
  local n = 5;
  local particls = config.particles;

  if config == nil or param == nil or param.metascene == nil or param.metascene.gameobject == nil then
    LOG("particle:ParseConfig");
    return false;
  end

  local metasceneconfig = param.metascene;
  self.positionType = config.positionType;
  self.name = config.name;

  if IsHandPosture(self.positionType) then
    self.withHandAction = true
    self.postureDisplaying = false
  end

  local len = table.getn(metasceneconfig.gameobject);
  for i = 1, len do
    local obj = metasceneconfig.gameobject[i];
    if obj.name == self.name then
      param["particlename"] = self.name;
      param["particlesystemarray"] = metasceneconfig.particlesystemarray;
      if obj.children then
        self:SetLocalPosition(mathfunction.vector3(
                obj.translation[1],
                obj.translation[2],
                obj.translation[3]));
        local angletranscof = 1.0;
        local eulerQuat = mathfunction.Quaternion(
                obj.rotation[1],
                obj.rotation[2],
                obj.rotation[3],
                obj.rotation[4]);
        self:SetLocalRotation(eulerQuat);
        self:SetLocalScale(mathfunction.vector3(
                obj.scale[1],
                obj.scale[2],
                obj.scale[3]));
        self:addChildren(metasceneconfig.gameobject, obj.children, param);
      else
        self:addChildren(metasceneconfig.gameobject, {i-1}, param);
      end
      break;
    end
  end

  return res;
end

function particle3New:addChildren(gameobjconfig, chdconfig, param)
  local n = #chdconfig;
  for i = 1, n do
    local b = particlenode(self.maincamera);
    local particleparaconfig = self:GetParticleSysConfig(
            gameobjconfig[chdconfig[i]+1].name,
            param.particlesystemarray);
    param["particleparaconfig"] = particleparaconfig;
    b.positionType = self.positionType;
    b:ParseConfig(gameobjconfig[chdconfig[i]+1], param);
    if self.withHandAction then
      renderqueue:After(b)
    else
      renderqueue:After(b);
    end
    table.insert(self.particles, b);
  end
end

function particle3New:SetShow(show)
  self.selfVisible = show
  self:SetVisible(self.selfVisible and self.postureDisplaying)
end

----------

function particle3New:SetRootNode(rootNode)
  rootNode:AttachNode(self)
  for _, def in ipairs(self.particles) do
    self:AttachNode(def)
  end
end

function particle3New:Finished()
  return false
end

function particle3New:SeekToFirst()

end

function particle3New:SeekToMiddle()

end

function particle3New:SeekToLast()

end

function particle3New:Show(args)
  self.selfVisible = true
  self:SetVisible(self.selfVisible and self.postureDisplaying)
end

function particle3New:Hide(args)
  self.selfVisible = false
  self:SetVisible(self.selfVisible and self.postureDisplaying)
end

function particle3New:Start(args)
end

function particle3New:Stop(args)
  self:ReStart();
end

function particle3New:GetActionCenter(action)

  if action == nil then
    return nil;
  end

  local len = table.getn(action);

  if len == 0 then
    return nil;
  end

  for i = 1, len do
    local id = action[i]:GetActionID();
    if self.positionType == id then
      local  center = action[i]:GetCenter();
      return center;
    end
  end
  return nil;
end


function particle3New:Update(timespan, face, position, rotation, action)

  if self.withHandAction then
    if action ~= nil then
      local center = self:GetActionCenter(action);
      if center ~= nil then
        self.postureDisplaying = true
        for _, def in ipairs(self.particles) do
          def:UpdateHandPosition(center);
        end
      else
        self.postureDisplaying = false
      end
    else
      self.postureDisplaying = false
    end
    self:SetVisible(self.selfVisible and self.postureDisplaying)
  end

  for _, def in ipairs(self.particles) do
    def:Update(timespan, face, position, rotation, action);
  end

end

function particle3New:SetFade(fade)

end

-----------



return particle3New;
