local EventDispatcher = require "bluecore.eventdispatcher"
local BD = require "bluecore.bluedefined"

local UserCallEvent = {}; -- 用户调用事件

-- eventType in BlueprintComponent Blueprint_GetUserEvents
-- extraInfo is 'float', reserved
function UserCallEvent:Call(eventType, extraInfo)
  if EventDispatcher:HasCompListener(BD.Event.UserEventComponent) then
    local event = {};
    event.staticID = BD.Event.UserEventComponent;
    event.eventType = eventType;
    event.params = extraInfo;
    EventDispatcher:PushEvent(event);
  end
end

return UserCallEvent;