--@author      : Jin Shiyu
--@date        : 2020-08-28
--@description : lua script for face beauty manager
--@version     : 1.0

local BundleSystem = require "venuscore.bundle.bundlesystem"
local renderqueue  = require "apolloutility.renderqueue"
local apollonode   = require "apolloutility.apollonode"
local defined      = require "apolloutility.defiend"
local apolloengine = require "apollocore"
local venuscore    = require "venuscore"
local Editorscene  = require "editorscene"
local apollocore   = require "apollocore"
local apolloDefine = require "apolloutility.defiend"

--[[
    Face beauty Manager for load face beauty behavior scene
]]

local EditorFaceBeautyManager = {}

function EditorFaceBeautyManager:Initialize(layer, resourceType)
  self.scene        = nil;
  self.baseObjects  = nil;
  self.lastTex      = nil;
  self.layer        = layer; 
  self.resourceType = resourceType;
  --renderqueue:Activate(self.layer);
end

function EditorFaceBeautyManager:LoadConfig(path, rootConfig)
  if rootConfig.scene == nil then
      return false;
  end

  local lastTex = renderqueue:GetLinkedTexture(self.layer);
  if lastTex == nil then
      return false;
  end

  apollocore.IResourceSystem:ResourcekeyRedirect(
    defined.LAST_QUEUE_TEXTURE, 
    defined.LAST_QUEUE_TEXTURE_FACE_BEAUTY);
  apolloengine.DeviceResource:PushDeviceResource(
    defined.LAST_QUEUE_TEXTURE_FACE_BEAUTY,
    lastTex);

  local pathDir = string.match(path, "(.+)/[^/]*%.%w+$");
  local rootDir = pathDir.."/"; 
  venuscore.IFileSystem:SetResourcePath(rootDir);

  local baseObject = self:CreateInstanceFromBundle(venuscore.IFileSystem:PathAssembly(rootConfig.scene));
  local newScene   = Editorscene(self.layer, self.resourceType);
  
  newScene:LoadConfig(baseObject);

  self.scene       = newScene;
  self.baseObjects = baseObject;
  return true;
end


function EditorFaceBeautyManager:CreateInstanceFromBundle(path)
  local bundlepath = venuscore.IFileSystem:PathAssembly(path);
  --local file = io.open(bundlepath, "rb");
  --local str = file:read("*a");
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  --return BundleSystem:DeSerialize(str,scene,BundleSystem.DeserializeMode.Scene);
  
  local _,objects = BundleSystem:DeserializeFromPath(bundlepath,BundleSystem.DeserializeMode.Scene,scene);
  return objects;
end

function EditorFaceBeautyManager:OnRecordStart()
  if self.scene ~= nil then
    self.scene:OnRecordStart();
  end
end

function EditorFaceBeautyManager:ReleaseResource()
  if self.scene == nil then
      return false;
  end

  self.baseObjects = nil;
  self.scene:ReleaseResource();
  self.scene = nil;
  collectgarbage();
  return true;
end

function EditorFaceBeautyManager:Update(def)
  if self.scene == nil then
    return
  end

  local lastTex = renderqueue:GetLinkedTexture(self.layer);
  if lastTex == nil then
      return
  end

  apolloengine.DeviceResource:PushDeviceResource(
    defined.LAST_QUEUE_TEXTURE_FACE_BEAUTY,
    lastTex);

  self.scene:Update(def)
end

function EditorFaceBeautyManager:SetFaceBeautyStrength(beauty_type, strength)
  if self.scene == nil then
    return false;
  end
  return self.scene:SetFaceBeautyStrength(beauty_type, strength);
end


return EditorFaceBeautyManager;
