local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
require "utility"
require "venusdebug"
local jsonposegetter = venuscore.VenusBehavior:extend("jsonposegetter"); 


function jsonposegetter:new()
  self.currentframe = 1;
  self.pose3d = venusjson.LaodJsonFile("scrs:behavior/vtuber_behavior/demo.json");
  self.totalframe =  #self.pose3d["data"];
  
end


function jsonposegetter:Estimate()
  
  local pos,rot;
  pos = self:tbl_copy(self.pose3d["data"][self.currentframe]["positions"]);
  rot = self:tbl_copy(self.pose3d["data"][self.currentframe]["orientations"]);

  self.currentframe = self.currentframe+1;
  if self.currentframe>self.totalframe then
    self.currentframe =1;
  end

  return pos,rot;
end

function jsonposegetter:tbl_copy(orig)
    local orig_type = type(orig)
    local copy
    if orig_type == "table" then
        copy = {}
        for orig_key, orig_value in next, orig, nil do
            copy[self:tbl_copy(orig_key)] = self:tbl_copy(orig_value)
        end
    else -- number, string, boolean, etc
        copy = orig
    end
    return copy
end

return jsonposegetter;