local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local libmasquerade = require "libmasque"
local cv = require "computervisionfunction"

local Tracking = venuscore.VenusBehavior:extend("TrackingBehavior");

function Tracking:new()
end

function Tracking:GetRecongnition()
    return self.recognition;
end

function Tracking:SetRecongnition(rec)
    LOG("[Bilinear]: SET REC")
    self.recognition = rec;
end

function Tracking:GetTracking()
    return self.tracking;
end

function Tracking:SetTracking(tracking)
    LOG("[Bilinear]: SET TRACKING")
    self.tracking = tracking;
end

function Tracking:GetCamera()
    return  self.camera;
end

function Tracking:SetCamera(camera)
    LOG("[Bilinear]: SET CAMERA")
    self.camera = camera;
end

function Tracking:GetResolution()
    local camera = self:GetCamera();
    if camera~=nil then
        local res = camera.CameraResolution;
        return res
    end
    return nil
end

function Tracking:_Play()

end

function Tracking:_OnAwake()

end

function Tracking:_OnStart()
  
end

function Tracking:GetFaceData()
    --LOG("[Bilinear]: Update lmk");
    if self:GetRecongnition()==nil then
        LOG("[Bilinear]: NO REC");
        return nil;
    end
    local results = self:GetRecongnition():GetResult();
    if results==nil or results[cv.RecognitionComponent.cvFace]==nil then
        LOG("[Bilinear]: NO RESULT");
        return nil;
    end

    local faceData = {}

    local facerets = results[cv.RecognitionComponent.cvFace][1];
    if facerets==nil then
        return nil;
    end
    --LOG("[Bilinear]: Update face lmk");
    local lmk = {}
    for i = 1, 106 do 
      lmk[i * 2 - 1] = facerets[i * 2 - 1]
      lmk[i * 2] = facerets[i * 2]
    end
    
    local advFacerets = results[cv.RecognitionComponent.cvAdvancedLandmark];
    local useAdv = false
    if advFacerets ~= nil and advFacerets[1] ~= nil and advFacerets[1][107 * 2 - 1] >= 0 then
      for i = 107, 240 do
        lmk[i * 2 - 1] = advFacerets[1][i * 2 - 1]
        lmk[i * 2] = advFacerets[1][i * 2]
      end
      useAdv = true
    else
      for i = 107, 240 do
        lmk[i * 2 - 1] = -1
        lmk[i * 2] = -1
      end
    end
    
    faceData.useAdv = useAdv
    faceData.landmarks = lmk

    local visibility = {}
    for i = 112, 217 do 
      visibility[i - 111] = facerets[i * 2 - 1]
    end
    faceData.visibility = visibility
    
    local pyr = {}
    pyr[1] = facerets[109 * 2 - 1]
    pyr[2] = facerets[110 * 2 - 1]
    pyr[3] = facerets[111 * 2 - 1]
    faceData.euler = mathfunction.vector3(pyr[1], pyr[2], pyr[3])
    
    local tongue = results[cv.RecognitionComponent.cvTongueDetection]
    faceData.tongue = 0
    if tongue ~= nil and tongue[1] ~= nil then 
      faceData.tongue = tongue[1][1]
    end
  
    local iris = results[cv.RecognitionComponent.cvIrisDetection]
    local leftEye = mathfunction.vector2(0, 0)
    local rightEye = mathfunction.vector2(0, 0)
    if iris ~= nil and iris[1] ~= nil then
      leftEye = mathfunction.vector2(iris[1][20 * 2 - 1], iris[1][20 * 2])
      rightEye = mathfunction.vector2(iris[1][40 * 2 - 1], iris[1][40 * 2])
    end
    if leftEye:x() == 0 and leftEye:y() == 0 then
      leftEye = mathfunction.vector2(facerets[105 * 2 - 1], facerets[105 * 2])
    end
    if rightEye:x() == 0 and rightEye:y() == 0 then
      rightEye = mathfunction.vector2(facerets[106 * 2 - 1], facerets[106 * 2])
    end
    faceData.leftEye = leftEye
    faceData.rightEye = rightEye
    return faceData
end

function Tracking:_OnUpdate(timespan)
    local tracking = self:GetTracking()
    if tracking == nil then
      return
    end
    
    local camera = self:GetCamera()
    if camera == nil then
      return
    end
    local proj = camera:GetProject()
    local resolution = self:GetResolution()
    local projType = camera.ProjectionType
    if proj ~= nil and resolution ~= nil then
      tracking:SetCameraData(resolution:x(), resolution:y(), proj, projType)
    end
    
    local facedata = self:GetFaceData()
    if facedata == nil then
      ERROR("[Bilinear]: fail to get face data.");
      return
    end
    tracking:SetFaceData(facedata.useAdv, facedata.euler, facedata.landmarks, facedata.visibility, facedata.leftEye, facedata.rightEye, facedata.tongue)
    return
end

Tracking:MemberRegister("camera",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.CameraComponent:RTTI(),    
    Tracking.GetCamera,
    Tracking.SetCamera
)); 

Tracking:MemberRegister("recognition",
    venuscore.ScriptTypes.ReferenceType(
        cv.RecognitionComponent:RTTI(),    
        Tracking.GetRecongnition,
        Tracking.SetRecongnition
)); 

Tracking:MemberRegister("tracking",
    venuscore.ScriptTypes.ReferenceType(
        libmasquerade.TrackingComponent:RTTI(),    
        Tracking.GetTracking,
        Tracking.SetTracking
));

return Tracking;