local mathfunction = require "mathfunction"
local Object = require "classic"
local beautyutils = require "beauty.utils"

local Len = Object:extend()

local eps = 0.00001
local aspect_ratio_ref = 1.765

function Len:new(srcIdx, dstIdx, paramX, paramY, radiusfactor)
  self.srcIdx = srcIdx
  self.dstIdx = dstIdx
  self.paramX = paramX
  self.paramY = paramY
  self.radiusfactor = radiusfactor
end

function Len:GetSrcIdx()
  return self.srcIdx
end

function Len:GetDstIdx()
  return self.dstIdx
end

function Len:InitParams(src, dst, facedir, coef, aspect_ratio)  
  local deltax = self.paramX * coef
  local deltay = self.paramY * coef
  local deltaFactor = math.sqrt(deltax * deltax + deltay * deltay * aspect_ratio * aspect_ratio);
  self.deltax = -deltax / (deltaFactor + 0.0001)
  self.deltay = -deltay / (deltaFactor + 0.0001)
  
  local srcToUse = {src[1], src[2] * aspect_ratio};
  local dstToUse = {dst[1], dst[2] * aspect_ratio};
  local dir = {dstToUse[1] - srcToUse[1], dstToUse[2] - srcToUse[2]}
  dir[2] = dir[2] / aspect_ratio_ref
  local dirLen = beautyutils.GetDistance(dir, {0, 0});
  self.delta = deltaFactor * dirLen
  self.radius = self.radiusfactor * dirLen;
  self.srcToUse = srcToUse
  
  dir = {dir[1] / dirLen, dir[2] / dirLen}
  local face_dir_len = dir[1] * facedir[1] + dir[2] * facedir[2];
  self.dir_face_x = {face_dir_len * facedir[1], face_dir_len * facedir[2]};
  self.dir_face_y = {dir[1] - self.dir_face_x[1], dir[2] - self.dir_face_x[2]};
end

function Len:TransformWarp(currentPoint, aspect_ratio)
  local r = beautyutils.GetDistance({currentPoint[1], currentPoint[2] * aspect_ratio}, self.srcToUse);

  local displacement = {0, 0};

  if r > self.radius or math.abs(self.radius) < eps then 
    return displacement, 0; 
  end
  
  local dist = self.radius * self.radius - r * r;
  local tmp = r - self.delta
  local alpha = dist / (dist + tmp * tmp);
  alpha = alpha * alpha;

  local wx = alpha * self.delta * self.deltax
  local wy = alpha * self.delta * self.deltay

  displacement[1] = wx * self.dir_face_x[1] + wy * self.dir_face_y[1];
  displacement[2] = (wx * self.dir_face_x[2] + wy * self.dir_face_y[2]) / aspect_ratio * aspect_ratio_ref;
  return displacement, 1;
end

return Len