local mathfunction = require "mathfunction"
local Object = require "classic"
local beautyutils = require "beauty.utils"

local EllipseLen = Object:extend()

local eps = 0.00001

function EllipseLen:new(cornerIdx, param, radiusfactor)
  self.cornerIdx = cornerIdx
  self.param = param
  self.radiusfactor = radiusfactor
end

function EllipseLen:GetCornerIdx()
  return self.cornerIdx
end


function EllipseLen:InitMouthParams(kp1, kp2, kp3, kp4, facedir, coef, dy_add)  
  local dx = beautyutils.GetDistance(kp4, kp3);
  local dy = beautyutils.GetDistance(kp1, kp2) + dy_add * 2;
  local ea = math.sqrt(dx/dy*self.param[2])
  local R = dx * self.radiusfactor[1];
  local r = dx * self.radiusfactor[2];
  local inten = self.param[1] * coef;
  local center = {0,0};
  center[1] = (kp1[1]+kp2[1]+kp3[1]+kp4[1])/4;
  center[2] = (kp1[2]+kp2[2]+kp3[2]+kp4[2])/4;
  
  self.center = center
  self.facedir = facedir
  self.ellipse_alpha = ea
  self.scale = (R-r)/r*inten;
  self.r_m = r*(1.0+self.scale);
  self.r = r
  self.R = R
end

function EllipseLen:InitEyeParams(kp1, kp2, kp3, kp4, facedir, coef, aspect_ratio)  
  local dx = beautyutils.GetDistance(kp4, kp3);
  local dy = beautyutils.GetDistance(kp1, kp2);
  local ea = dx / dy / self.param[2] / aspect_ratio;
  if ea < 0.2 then
    ea = 0.2
  end
  if(ea > 5) then
    ea = 5;
  end
  dx = dx * aspect_ratio
  local R = dx * self.radiusfactor[1];
  local r = dx * self.radiusfactor[2];
  local inten = self.param[1] * coef;
  local center = {0,0};
  center[1] = (kp1[1]+kp2[1]+kp3[1]+kp4[1])/4;
  center[2] = (kp1[2]+kp2[2]+kp3[2]+kp4[2])/4;
  
  self.center = center
  self.facedir = facedir
  self.ellipse_alpha = ea
  self.scale = (R-r)/r*inten;
  self.r_m = r*(1.0+self.scale);
  self.r = r
  self.R = R
end

function EllipseLen:WarpObliqueEllipseScale(currentPoint, aspect_ratio)
  local vec_pc = { currentPoint[1] - self.center[1], (currentPoint[2] - self.center[2]) * aspect_ratio};
  local p_r = { vec_pc[1]*self.facedir[1]+vec_pc[2]*self.facedir[2] , -vec_pc[1]*self.facedir[2]+vec_pc[2]*self.facedir[1] };
  p_r[2] = p_r[2] * self.ellipse_alpha
  local d = math.sqrt(p_r[1]*p_r[1]+p_r[2]*p_r[2]);
  
  local displacement = {0, 0};
  if (d <= self.r_m) then
    local alpha = 1.0 / (1.0 + self.scale) - 1;
    displacement[1] = (currentPoint[1] - self.center[1]) * alpha;
    displacement[2] = (currentPoint[2] - self.center[2]) * alpha;
  elseif (d <= self.R) then
    local percent = (self.R - d) / (self.R - self.r_m);
    local alpha = (self.R - percent * (self.R - self.r)) / d - 1
    displacement[1] = (currentPoint[1] - self.center[1]) * alpha;
    displacement[2] = (currentPoint[2] - self.center[2]) * alpha;
  end
  return displacement, 1;
end

return EllipseLen