local SequenceAnimation = require "apolloutility.sequenceanimation"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local Faceinfo = require "videodecet.faceinfo";
local Actioninfo = require "videodecet.actioninfo";
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local likeapp = require "likeapp"




local debug2d = {}


function debug2d:Initialize()

  local pr = apollonode.PointNode();
  pr:CreateResource(
    14,
    mathfunction.vector4(0,1,0,1),
    "comm:documents/material/pointrender.material");
  renderqueue:Before(pr);
  self.pointrender = pr;  

end


local function _toRelativeCoordinates(pixel_x, pixel_y)
  return pixel_x / 12 * 2 - 1, 1 - pixel_y / 23 * 2;
end

function debug2d:Draw(points)
  
  self.currentbodypoints = points;

  if self.currentbodypoints~=nil then
    local pr = self.pointrender;
    local bodyvectors = {}
    for i=1, 14 do
      table.insert(bodyvectors, { _toRelativeCoordinates(self.currentbodypoints[i][1], self.currentbodypoints[i][2]) });
    end      
    pr:Update(bodyvectors);
  end
end



return debug2d;