#SHADER_DEFINE ShadowVertexPass
    FUNCTION_INPUT =
    {
        { CAMERA_VIEW,                HIGH,    MAT4,        "in_ViewMatrix"},
        { CAMERA_VIEWPROJ,						HIGH,    MAT4,        "in_ViewPorj" },
        { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
        { LOCALWORLD_ROTATION,				HIGH,    MAT3,        "in_WorldRotation" },
        { ATTRIBUTE_POSITION,					HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_NORMAL,					HIGH,    VEC3,        "in_Normal" },
        { ATTRIBUTE_COORDNATE0,             HIGH,    VEC2,        "in_Coordinate0"},
        { CAMERA_LINEARPARAMBIAS, 			HIGH,	VEC3,		"in_CameraLineDepthParam" },
    }

    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,             HIGH,    VEC2,    "out_Coordinate0"},
        { ATTRIBUTE_COORDNATE1,				HIGH,    VEC4,    "out_ScreenUV" },
    }
#SHADER_CODE

    vec4 out_PositionWS = in_Transfrom * in_Position;
    vec3 out_NormalWS = (in_WorldRotation * in_Normal);
    out_NormalWS.xyz = normalize(out_NormalWS.xyz);
    
    vec3 lightDirWS = vec3(in_ViewMatrix[2][0], in_ViewMatrix[2][1], in_ViewMatrix[2][2]);
    lightDirWS = normalize(lightDirWS);

    float shadowCos = dot(out_NormalWS.xyz, lightDirWS.xyz);
 // float shadowSine = sqrt(1.0 -shadowCos*shadowCos);
    float shadowSine = abs(shadowCos);
    float normalBias = 0.005 * shadowSine;

 // out_PositionWS.xyz -= out_NormalWS * normalBias;
    vec4 out_Position = in_ViewPorj * out_PositionWS;
    
    gl_Position = out_Position;
    gl_Position.z = out_Position.z + normalBias;

    vec2 out_Coordinate0 = in_Coordinate0.xy;
    vec4 out_ScreenUV = out_Position;
    out_ScreenUV.xy = out_ScreenUV.xy * 0.5 + 0.5 * out_ScreenUV.ww;

#END_CODE
#END_DEFINE

#SHADER_DEFINE ShadowPixelPass
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE0,             HIGH,    VEC2,    "out_Coordinate0"},
        { ATTRIBUTE_COORDNATE1,				HIGH,    VEC4,    "out_ScreenUV" },
    }

    FUNCTION_OUTPUT =
    {
    }
#SHADER_CODE
    gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);

#END_CODE
#END_DEFINE

#SHADER_DEFINE ShadowPixelDiscardPass
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE0,             HIGH,    VEC2,    "in_Coordinate0"},
        { ATTRIBUTE_COORDNATE1,				HIGH,    VEC4,    "in_ScreenUV" },
        { TEXTURE_DIFFUSE,			  NONE,			TEXTURE2D,		"MainTex" },
    }

    FUNCTION_OUTPUT =
    {

    }
#SHADER_CODE
    vec2 screenCoord = in_ScreenUV.xy / in_ScreenUV.w;
    screenCoord.xy = screenCoord.xy * vec2(2048.0, 2048.0);
    screenCoord.xy = screenCoord.xy * vec2(0.25, 0.25);

    vec2 fracCoord = fract(abs(screenCoord.xy));
    fracCoord.xy = fracCoord.xy * vec2(4.0, 4.0);
    
    int indexX = int(fracCoord.x);
    int indexY = int(fracCoord.y);

    vec4 sle[4];
    sle[0] = vec4(1.0, 0.0, 0.0, 0.0);
    sle[1] = vec4(0.0, 1.0, 0.0, 0.0);
    sle[2] = vec4(0.0, 0.0, 1.0, 0.0);
    sle[3] = vec4(0.0, 0.0, 0.0, 1.0);

    vec4 curAlpha;
    curAlpha.x = dot(vec4(0.05882353, 0.7647059, 0.23529412, 0.94117647), sle[indexX]);
    curAlpha.y = dot(vec4(0.52941179, 0.29411766, 0.70588237, 0.47058824), sle[indexX]);
    curAlpha.z = dot(vec4(0.17647059, 0.88235295, 0.11764706, 0.82352942), sle[indexX]);
    curAlpha.w = dot(vec4(0.64705884, 0.41176471, 0.58823532, 0.35294119), sle[indexX]);
    curAlpha.xyzw = curAlpha.xyzw * sle[indexY];

    float sampleAlpha = texture2D(MainTex, in_Coordinate0.xy).w;
    float cmpV = sampleAlpha * sampleAlpha - dot(curAlpha.xyzw, vec4(1.0, 1.0, 1.0, 1.0));
    
    if (cmpV < 0.0)
    {
        discard;
    }

    gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);

#END_CODE
#END_DEFINE


#SHADER_DEFINE ShadowCollectVertex

	FUNCTION_INPUT = 
	{
    { LIGHT_CAMERA_VIEW,               HIGH, MAT4,   "in_LightCameraViewMatrix"},
    { LIGHT_CAMERA_PROJECTION,         HIGH, MAT4,   "in_LightCameraPorjMatrix"},
    { LIGHT_CAMERA_LINEARPARAM, HIGH,	VEC3,		"in_LightCameraLineDepthParam"},
    { LIGHT_CAMERA_POSITION,    HIGH, VEC3,   "in_LightCameraPosition"},
    { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
    { ATTRIBUTE_POSITION,					HIGH,    VEC4,        "in_Position" }
	}

	FUNCTION_OUTPUT = 
	{
    { LIGHTSPACE_COORD,    HIGH, VEC4,    "out_LightCoord"},
    { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "out_OrigDepth"}
	}

#SHADER_CODE
  vec4 in_PositionWS  = in_Transfrom * in_Position;
  const mat4 biasMatrix = mat4(0.5,0.0,0.0,0.0,
                               0.0,0.5,0.0,0.0,
                               0.0,0.0,0.5,0.0,
                               0.5,0.5,0.5,1.0);

  vec4 out_LightCoord = in_LightCameraPorjMatrix * in_LightCameraViewMatrix * in_PositionWS;
  highp float out_OrigDepth = (out_LightCoord.z + 1.0) * 0.5;
  out_LightCoord = out_LightCoord / out_LightCoord.w;
  out_LightCoord = biasMatrix * out_LightCoord;

#END_CODE
#END_DEFINE


#SHADER_DEFINE ShadowCollectPixel

	FUNCTION_INPUT = 
	{
		{ TEXTURE_SHADOW_DEPTH,		NONE,	TEXTURE2D,	"in_DepthMap" },
		{ LIGHTSPACE_COORD,	HIGH,	VEC4,		"in_LightVertexCoordinate" },
        { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "in_OrigDepth"}
	}

	FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,				HIGH,	FLOAT,		"shadowMask" },
	}
	
#SHADER_CODE
    const float radius = 0.002;
    vec2 curCoord = in_LightVertexCoordinate.xy;
    vec4 offRadius0 = curCoord.xyxy + vec4(-0.1658961, 0.98614317, 0.8875289, 0.14930651) * radius;
    vec4 offRadius1 = curCoord.xyxy + vec4(0.13271689, -0.78891462, -0.69030023, -0.1161273) * radius;
    vec4 shadowTex;
    vec4 shadowOutMask;

    shadowTex.x = (texture2D( in_DepthMap, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (texture2D( in_DepthMap, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (texture2D( in_DepthMap, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (texture2D( in_DepthMap, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask.x = dot(shadowTex, vec4(0.0625, 0.0625, 0.0625, 0.0625));

    offRadius0 = curCoord.xyxy + vec4(-0.35084891, 0.35623729, 0.46310851, 0.45610359) * radius;
    offRadius1 = curCoord.xyxy + vec4(0.070169792, -0.071247473, -0.2493661, -0.24559429) * radius;
    shadowTex.x = (texture2D( in_DepthMap, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (texture2D( in_DepthMap, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (texture2D( in_DepthMap, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (texture2D( in_DepthMap, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask.x += dot(shadowTex, vec4(0.0625, 0.0625, 0.0625, 0.0625));

    offRadius0 = curCoord.xyxy + vec4(0.055099439, 0.2438525, 0.78032809, -0.1763182) * radius;
    offRadius1 = curCoord.xyxy + vec4(-0.198358, -0.87786913, -0.9754101, 0.2203977) * radius;
    shadowTex.x = (texture2D( in_DepthMap, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (texture2D( in_DepthMap, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (texture2D( in_DepthMap, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (texture2D( in_DepthMap, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask.x += dot(shadowTex, vec4(0.0625, 0.0625, 0.0625, 0.0625));

    offRadius0 = curCoord.xyxy + vec4(0.4280726, 0.73433912, 0.25917849, -0.15108439) * radius;
    offRadius1 = curCoord.xyxy + vec4(-0.3273496, -0.56155342, -0.1727857, 0.100723) * radius;
    shadowTex.x = (texture2D( in_DepthMap, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (texture2D( in_DepthMap, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (texture2D( in_DepthMap, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (texture2D( in_DepthMap, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask.x += dot(shadowTex, vec4(0.0625, 0.0625, 0.0625, 0.0625));

    float shadowMask = shadowOutMask.x;
    
#END_CODE
#END_DEFINE


#SHADER_DEFINE NoShadowCollectVertex

	FUNCTION_INPUT = 
	{
	}

	FUNCTION_OUTPUT = 
	{
	}

#SHADER_CODE

#END_CODE
#END_DEFINE

#SHADER_DEFINE NoShadowCollectPixel

	FUNCTION_INPUT = 
	{
	}

	FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,				HIGH,	FLOAT,		"shadowMask" },
	}
	
#SHADER_CODE
    float shadowMask = 1.0;
#END_CODE
#END_DEFINE