

#SHADER_DEFINE AlphaConstIn

	FUNCTION_INPUT = 
	{
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	
    float alpha_out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE AlphaConstOut

	FUNCTION_INPUT = 
	{
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	
    float alpha_out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE AlphaLinearIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	
    float alpha_out_EasingV = in_Progress;
#END_CODE
#END_DEFINE

#SHADER_DEFINE AlphaLinearOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	
    float alpha_out_EasingV = in_Progress;
#END_CODE
#END_DEFINE


#SHADER_DEFINE AlphaSineIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	
    float alpha_out_EasingV = sin((in_Progress - 1.0) * 1.5707963267948966) + 1.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE AlphaSineOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	
    float alpha_out_EasingV = sin(in_Progress * 1.5707963267948966);
#END_CODE
#END_DEFINE


#SHADER_DEFINE AlphaExponentialIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	

  float alpha_out_EasingV = 0.0;
  if (in_Progress == 0.0)
    alpha_out_EasingV = in_Progress;
  else
    alpha_out_EasingV = pow(2.0,10.0 * (in_Progress - 1.0));
#END_CODE
#END_DEFINE

#SHADER_DEFINE AlphaExponentialOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	
  float alpha_out_EasingV = 0.0;
  if (in_Progress == 1.0)
    alpha_out_EasingV = in_Progress;
  else
    alpha_out_EasingV = 1.0 - pow(2.0, -10.0 * in_Progress);
#END_CODE
#END_DEFINE


#SHADER_DEFINE AlphaBackIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	
  float alpha_out_EasingV = pow(in_Progress,3.0) - in_Progress * sin(in_Progress * 3.141592653589793);
#END_CODE
#END_DEFINE

#SHADER_DEFINE AlphaBackOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	
  float f_alphabackout = 1.0 - in_Progress;
  float alpha_out_EasingV = 1.0 - (pow(f_alphabackout , 3.0) - f_alphabackout  * sin(f_alphabackout  * 3.141592653589793));
#END_CODE
#END_DEFINE

#SHADER_DEFINE AlphaBounceOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	
  const float a_alphabout = 4.0 / 11.0;
  const float b_alphabout = 8.0 / 11.0;
  const float c_alphabout = 9.0 / 10.0;

  const float ca_alphabout = 4356.0 / 361.0;
  const float cb_alphabout = 35442.0 / 1805.0;
  const float cc_alphabout = 16061.0 / 1805.0;

  float t2_alphabout = in_Progress * in_Progress;
  
  float alpha_out_EasingV = 0.0;
  if (in_Progress < a_alphabout)
  {
    alpha_out_EasingV = 7.5625 * t2_alphabout;
  }
  else
  {
    if (in_Progress < b_alphabout)
    {
      alpha_out_EasingV = 9.075 * t2_alphabout - 9.9 * in_Progress + 3.4;
    }
    else
    {
      if (in_Progress < c_alphabout)
      {
        alpha_out_EasingV = ca_alphabout * t2_alphabout - cb_alphabout * in_Progress + cc_alphabout;
      }
      else
      {
        alpha_out_EasingV = 10.8 * in_Progress * in_Progress - 20.52 * in_Progress + 10.72;
      }
    }
  }

#END_CODE
#END_DEFINE

#SHADER_DEFINE AlphaBounceIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_EASING_VALUE,           MEDIUM, FLOAT,  "alpha_out_EasingV"},
	}

#SHADER_CODE	

  float t_alphabin = 1.0 - in_Progress;
  const float a_alphabin = 4.0 / 11.0;
  const float b_alphabin = 8.0 / 11.0;
  const float c_alphabin = 9.0 / 10.0;

  const float ca_alphabin = 4356.0 / 361.0;
  const float cb_alphabin = 35442.0 / 1805.0;
  const float cc_alphabin = 16061.0 / 1805.0;

  float t2_alphabin = t_alphabin * t_alphabin;
  
  float alpha_out_EasingV = 0.0;
  if (t_alphabin < a_alphabin)
  {
    alpha_out_EasingV = 7.5625 * t2_alphabin;
  }
  else
  {
    if (t_alphabin < b_alphabin)
    {
      alpha_out_EasingV = 9.075 * t2_alphabin - 9.9 * t_alphabin + 3.4;
    }
    else
    {
      if (t_alphabin < c_alphabin)
      {
        alpha_out_EasingV = ca_alphabin * t2_alphabin - cb_alphabin * t_alphabin + cc_alphabin;
      }
      else
      {
        alpha_out_EasingV = 10.8 * t_alphabin * t_alphabin - 20.52 * t_alphabin + 10.72;
      }
    }
  }
  alpha_out_EasingV = 1.0 - alpha_out_EasingV;

#END_CODE
#END_DEFINE



