local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local defined = require "facecute.defined"
local facedefined = require "facecute.facechange.facedefined"
local b3 = require "behavior3"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
local behdefined = require "facecute.behavior.behdefined"
local cutebehavior = require "facecute.behavior.cutebehavior"


local rendernode = require "apolloutility.apollonode.rendernode"
local facetrigger = rendernode:extend();

function facetrigger:new(maincamera)
  self.maincamera = maincamera;
  facetrigger.super.new(self);
  self.frames = 0;
  self.curFrame = 0;
  self.events={};
end


function facetrigger:SetTrigger(config)
  self.triggerType = config["triggerType"];
  self.triggerLoop = config["triggerLoop"];
  self.triggerDelay = config["triggerDelay"];
  self.triggerStop = config["triggerStop"];
  if 0 == self.triggerType and (self.triggerDelay==nil or self.triggerDelay==0)   then
    self.updatefunction = self.Render;
  else
    self.updatefunction = self.BehaviorUpdate;
  end  
end


function facetrigger:SetShow(isshow)
  if ((self.triggerType==nil or 0 == self.triggerType) and (self.triggerDelay==nil or self.triggerDelay==0))
  then
    facetrigger.super.SetShow(self,isshow);
    if(isshow==false)
    then
      self:ReStart();
    end
  else
     if(isshow==false)
     then
         facetrigger.super.SetShow(self,false);
         self:ReStart();
     end
  end
end

function facetrigger:ReStart()
  self.curTime = 0;
  self.initMark = 0;
  self.curLoop = self.initMark;
  self.stateType = behdefined.stateType.NULL;
  self.disAction = nil;
  self.lastAction = nil;
  self.action = nil;
  self.needupd = false;
  self.curLen = nil;
  self.frames= 0;
  self.curFrame = 0;
end

function facetrigger:Update(timespan, face, position, rotation, action)
  self.timespan = timespan;
  self.frames = self.frames+1;
  self.action = action;
  self.face = face;
  self.curFrame= self.curFrame+1;
  cutebehavior:tick(self);
end

function facetrigger:GetLoopFrameCount()
  return self.curFrame;
end

function facetrigger:AddEvent(event)
  table.insert(self.events,event)
end

function facetrigger:ResetEvent()
  self.events ={};
end

function facetrigger:ResetLoopFrameCount()
  self.curFrame = 0;
end
function facetrigger:GetLoopCount()
  return self.curFrame;
end

function facetrigger:ResetLoopCount()
    self.curFrame = 0;
end

function facetrigger:Render()
end

function facetrigger:SetVisible(vis)
    facetrigger.super.SetShow(self,vis);
end

function facetrigger:Play()
  self:SetVisible(true);
  self:Render();
end

function facetrigger:BehaviorUpdate()
  cutebehavior:tick(self);
end

return facetrigger;