
#DEFPARAMS
UNIFORM_INPUT_TEXTURE = {"UNIFORM_INPUT_TEXTURE", TEXTURE2D, "UNIFORM_INPUT_TEXTURE"},
#END

#DEFTAG
ShaderName  = "identity"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float2 in_pos : POSITION;
    float2 in_tex_coord : TEXCOORD0;
};

struct v2f
{
    float2 out_tex_coord : TEXCOORD0;
    float4 out_pos : SV_POSITION;
};

v2f vert(appdata v)
{
    v2f o;
    o.out_tex_coord         = v.in_tex_coord;
    o.out_pos               = UniformNDC(float4(v.in_pos.x, v.in_pos.y, 0.0, 1.0));
    return o;
}

Texture2D UNIFORM_INPUT_TEXTURE;
SamplerState UNIFORM_INPUT_TEXTURESampler;

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
#define input_texture UNIFORM_INPUT_TEXTURE
    mainColor = UNIFORM_INPUT_TEXTURE.Sample(UNIFORM_INPUT_TEXTURESampler, i.out_tex_coord);
}

ENDCG
#END