local libvenuscore = require "libvenuscore"


local rttimanager = libvenuscore.RttiManager;
rttimanager.classes = {}

local _fNativeNewinstance = libvenuscore.RttiManager.Newinstance;
assert(_fNativeNewinstance);


function rttimanager:RegisterClass(name, cla)
  if not self.classes[name]
    and not libvenuscore.RttiManager:haveClass(name) then 
    self.classes[name] = cla;
  else
    LOG(string.format("class %s is duplicate", name));
  end
end




function rttimanager:Newinstance(name, host, scene)
  if name then
    if self.classes[name] then
      local cla = self.classes[name];
      return cla(scene);
    else
      local cla = _fNativeNewinstance(libvenuscore.RttiManager, name, host);
      return cla;
    end
  end
  error("name is nil or class not found");
end

function rttimanager:GetRttiByName(name)
  if name then
    if self.classes[name] then
      local cls = self.classes[name];
      return cls
    else
      local rtti = libvenuscore.RttiManager:GetRtti(name);
      return rtti;
    end
  end
  error("[GetRttiByName] name is nil or class not found "..tostring(name));
end

function rttimanager:HaveClass(name)
  if not self.classes[name]
          and not libvenuscore.RttiManager:haveClass(name) then
    return false
  end
  return true
end

-- 目前只能获取lua层注册的class
function rttimanager:GetClass(name)
  if self.classes[name] then
    return self.classes[name]
  end
  error("[GetClass] "..name.." is nil")
  return nil
end

return rttimanager;