local Types = require "venuscore.rtti.types"
local libvenuscore = require "libvenuscore"
local AE = require "apolloengine"
local BD = require "bluecore.bluedefined"
local BlueDynamicNode = require "bluecore.base.blue_dynamic_node"
local BlueCameraPostEffectRef = BlueDynamicNode:extend();

BlueCameraPostEffectRef:MemberRegister("comp", Types.ReferenceType(AE.CameraComponent:RTTI()));
BlueCameraPostEffectRef:MemberRegister("compName");
BlueCameraPostEffectRef:MemberRegister("postEffectIdx");
--PS:现在的实现是记录了后处理表的索引数字来访问后处理
--所以如果删除了当前的后处理  索引会变成0

function BlueCameraPostEffectRef:new(graph, comp, postEffectIdx, compName)

  BlueCameraPostEffectRef.super.new(self, graph)

  self.comp = comp; 
  self.postEffectIdx = postEffectIdx;
  --self.postEffect不要在这里定义 反序列化new的时候只会传入graph  
  --self.postEffect = self.comp.PosteffectEntities[tonumber(sIftrTable[2])];
  self.compName = compName;

end

function BlueCameraPostEffectRef:_OnDuplicate()

  local luaPath = self[BD.LUA_CLASS_PATH];
  local clazz = require(luaPath);
  local bluePrintNode = clazz(self.graph, self.comp, self.postEffectIdx, self.compName); --创造实例
  bluePrintNode[BD.LUA_CLASS_PATH] = luaPath;
  bluePrintNode:EditorCreate();
  return bluePrintNode;

end


function BlueCameraPostEffectRef:_OnCompile()
  if libvenuscore.isNil(self.comp) then
    self.compileResult = "component is lost";
    return false;
  end
  --self.postEffect = self.comp.PosteffectEntities[self.postEffectIdx];
  if libvenuscore.isNil(self.postEffect) then
    self.compileResult = "postEffect is lost";
    self.postEffectIdx = 0; --后处理不存在就置为0
    return false
  end
  return true
end

function BlueCameraPostEffectRef:GetRef()
  return self.comp
end


if _KRATOSEDITOR then

  function BlueCameraPostEffectRef:_OnCreateWithEditor()

    BlueCameraPostEffectRef.super._OnCreateWithEditor(self);
    assert(self.comp, "[BlueCameraPostEffectRef] comp is nil")
    self.postEffect = self.comp.PosteffectEntities[self.postEffectIdx];
    self[BD.OUTPUTS_INFO][1].name = self.compName
    self[BD.OUTPUTS_INFO][1].tips = "Instance Reference of "..self.compName
    LOG("[BlueCameraPostEffectRef] compName "..tostring(self.compName))

  end


  --编辑的时候如果node名字改变了也做修改
  --FIXME(hjh) 名字不会同步到game里头 但是stop下来scene反序列化一份就是一样的了
  function BlueCameraPostEffectRef:_OnUpdateByEditor()
    BlueCameraPostEffectRef.super._OnUpdateByEditor(self);
    if self:_OnCompile() then  
      local poststrTable = {}; 
      --与反射面板显示保持一致....
      for k,v in pairs(self.comp.PosteffectEntities) do 
        local PathMetadata = v.ScriptPath;
        local scriptpath = PathMetadata[1].Path;
        local pathDir, postStr = string.match(scriptpath, "(.+)[:/]([^/]*)%.%w+$");
        if poststrTable[postStr] then
          poststrTable[postStr] = poststrTable[postStr] + 1;
          postStr = postStr..tostring(poststrTable[postStr]);
        else
          poststrTable[postStr] = 1;
        end
        if v:GetObjectID() == self.postEffect:GetObjectID() then
          self.compName = postStr.."\n".."node: ".. self.comp:GetHostNode():GetName();
          self.postEffectIdx = k; --记录后处理索引... 有变化的可能 
          break;
        end
      end

      --self.compName = self.postEffect.."\n".."node: ".. self.comp:GetHostNode():GetName();
      self[BD.OUTPUTS_INFO][1].name = self.compName
      self[BD.OUTPUTS_INFO][1].tips = "Instance Reference of "..self.compName
    end
  end

end



function BlueCameraPostEffectRef:_OnDeserializePost()
  BlueCameraPostEffectRef.super._OnDeserializePost(self)
  if _KRATOSEDITOR then
    self[BD.OUTPUTS_INFO][1].name = self.compName
    self[BD.OUTPUTS_INFO][1].tips = "Instance Reference of "..self.compName
  end
  self.postEffect = self.comp.PosteffectEntities[self.postEffectIdx];
  --assert(self.comp, "[BlueCameraPostEffectRef] comp is nil")
  
end


function BlueCameraPostEffectRef:GetOutputByIndex(index)
  return self.postEffect;
end


BlueCameraPostEffectRef:RegisterOutput(1, Types.CameraPostEffectRefType, "postEffect", "postEffect of CameraComponent");
BlueCameraPostEffectRef:SetFunctionType(BD.COMPONENT_CONTENT_NODE);
BlueCameraPostEffectRef:SetFunctionName(BD.COMPONENT_CONTENT.CAMERA_POSTEFFECT);

return BlueCameraPostEffectRef