local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"
local apolloengine = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local OnAniEnd = BlueNode:extend();

function OnAniEnd:new(...)
  OnAniEnd.super.new(self, ...)
  self.edge = true;
end

function OnAniEnd:_OnUpdate(eventParam)
  self.output = eventParam
end

function OnAniEnd:_OnNextBranch()
  if self.edge and not self.output.isEdge then 
    return 0
  else
    return 1
  end
end

function OnAniEnd:RegisterTriggerFunc(func, bluePrintSelf)
  self:_GetInput()
  self.edge = self.inputArgs[2];
  EventDispatcher:RegisterCallback(self.inputArgs[1]:GetContentPath(), BlueDefined.Event.AnimationEvent.End, func, bluePrintSelf);
end

OnAniEnd:RegisterInput(1, apolloengine.AnimationComponent:RTTI(), "component", "监听组件", BlueSelf());
OnAniEnd:RegisterInput(2, Types.BoolType, "edge", "边缘触发", true);

OnAniEnd:RegisterExecOutput(1, "OnTrigger", "执行");

OnAniEnd:SetFunctionName("_OnAnimationEnd");

OnAniEnd:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

OnAniEnd:SetEventType(BlueDefined.EventType.RegisterCallback);

return OnAniEnd;

