local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local IfElse = BlueNode:extend();

IfElse:MemberRegister("version")

---- 游戏运行模式
function IfElse:new(...)
  IfElse.super.new(self, ...)
  self.nextBranch = 1 ;
end

function IfElse:_OnUpdate(args)
  local condition = args[1];
  if condition then
    self.nextBranch = 1
  else
    self.nextBranch = 2
  end
  return condition;
end


function IfElse:_OnNextBranch()
  return self.nextBranch
end

-- 从反序列化回来 fix 旧版本的bug 如果序列化提升到新版本
function IfElse:_OnDeserialize()
  if self.version == nil then
    self.outputs[1].argId = 1 ; -- bug fix
    self.version = 1
  end
end

-- 从编辑器创建 直接是新版本
function IfElse:_OnCreateWithEditor()
  IfElse.super._OnCreateWithEditor(self);
  self.version = 1
end

---- 编辑器模式


IfElse:RegisterInput(1, Types.BoolType, "Condition", "条件", true);

IfElse:RegisterOutput(1, Types.BoolType, "Result", "条件结果", true);

IfElse:RegisterExecInput(1, "Exec", "执行");

IfElse:RegisterExecOutput(1, "True", "执行");
IfElse:RegisterExecOutput(2, "False", "执行");

IfElse:SetFunctionName("If Else");

return IfElse ;

