local BATNode = require "bluecore.base.blue_anytype_node"
local ForLoopBreak = BATNode:extend();
local Types = require "venuscore.rtti.types"

---- 游戏运行模式
function ForLoopBreak:new(...)
  ForLoopBreak.super.new(self, ...)
  self.array_index = 1
  self.array_element = nil
  self.array = {}
  self.is_running = false
  self.is_abort = false
end

-- 重写BlueNode的Update方法
function ForLoopBreak:Update(exec_idx)
  if exec_idx == 2 then -- 如果只是需要输入依赖 而不是执行 exec_idx 是 nil
    return self:_Break();
  elseif exec_idx == 1 then
    return self:_Loop();
  end
end


function ForLoopBreak:_Break()
  if _KRATOSEDITOR then
    local BuEd = require "bluecore.editor.blueutility_ed"
    BuEd:BlueDebugYield(self);
  end
  self.is_abort = true ;
  return nil
end

function ForLoopBreak:_Loop()

  if self.is_running then
    LOG("[ForLoopBreak:Update] is running");
    return nil
  end

  -- Step.1 先执行输入的依赖节点update 并获取参数
  self:_GetInput()

  -- 初始化状态
  self.is_running = true
  self.array_index = 1
  self.array_element = nil
  self.is_abort = false
  self.array = self.inputArgs[1] ;

  -- Step.2 执行循环 Loop引脚被调用
  local loopbody = self.nextExecNodes[1];
  if loopbody ~= nil then
    for _ , array_element in pairs(self.array) do

      self.array_element = array_element
      self.outputResults = {self.array_element, self.array_index}

      if _KRATOSEDITOR then
        local BuEd = require "bluecore.editor.blueutility_ed"
        BuEd:BlueDebugYield(self);
      end

      local lastNode = self
      local execIdx  = 1
      local nextIdx  = self.nextExecIndex[execIdx];
      local nextNode = self.nextExecNodes[execIdx]

      while nextNode ~= nil do
        if _KRATOSEDITOR then
          local link_uid = lastNode.execOutputs[execIdx].links[1].linkUid;
          self.graph:AddExecLinkList(link_uid);
        end
        lastNode = nextNode
        execIdx  = nextNode:Update(nextIdx)
        nextIdx  = nextNode.nextExecIndex[execIdx]
        nextNode = nextNode.nextExecNodes[execIdx]
      end

      self.array_index =  self.array_index + 1
      if self.is_abort then
        LOG("for break it, "..tostring(self.array_index))
        break;
      end
    end
  end

  -- 恢复状态
  self.is_running = false
  --与Unreal保持一致~
  self.array_index = self.array_index - 1 
  --self.array_element = nil
  self.is_abort = false
  self.inputArgs = {}
  self.outputResults = {self.array_element, self.array_index}

  -- Step.3 返回Complete执行引脚
  return 2
end

function ForLoopBreak:GetOutputByIndex(index)
  return self.outputResults[index];
end

-- 编辑器接口
function ForLoopBreak:_OnCreateWithEditor()
  ForLoopBreak.super._OnCreateWithEditor(self);
end

ForLoopBreak:RegisterInput(1, Types.AnyArrayType, "Array", "匹配符数组", {},  false, BATNode.DEFAULT_GROUP);

ForLoopBreak:RegisterOutput(1, Types.AnyType, "Array Element", "匹配符", nil, false, BATNode.DEFAULT_GROUP);
ForLoopBreak:RegisterOutput(2, Types.FloatType, "Array Index", "整数索引",nil, false);

ForLoopBreak:RegisterExecInput(1, "Exec", "执行");
ForLoopBreak:RegisterExecInput(2, "Break", "执行", true);

ForLoopBreak:RegisterExecOutput(1, "Loop Body", "执行");
ForLoopBreak:RegisterExecOutput(2, "Completed", "执行");

ForLoopBreak:SetFunctionName("For Loop Break");

return ForLoopBreak ;

