local AE = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local GoIfActive = BlueNode:extend();

---- 游戏运行模式
function GoIfActive:new(...)
	GoIfActive.super.new(self,...);
	self._branch = 1
end

function GoIfActive:_OnUpdate(args)
	if args[1] ~= nil  then
		if args[1]:isActiveHierarchy() then
			self._branch = 1
			return
		end
	end
	self._branch = 2
end

function GoIfActive:_OnNextBranch()
	return self._branch
end


GoIfActive:RegisterInput(1, AE.Node:RTTI(), "target", "node", BlueSelf());

GoIfActive:RegisterExecInput(1, "exec", "judge");
GoIfActive:RegisterExecOutput(1, "active", "go if active");
GoIfActive:RegisterExecOutput(2, "inactive", "go if inactive");

GoIfActive:SetFunctionName("Go If Active");

return GoIfActive;