local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local SetPostEffectValue = require "bluecore.base.set_posteffect_value"
local SetPostEffectVector1 = SetPostEffectValue:extend();


---- 游戏运行模式
function SetPostEffectVector1:new(...)
  SetPostEffectVector1.super.new(self, ...)
end


function SetPostEffectVector1:_IsRightType(value)
  local vec1 = type(value) == "userdata" and value:RTTI() == mathfunction.vector1:RTTI();
  --local scalar = type(value) == "number";
  return vec1;
end



SetPostEffectVector1:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
SetPostEffectVector1:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); 
SetPostEffectVector1:RegisterInput(3, mathfunction.vector1:RTTI(), "ParaValue", "参数值", mathfunction.vector1(1.0));

SetPostEffectVector1:RegisterExecInput(1, "exec", "执行");

SetPostEffectVector1:RegisterExecOutput(1, "exec", "执行");

SetPostEffectVector1:SetFunctionName("SetPostEffectVector1");

return SetPostEffectVector1 ;

