require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local smooth = {}

smooth.renderObject = nil;
smooth.queue = 100;

function smooth:Initialize(host, size)

  self.Stepsize1 = mathfunction.vector2(5, 5);
  self.Stepsize2 = mathfunction.vector2(2, 2);
  self.intensity = 1.0;
  self.size = size;
  
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");
   
  self.TEXTURE_ORIGIN = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_ORIGIN");
  
  self.TEXTURE_BLUR = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLUR");
  self.TEXTURE_MASK = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_MASK");
  self.UNIFORM_INTENSITY = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_INTENSITY");
  
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  
  self.RoGuassXMat = host:CreateMaterial( "comm:documents/material/gaussianblur.material" );
  self.RoGuassXRO = host:CreateRenderObject()
  self.RoGuassXMat:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), 0) );
  
  self.RoGuassYMat = host:CreateMaterial( "comm:documents/material/gaussianblur.material" );
  self.RoGuassYRO = host:CreateRenderObject()
  self.RoGuassYMat:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep1:y()) );
  
  self.HighPassMat = host:CreateMaterial( "comm:documents/material/highpass.material" );
  self.HighPassRO = host:CreateRenderObject()
  
  self.SkinDetectMat = host:CreateMaterial("comm:documents/material/skindetect.material")
  self.SkinDetectRO = host:CreateRenderObject()
  
  self.SkinGuassXMat = host:CreateMaterial( "comm:documents/material/gaussianblur.material" );  --对mask做模糊，平滑边缘
  self.SkinGuassXRO = host:CreateRenderObject()
  self.SkinGuassXMat:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), 0 ) );
  
  self.SkinGuassYMat = host:CreateMaterial( "comm:documents/material/gaussianblur.material" );
  self.SkinGuassYRO = host:CreateRenderObject()
  self.SkinGuassYMat:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep2:y()) );
  
  self.BlendMat = host:CreateMaterial( "comm:documents/material/smoothblend.material" );
  self.BlendRO = host:CreateRenderObject()
  self.BlendMat:SetParameter( self.UNIFORM_INTENSITY, mathfunction.vector1(self.intensity) );
  
  self.GuassXRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size );
  self.OriBlurRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size );
  self.highpassRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_C, size );
  self.HpBlurRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_D, size );
  self.skinRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_E, size );
  
  return self.queue;
end

function smooth:Resizeview(size)
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  self.size = size;
  self.RoGuassXMat:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), 0 ) );
  self.RoGuassYMat:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep1:y() ) );
  self.SkinGuassXMat:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(),0 ) );
  self.SkinGuassYMat:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0,GuassStep2:y() ) );
end

function smooth:Process(context, Original, Scene, Output)
  local origintexture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  self.HighPassMat:SetParameter(self.TEXTURE_ORIGIN, origintexture);
  self:_UpdateParameters();
  
	context:BeginRenderPass(self.GuassXRT, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassXMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	context:Draw(self.RoGuassXRO, self.RoGuassXMat);
	context:EndRenderPass();
  
  context:BeginRenderPass(self.OriBlurRT, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassYMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.GuassXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RoGuassYRO, self.RoGuassYMat);
  context:EndRenderPass();
  
  local blurtex = self.OriBlurRT:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  context:BeginRenderPass(self.highpassRT, apolloengine.RenderTargetEntity.CF_COLOR);
  self.HighPassMat:SetParameter(
          apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
          self.OriBlurRT:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
  context:Draw(self.HighPassRO, self.HighPassMat);
  context:EndRenderPass();
  
  context:BeginRenderPass(self.GuassXRT, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassXMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.highpassRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RoGuassXRO, self.RoGuassXMat);
  context:EndRenderPass();
  
  context:BeginRenderPass(self.HpBlurRT, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassYMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.GuassXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RoGuassYRO, self.RoGuassYMat);
  context:EndRenderPass();
 
  context:BeginRenderPass(self.skinRT, apolloengine.RenderTargetEntity.CF_COLOR);
  self.SkinDetectMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		origintexture);
  context:Draw(self.SkinDetectRO, self.SkinDetectMat);
  context:EndRenderPass();
  
  context:BeginRenderPass(self.GuassXRT, apolloengine.RenderTargetEntity.CF_COLOR);
  self.SkinGuassXMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.skinRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.SkinGuassXRO, self.SkinGuassXMat);
  context:EndRenderPass();
  
  context:BeginRenderPass(self.skinRT, apolloengine.RenderTargetEntity.CF_COLOR);
  self.SkinGuassYMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.GuassXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  context:Draw(self.SkinGuassYRO, self.SkinGuassYMat);
  context:EndRenderPass();
  
  self.BlendMat:SetParameter( self.TEXTURE_ORIGIN,origintexture);
  self.BlendMat:SetParameter( self.TEXTURE_BLUR,blurtex);
  self.BlendMat:SetParameter( self.TEXTURE_MASK,self.skinRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ))
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.BlendMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.HpBlurRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.BlendRO, self.BlendMat);
  context:EndRenderPass();
end

function smooth:_UpdateParameters()
 self.BlendMat:SetParameter( self.UNIFORM_INTENSITY, mathfunction.vector1(self.intensity) );
end

return smooth;