local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local contour_extract = {}
contour_extract.RoGuassX = 0
contour_extract.RoGuassY = 0
contour_extract.Rt1 = 0;
contour_extract.Rt2 = 0;
contour_extract.outRt = 0;
contour_extract.maskRt = 0;

contour_extract.Queue = 100;

function contour_extract:Initialize(host, size)
  
  self.inexpendstep = 0;
  self.erodestep = mathfunction.vector2( 1.0, 1.0 );
  self.dilatestep = mathfunction.vector2( 1.0, 1.0 );
  self.glowstep = 0;
  self.outexpendstep =  0;
  self.blurstep = 0;
  self.smoothstep = 1;
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
  self.FLAG = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "FLAG");
  self.ERODE_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "ERODE_STEP");

  self.DILATE_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "DILATE_STEP");

  self.GLOW_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GLOW_STEP");

  self.INPUTSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "INPUTSIZE");

  self.WIDTH = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "WIDTH");

    self.TEXTURE_DIFFUSE_IN = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "TEXTURE_DIFFUSE_IN");

  self.TEXTURE_DIFFUSE_OUT = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "TEXTURE_DIFFUSE_OUT");

  self.ratio = 2.0;
  self.targetsize = size / self.ratio;
  
  self.host = host
  local GuassStep = mathfunction.vector2( 1.0, 1.0 ) / self.targetsize;
	
	self.RenderObj = host:CreateRenderObject();
	--self.RoGuassX = host:CreateRenderObject( "comm:documents/contour_line/gaussianblur.material" );
	self.RoGuassX = host:CreateMaterial( "comm:documents/contour_line/gaussianblur.material" );
	self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
	
	--self.RoGuassY = host:CreateRenderObject( "comm:documents/contour_line/gaussianblur.material" );
	self.RoGuassY = host:CreateMaterial( "comm:documents/contour_line/gaussianblur.material" );
	self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );

  -- self.p1 = host:CreateRenderObject( "comm:documents/contour_line/contoursmooth1.material" );
  -- self.p2 = host:CreateRenderObject( "comm:documents/contour_line/contoursmooth2.material" );
  -- self.p4 = host:CreateRenderObject( "comm:documents/contour_line/contourextract.material" );
	self.p1 = host:CreateMaterial( "comm:documents/contour_line/contoursmooth1.material" );
	self.p2 = host:CreateMaterial( "comm:documents/contour_line/contoursmooth2.material" );
	self.p4 = host:CreateMaterial( "comm:documents/contour_line/contourextract.material" );

  -- self.ErodeX = host:CreateRenderObject( "comm:documents/contour_line/erode.material" );
  -- self.ErodeY = host:CreateRenderObject( "comm:documents/contour_line/erode.material" );
	self.ErodeX = host:CreateMaterial( "comm:documents/contour_line/erode.material" );
	self.ErodeY = host:CreateMaterial( "comm:documents/contour_line/erode.material" );
  self.ErodeX:SetParameter( self.ERODE_STEP, mathfunction.vector2( self.erodestep:x(), 0 ) );
  self.ErodeX:SetParameter( self.INPUTSIZE, mathfunction.vector2( self.targetsize:x(), self.targetsize:y() ) );
  self.ErodeY:SetParameter( self.ERODE_STEP, mathfunction.vector2( 0, self.erodestep:y() ) );
  self.ErodeY:SetParameter( self.INPUTSIZE, mathfunction.vector2(self.targetsize:x(), self.targetsize:y() ) );


  --self.DilateX = host:CreateRenderObject( "comm:documents/contour_line/dilate_circle_x.material" );
	self.DilateX = host:CreateMaterial( "comm:documents/contour_line/dilate_circle_x.material" );
  self.DilateX:SetParameter( self.DILATE_STEP, mathfunction.vector2( self.dilatestep:x(), 0 ) );
  self.DilateX:SetParameter( self.INPUTSIZE, mathfunction.vector2( self.targetsize:x(), self.targetsize:y() ) );
  --self.DilateY = host:CreateRenderObject( "comm:documents/contour_line/dilate_circle_y.material" );
  self.DilateY = host:CreateMaterial( "comm:documents/contour_line/dilate_circle_y.material" );
  self.DilateY:SetParameter( self.DILATE_STEP, mathfunction.vector2( 0, self.dilatestep:y() ) );
  self.DilateY:SetParameter( self.INPUTSIZE, mathfunction.vector2(self.targetsize:x(), self.targetsize:y() ) );


  --self.GlowX = host:CreateRenderObject( "comm:documents/contour_line/glow.material" );
	self.GlowX = host:CreateMaterial( "comm:documents/contour_line/glow.material" );
	self.GlowX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
  self.GlowX:SetParameter( self.INPUTSIZE, mathfunction.vector2( self.targetsize:x(), self.targetsize:y() ) );
	self.GlowX:SetParameter( self.WIDTH, mathfunction.vector1( 3 ) );
	
	--self.GlowY = host:CreateRenderObject( "comm:documents/contour_line/glow.material" );
	self.GlowY = host:CreateMaterial( "comm:documents/contour_line/glow.material" );
	self.GlowY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
  self.GlowY:SetParameter( self.INPUTSIZE, mathfunction.vector2( self.targetsize:x(), self.targetsize:y() ) );
	self.GlowY:SetParameter( self.WIDTH, mathfunction.vector1( 3 ) );
	
  self:_UpdateResFBOs(self.host);
  
  host:RegisterScriptParameter(self,"smoothstep");
  host:RegisterScriptParameter(self,"blurstep");
  host:RegisterScriptParameter(self,"inexpendstep");
  host:RegisterScriptParameter(self,"outexpendstep");
  host:RegisterScriptParameter(self,"glowstep");
  return self.Queue;
end

function contour_extract:Resizeview(size)
	self.targetsize = size / self.ratio;
end


function contour_extract:Process(context, Original, Scene, Output)
  self:_Updateparameters()
  if self.targetsize_bk ~= self.targetsize then 
    self:_UpdateResFBOs(self.host);
  end

  -- self.Rt1:PushRenderTarget();
  -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassX:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassX:Draw(pipeline);	

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassX:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassX);
  context:EndRenderPass();
  
  -- self.Rt2:PushRenderTarget();
  -- self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassY:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassY:Draw(pipeline);	

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassY);
  context:EndRenderPass();

  -- self.Rt1:PushRenderTarget();
  -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.p1:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.p1:Draw(pipeline);

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.p1:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.p1);
  context:EndRenderPass();
  
	-- self.Rt2:PushRenderTarget();
	-- self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	-- self.RoGuassX:SetParameter(
	-- 	apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
	-- 	self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	-- self.RoGuassX:Draw(pipeline);

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassX:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassX);
  context:EndRenderPass();


  -- self.Rt1:PushRenderTarget();
	-- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	-- self.RoGuassY:SetParameter(
	-- 	apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
	-- 	self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	-- self.RoGuassY:Draw(pipeline);

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassY);
  context:EndRenderPass();

  -- self.Rt2:PushRenderTarget();
	-- self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.p2:SetParameter(
	-- 	apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
	-- 	self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	-- self.p2:Draw(pipeline);

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.p2:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.p2);
  context:EndRenderPass();

  -- self.Rt1:PushRenderTarget();
	-- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	-- self.RoGuassX:SetParameter(
	-- 	apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
	-- 	self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	-- self.RoGuassX:Draw(pipeline);

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassX:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassX);
  context:EndRenderPass();

  -- self.maskRt:PushRenderTarget();
	-- self.maskRt:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	-- self.RoGuassY:SetParameter(
	-- 	apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
	-- 	self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	-- self.RoGuassY:Draw(pipeline);

  context:BeginRenderPass(self.maskRt, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassY);
  context:EndRenderPass();

  if self.outexpendstep >=0 then

    self.DilateX:SetParameter( self.DILATE_STEP, mathfunction.vector2( self.outexpendstep/5, 0 ) );
    self.DilateY:SetParameter( self.DILATE_STEP, mathfunction.vector2( 0, self.outexpendstep/5 ) );

    -- self.Rt1:PushRenderTarget();
    -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.DilateX:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.DilateX:Draw(pipeline);

    context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
    self.DilateX:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.DilateX);
    context:EndRenderPass();
      
    -- self.Rt2:PushRenderTarget();
    -- self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.DilateY:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.DilateY:Draw(pipeline);

    context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
    self.DilateY:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.DilateY);
    context:EndRenderPass();

    self.DilateX:SetParameter( self.DILATE_STEP, mathfunction.vector2( self.outexpendstep, 0 ) );
    self.DilateY:SetParameter( self.DILATE_STEP, mathfunction.vector2( 0, self.outexpendstep ) );

    -- self.Rt1:PushRenderTarget();
    -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.DilateX:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.DilateX:Draw(pipeline);

    context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
    self.DilateX:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.DilateX);
    context:EndRenderPass();
      
    -- self.outRt:PushRenderTarget();
    -- self.outRt:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.DilateY:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.DilateY:Draw(pipeline);

    context:BeginRenderPass(self.outRt, apolloengine.RenderTargetEntity.CF_COLOR);
    self.DilateY:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.DilateY);
    context:EndRenderPass();

  elseif self.outexpendstep < 0 then
    self.ErodeX:SetParameter( self.ERODE_STEP, mathfunction.vector2( self.outexpendstep*-10, 0 ) );
    self.ErodeY:SetParameter( self.ERODE_STEP, mathfunction.vector2( 0, self.outexpendstep*-10 ) );


    -- self.Rt1:PushRenderTarget();
    -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.ErodeX:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.ErodeX:Draw(pipeline);

    context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
    self.ErodeX:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.ErodeX);
    context:EndRenderPass();
      

    -- self.outRt:PushRenderTarget();
    -- self.outRt:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.ErodeY:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.ErodeY:Draw(pipeline);

    context:BeginRenderPass(self.outRt, apolloengine.RenderTargetEntity.CF_COLOR);
    self.ErodeY:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.ErodeY);
    context:EndRenderPass();
  end

  if self.inexpendstep >= 0 then

    self.DilateX:SetParameter( self.DILATE_STEP, mathfunction.vector2( self.inexpendstep/5, 0 ) );
    self.DilateY:SetParameter( self.DILATE_STEP, mathfunction.vector2( 0, self.inexpendstep/5 ) );

    -- self.Rt1:PushRenderTarget();
    -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.DilateX:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.DilateX:Draw(pipeline);

    context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
    self.DilateX:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.DilateX);
    context:EndRenderPass();
      
    -- self.Rt2:PushRenderTarget();
    -- self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.DilateY:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.DilateY:Draw(pipeline);

    context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
    self.DilateY:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.DilateY);
    context:EndRenderPass();

    self.DilateX:SetParameter( self.DILATE_STEP, mathfunction.vector2( self.inexpendstep, 0 ) );
    self.DilateY:SetParameter( self.DILATE_STEP, mathfunction.vector2( 0, self.inexpendstep ) );

    -- self.Rt1:PushRenderTarget();
    -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.DilateX:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.DilateX:Draw(pipeline);

    context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
    self.DilateX:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.DilateX);
    context:EndRenderPass();

    -- self.maskRt:PushRenderTarget();
    -- self.maskRt:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.DilateY:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.DilateY:Draw(pipeline);

    context:BeginRenderPass(self.maskRt, apolloengine.RenderTargetEntity.CF_COLOR);
    self.DilateY:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.DilateY);
    context:EndRenderPass();

  elseif self.inexpendstep < 0 then
    self.ErodeX:SetParameter( self.ERODE_STEP, mathfunction.vector2( self.inexpendstep*-10, 0 ) );
    self.ErodeY:SetParameter( self.ERODE_STEP, mathfunction.vector2( 0, self.inexpendstep*-10 ) );

    -- self.Rt1:PushRenderTarget();
    -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.ErodeX:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.ErodeX:Draw(pipeline);

    context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
    self.ErodeX:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.ErodeX);
    context:EndRenderPass();

    -- self.maskRt:PushRenderTarget();
    -- self.maskRt:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.ErodeY:SetParameter(
    --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.ErodeY:Draw(pipeline);

    context:BeginRenderPass(self.maskRt, apolloengine.RenderTargetEntity.CF_COLOR);
    self.ErodeY:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.ErodeY);
    context:EndRenderPass();
  end

  -- self.Rt1:PushRenderTarget();
  -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassX:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.outRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassX:Draw(pipeline);	

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassX:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.outRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassX);
  context:EndRenderPass();
  
  -- self.outRt:PushRenderTarget();
  -- self.outRt:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassY:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassY:Draw(pipeline);	

  context:BeginRenderPass(self.outRt, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassY);
  context:EndRenderPass();

  -- self.Rt1:PushRenderTarget();
  -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassX:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassX:Draw(pipeline);	

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassX:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassX);
  context:EndRenderPass();
  
  -- self.maskRt:PushRenderTarget();
  -- self.maskRt:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassY:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassY:Draw(pipeline);	

  context:BeginRenderPass(self.maskRt, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassY);
  context:EndRenderPass();

  if self.blurstep == 0 and self.glowstep == 0 then
    -- Output:PushRenderTarget();
    -- Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.p4:SetParameter(
    --   self.TEXTURE_DIFFUSE_IN,
    --   self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.p4:SetParameter(
    --   self.TEXTURE_DIFFUSE_OUT,
    --   self.outRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.p4:Draw(pipeline);

    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
    self.p4:SetParameter(
      self.TEXTURE_DIFFUSE_IN,
      self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    self.p4:SetParameter(
      self.TEXTURE_DIFFUSE_OUT,
      self.outRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.p4);
    context:EndRenderPass();
  else
    -- self.Rt1:PushRenderTarget();
    -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    -- self.p4:SetParameter(
    --   self.TEXTURE_DIFFUSE_IN,
    --   self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.p4:SetParameter(
    --   self.TEXTURE_DIFFUSE_OUT,
    --   self.outRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    -- self.p4:Draw(pipeline);

    context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
    self.p4:SetParameter(
      self.TEXTURE_DIFFUSE_IN,
      self.maskRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    self.p4:SetParameter(
      self.TEXTURE_DIFFUSE_OUT,
      self.outRt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.RenderObj, self.p4);
    context:EndRenderPass();
  end

  if self.blurstep > 0 and self.glowstep == 0 then
    self:blur(context, Output)
  else
    self:blur(context, self.Rt1)
  end

  if self.glowstep > 0 then
    self:glow(context, Output)
  end
end

function contour_extract: blur(context, Output)
  self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( self.blurstep/3/self.targetsize:x(), 0 ) );
  self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, self.blurstep/3/self.targetsize:x() ) );
  self.RoGuassX:SetParameter(self.FLAG, mathfunction.vector1(-1.0));
  self.RoGuassY:SetParameter(self.FLAG ,mathfunction.vector1(-1.0));

  -- self.Rt2:PushRenderTarget();
  -- self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassX:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassX:Draw(pipeline);	

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassX:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassX);
  context:EndRenderPass();

  -- self.Rt1:PushRenderTarget();
  -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassY:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassY:Draw(pipeline);	

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassY);
  context:EndRenderPass();


  self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( self.blurstep/10/self.targetsize:x(), 0 ) );
  self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, self.blurstep/10/self.targetsize:y() ) );

  -- self.Rt2:PushRenderTarget();
  -- self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassX:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassX:Draw(pipeline);	

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassX:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassX);
  context:EndRenderPass();

  -- self.Rt1:PushRenderTarget();
  -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassY:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassY:Draw(pipeline);	

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassY);
  context:EndRenderPass();

  -- self.Rt2:PushRenderTarget();
  -- self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassX:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassX:Draw(pipeline);	

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassX:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassX);
  context:EndRenderPass();

  -- Output:PushRenderTarget();
  -- Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.RoGuassY:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.RoGuassY:Draw(pipeline);
  
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassY);
  context:EndRenderPass();

  self.RoGuassX:SetParameter(self.FLAG, mathfunction.vector1(1.0));
  self.RoGuassY:SetParameter(self.FLAG ,mathfunction.vector1(1.0));
end

function contour_extract: glow(context, Output)
  self.GlowX:SetParameter( self.WIDTH, mathfunction.vector1( 3 ) );
  self.GlowY:SetParameter( self.WIDTH, mathfunction.vector1( 3 ) );
  self.GlowX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0.1*self.glowstep/self.targetsize:x(), 0 ) );
  self.GlowY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, 0.1*self.glowstep/self.targetsize:y() ) );

  -- self.Rt2:PushRenderTarget();
  -- self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.GlowX:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.GlowX:Draw(pipeline);	

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.GlowX:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.GlowX);
  context:EndRenderPass();

  -- self.Rt1:PushRenderTarget();
  -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.GlowY:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.GlowY:Draw(pipeline);	

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.GlowY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.GlowY);
  context:EndRenderPass();

  self.GlowX:SetParameter( self.WIDTH, mathfunction.vector1(7 ) );
  self.GlowY:SetParameter( self.WIDTH, mathfunction.vector1( 7 ) );
  self.GlowX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0.1*self.glowstep/2/self.targetsize:x(), 0 ) );
  self.GlowY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, 0.1*self.glowstep/2/self.targetsize:y() ) );

  -- self.Rt2:PushRenderTarget();
  -- self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.GlowX:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.GlowX:Draw(pipeline);	

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.GlowX:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.GlowX);
  context:EndRenderPass();

  -- self.Rt1:PushRenderTarget();
  -- self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.GlowY:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.GlowY:Draw(pipeline);	

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.GlowY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.GlowY);
  context:EndRenderPass();

  self.GlowX:SetParameter( self.WIDTH, mathfunction.vector1(3 ) );
  self.GlowY:SetParameter( self.WIDTH, mathfunction.vector1( 3 ) );
  self.GlowX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 1/self.targetsize:x(), 0 ) );
  self.GlowY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, 1/self.targetsize:y() ) );

  -- self.Rt2:PushRenderTarget();
  -- self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.GlowX:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.GlowX:Draw(pipeline);	

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.GlowX:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.GlowX);
  context:EndRenderPass();

  -- Output:PushRenderTarget();
  -- Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  -- self.GlowY:SetParameter(
  --   apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --   self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.GlowY:Draw(pipeline);	

  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.GlowY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.GlowY);
  context:EndRenderPass();
end

function contour_extract: _Updateparameters()
  local GuassStep = mathfunction.vector2( 1, 1) / self.targetsize;

  self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
  self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );

  self.ErodeX:SetParameter( self.INPUTSIZE, mathfunction.vector2( self.targetsize:x(), self.targetsize:y() ) );
  self.ErodeY:SetParameter( self.INPUTSIZE, mathfunction.vector2(self.targetsize:x(), self.targetsize:y() ) );

  self.DilateX:SetParameter( self.INPUTSIZE, mathfunction.vector2( self.targetsize:x(), self.targetsize:y() ) );
  self.DilateY:SetParameter( self.INPUTSIZE, mathfunction.vector2(self.targetsize:x(), self.targetsize:y() ) );

  self.GlowX:SetParameter( self.INPUTSIZE, mathfunction.vector2( self.targetsize:x(), self.targetsize:y() ) );
  self.GlowY:SetParameter( self.INPUTSIZE, mathfunction.vector2( self.targetsize:x(), self.targetsize:y() ) );

end

function contour_extract: _UpdateResFBOs(host)
    self.Rt1 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, self.targetsize );
    self.Rt2 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, self.targetsize );
    self.outRt = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_C, self.targetsize );
    self.maskRt = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_D, self.targetsize );
    
    self.targetsize_bk = self.targetsize;
end

return contour_extract;