

#DEFPARAMS
_MainTex = {"main Color", TEXTURE2D, "white" },
_Brightness = {"Brightness", FLOAT, "1.0"},
_Contrast = {"Contrast", FLOAT, "1.0"},
_Saturation = {"Saturation", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "GreyDisp"
RenderQueue = "POSTEFFECT"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv     : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
SamplerState _MainSampler;
float _Brightness;
float _Contrast;
float _Saturation;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	float4 renderTex = _MainTex.Sample(_MainSampler, i.uv);		
	float3 finalColor = renderTex.xyz * _Brightness;
	float gray = 0.2125 * renderTex.r + 0.7154 * renderTex.g + 0.0721 * renderTex.b;
	float3 grayColor = float3(gray, gray, gray);
	finalColor = lerp(grayColor, finalColor, _Saturation);
	float3 avgColor = float3(0.5, 0.5, 0.5);
	finalColor = lerp(avgColor, finalColor, _Contrast);
	float grey = dot(finalColor.rgb, float3(0.22, 0.707, 0.071));
	finalColor.rgb = float3(grey, grey, grey);

	mainColor = float4(finalColor.rgb, renderTex.a);
}
ENDCG
#END
