#DEFPARAMS
_TexMask = {"TexMask", TEXTURE2D, "white" },
_TexR = {"TexR", TEXTURE2D, "white" },
_TexG = {"TexG", TEXTURE2D, "white" },


_MaskR = {"MaskR", FLOAT, "1.0"},
_MaskG = {"MaskG", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "MixBySegment"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv     : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D _TexMask;
Texture2D  _TexR;
Texture2D  _TexG;
SamplerState _MaskSampler;
SamplerState _RSampler;
SamplerState _GSampler;


float _MaskR;
float _MaskG;


v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{	
	float2 maskuv =  i.uv;

    float maskcolor  = _TexMask.Sample(_MaskSampler, maskuv).a;

	float4 colorr  = _TexR.Sample(_RSampler, i.uv).rgba;
	float4 colorg  = _TexG.Sample(_GSampler, i.uv).rgba;


	mainColor = colorr*maskcolor*_MaskR
					  + colorg*(1-maskcolor)*_MaskG;
}
ENDCG
#END
