

#DEFPARAMS
#END

#DEFTAG
ShaderName = "Combine"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_GLOSSINESS;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_GLOSSINESS_Sampler;
float2 COMBINE_WEIRHT;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	float4 Color_Ori = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
	float4 Color_Glo = TEXTURE_GLOSSINESS.Sample(TEXTURE_GLOSSINESS_Sampler, i.uv);
	mainColor = float4( Color_Ori.xyz*COMBINE_WEIRHT.x + Color_Glo.xyz*COMBINE_WEIRHT.y, Color_Ori.a ) ;
}
ENDCG
#END
