#DEFPARAMS
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
AXIS_RIGHT = { "axis right",  VEC3, "0.0,0.0,0.0" },
AXIS_UP = { "axis up",  VEC3, "0.0,0.0,0.0" },
[Keywords(VIEWPLANE, VIEWPOSITION, AXIS, VELOCITY)]
ORIENT = { "orient",  FLOAT, "1.0" },
[Keywords(NON_INSTANCING, GPU_INSTANCING)]
RENDER_METHODD = { "gpu_instancing",  FLOAT, "1.0" },
LOCK_Y = { "lock y",  FLOAT, "1.0" },
SIM_SPACE = {"sim space", FLOAT, "0.0"},
IMAGE_INFO = {"image info", VEC4, "0.0,0.0,1.0,1.0"},
STRETCHED_SCALE = {"stretched scale", VEC2, "0.0,1.0"},
ROTATE_CENTER = {"rotate center", VEC4, "1.0,1.0,1.0,0.0"},
PIVOT_OFFSET_SCALE = {"pivot offset scale", VEC3, "0.0,0.0,0.0"},
_Opacity = { "Opacity", FLOATRANGE, "1.0, 1, 0" },
[Keywords(BLEND_NORMAL, BLEND_MULTIPLY, BLEND_SCREEN, BLEND_HUE, BLEND_SATURATION, BLEND_LUMINOSITY, BLEND_COLOR, BLEND_BLEND, BLEND_EXCLUSION, BLEND_HARDLIGHT, BLEND_VIVIDLIGHT, BLEND_OVERLAY, BLEND_COLORBURN, BLEND_COLORDODGE, BLEND_SOFTLIGHT, BLEND_HARDMIX, BLEND_PINLIGHT, BLEND_LINEARLIGHT, BLEND_DIFF, BLEND_LINEARBURN, BLEND_SUB, BLEND_LUT, BLEND_ADD)]
_BlendMode = {"Blend Mode", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_DefMode = { "Def Mode", FLOAT, "0.0"},
_LutMap = {"Lut Map", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "particle_billboard"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc",  "%_BlendDst" , ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile VIEWPLANE VIEWPOSITION AXIS VELOCITY
#pragma multi_compile_fbfetch
#include "common.inc"
#include "blendfunc_plenty.inc"
#pragma multi_compile BLEND_NORMAL BLEND_MULTIPLY BLEND_SCREEN BLEND_HUE BLEND_SATURATION BLEND_LUMINOSITY BLEND_COLOR BLEND_BLEND BLEND_EXCLUSION BLEND_HARDLIGHT BLEND_VIVIDLIGHT BLEND_OVERLAY BLEND_COLORBURN BLEND_COLORDODGE BLEND_SOFTLIGHT BLEND_HARDMIX BLEND_PINLIGHT BLEND_LINEARLIGHT BLEND_DIFF BLEND_LINEARBURN BLEND_SUB BLEND_LUT BLEND_ADD
#pragma multi_compile NON_INSTANCING GPU_INSTANCING

struct appdata
{
  float2 vertex : POSITION;
  float2 uv : TEXCOORD0;
#ifdef GPU_INSTANCING
  float3 in_Position : TEXCOORD4;
  float4 in_Particle_Color : TEXCOORD6;
  float4 in_Size_Frame : TEXCOORD5;
  float4 in_Velocity : TEXCOORD7;
  float3 in_Rotation : NORMAL;
#else 
  float3 in_Position : TEXCOORD2;
  float4 in_Particle_Color : COLOR0;
  float4 in_Size_Frame : TEXCOORD1;
  float3 in_Velocity : TEXCOORD3;
  float3 in_Rotation : NORMAL;
#endif
};

struct v2f
{
  float4 vertex : SV_POSITION;
  float2 uv : TEXCOORD0;
  float4 out_SurfaceColor: TEXCOORD2;
  float4 screenPos : TEXCOORD4;
};

float3    AXIS_RIGHT;
float3    AXIS_UP;
float     ORIENT;
float     LOCK_Y;
float     SIM_SPACE;
float4    IMAGE_INFO;
float2    STRETCHED_SCALE;
float4    ROTATE_CENTER;
float3    PIVOT_OFFSET_SCALE;
float     _DefMode;

v2f vert(appdata v)
{
  float4x4 in_LocalWorld = LOCALWORLD_TRANSFORM;
  float4x4 in_View = CAMERA_VIEW;
  float4x4 in_ViewProj = CAMERA_VIEWPROJ;
  float3   in_ViewOrigin = CAMERA_WORLDPOSITION;

  float3 in_AxisRight = AXIS_RIGHT;
  float3 in_AxisUp = AXIS_UP;
  float  in_Orient = ORIENT;
  float  in_LockY = LOCK_Y;
  float  in_SimSpace = SIM_SPACE;
  float4 in_subImageInfo = IMAGE_INFO;
  float2 in_StretchedScale = STRETCHED_SCALE;
  float4 in_RotateCenter = ROTATE_CENTER;
  float3 in_PivotOffsetScale = PIVOT_OFFSET_SCALE;

  v2f o;
  o.vertex = float4(v.vertex,0.0,1.0);
  o.out_SurfaceColor = v.in_Particle_Color;

  float3 position = v.in_Position;
  float2 uvflip = sign((v.in_Size_Frame).xy);
  float2 size = abs((v.in_Size_Frame).xy);
  float2 frame = (v.in_Size_Frame).zw;
  float3 velocity = -v.in_Velocity;
  float2 ExtraStretch = float2(1.0,1.0);
  float flag = 0;

  float4 worldPosition = float4(position, 1.0f);
  if(in_SimSpace<2.0) //Local Space
  {
    worldPosition = mul(worldPosition, in_LocalWorld);
    velocity = mul(float4(velocity, 0.0f), in_LocalWorld).xyz;
  }

  float3 axisForward, axisRight, axisUp;
  #ifdef VELOCITY
    axisForward = in_ViewOrigin - worldPosition.xyz;
    axisRight = normalize(velocity);
    axisUp = normalize(cross(axisForward, axisRight));
    float speed = length(velocity);
    ExtraStretch.x = in_StretchedScale.y + speed * in_StretchedScale.x;
    axisForward = normalize(cross(axisRight, axisUp));
 #elif AXIS
    axisRight = normalize(in_AxisRight);
    axisUp = normalize(in_AxisUp);
    if(in_RotateCenter.a > 0.0)
    {
      axisForward = normalize(worldPosition.xyz - in_RotateCenter.xyz);
      axisRight = cross(axisUp, axisForward);
      axisUp= cross(axisForward, axisRight);
    }
    else
    {
      axisForward = normalize(cross(axisRight, axisUp));
    }
  #elif VIEWPOSITION
    axisForward = in_ViewOrigin - worldPosition.xyz;
    axisRight = normalize(cross(float3(in_View[1].x, in_View[1].y, in_View[1].z), axisForward));
    axisUp = in_LockY * float3(0.0, 1.0, 0.0) + (1.0 - in_LockY) * normalize(cross(axisForward, axisRight));
    axisForward = cross(axisRight, axisUp);
  #elif VIEWPLANE
    axisRight = float3(in_View[0].x, in_View[0].y, in_View[0].z);
    axisUp = in_LockY * float3(0.0, 1.0, 0.0) + (1.0 - in_LockY) * float3(in_View[1].x, in_View[1].y, in_View[1].z);
    axisForward = normalize(cross(axisRight, axisUp));
  #endif

  float cx = cos(v.in_Rotation.x);
  float sx = sin(v.in_Rotation.x);
  float cy = cos(v.in_Rotation.y);
  float sy = sin(v.in_Rotation.y);
  float cz = cos(v.in_Rotation.z);
  float sz = sin(v.in_Rotation.z);
  float3x3 rotate = float3x3(cz * cy, cz * sy * sx - cx * sz, sz * sx + cz * cx * sy,
                        cy * sz, cz * cx + sz * sy * sx, cx * sy * sz  - cz * sx,
                        -sy, cy * sx, cy * cx);
  
  float3x3 axis = float3x3( axisRight.x, axisUp.x, axisForward.x,
                                axisRight.y, axisUp.y, axisForward.y,
                                axisRight.z, axisUp.z, axisForward.z);
 
  float3x3 rotMatrix = mul(axis,rotate);
  worldPosition.xyz += mul(rotMatrix, ((o.vertex.xyz*float3(ExtraStretch,0.0) + in_PivotOffsetScale) * float3(size.x,size.y,size.x)));
  
  float2 uv;
  flag = step(0.0f,uvflip.x);
  uv.x = flag * (v.uv).x  + (1.0 - flag) *(1.0f - (v.uv).x);
  flag = step(0.0f,uvflip.y);
  uv.y = flag * (v.uv).y  + (1.0 - flag) *(1.0f - (v.uv).y);

  o.uv = (float2(frame.x, frame.y) + uv) * float2(IMAGE_INFO.z, IMAGE_INFO.w);
  
  o.vertex = mul(worldPosition, in_ViewProj);
  o.screenPos = ComputeScreenPos(o.vertex);
  o.vertex = UniformNDC(o.vertex);
  
  return o;
}

float4 GetSourceColor(v2f i, float4 fbColor)
{
#if FRAMEBUFFER_FETCH 
	return fbColor; 
#else
	float2 uvCoord = i.screenPos.xy / i.screenPos.w;
	float4 srcColor = TEXTURE_GRAP.Sample(TEXTURE_GRAP_Sampler, uvCoord);
	return srcColor;
#endif
}

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
Texture2D _LutMap;
SamplerState _LutSampler;
float _Opacity;

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
#define in_Texture TEXTURE_DIFFUSE
    float4 blendColor = float4(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv)) * i.out_SurfaceColor;
    float4 resultColor = float4(1.0, 1.0, 1.0, 1.0);
    float  factor = _Opacity * blendColor.a;

#if FRAMEBUFFER_FETCH 
	#if SHADER_API_GLES || SHADER_API_GLES3
	float4 fbc = FramebufferFetchES2();
	#else
	float4 fbc = float4(0.0, 0.0, 0.0, 0.0);
	#endif
#else
	float4 fbc = resultColor;
#endif

#if BLEND_NORMAL
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, factor);
#elif BLEND_MULTIPLY
    float4 whiteColor = float4(1.0, 1.0, 1.0, 1.0);
    blendColor = whiteColor - factor * (whiteColor - blendColor);
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);
#elif BLEND_SCREEN
    blendColor = factor * blendColor;
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);
#elif BLEND_HUE
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(blendHSL.r, baseHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
#elif BLEND_SATURATION
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(baseHSL.r, blendHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
#elif BLEND_LUMINOSITY
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(baseHSL.r, baseHSL.g, blendHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
#elif BLEND_COLOR
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(blendHSL.r, blendHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
#elif BLEND_BLEND
		float4 srcColor = GetSourceColor(i, fbc);
		float imgIntensity = dot(float3(0.2990,0.5870,0.1140), srcColor.rgb);
		float3 resIntColor = (imgIntensity * 1.68) * blendColor.rgb;
		resultColor.rgb = resIntColor;
    resultColor.a = factor;
#elif BLEND_EXCLUSION
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendExclusion(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_HARDLIGHT
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendHardLight(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_VIVIDLIGHT
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendVividLight(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_OVERLAY
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendOverlay(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_COLORBURN
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendColorBurn(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_COLORDODGE
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendColorDodge(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_SOFTLIGHT
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendSoftLight(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_HARDMIX
    float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendHardMix(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_PINLIGHT
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendPinLight(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_LINEARLIGHT
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendLinearLight(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_DIFF
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendDiff(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_LINEARBURN
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendLinearBurn(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_SUB
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.rgb = BlendSub(srcColor.rgb, blendColor.rgb);
		resultColor.a = factor;
#elif BLEND_LUT
		float4 srcColor = GetSourceColor(i, fbc);
		resultColor.r = _LutMap.Sample(_LutSampler, float2(blendColor.r, srcColor.r)).r;
		resultColor.g = _LutMap.Sample(_LutSampler, float2(blendColor.g, srcColor.g)).g;
		resultColor.b = _LutMap.Sample(_LutSampler, float2(blendColor.b, srcColor.b)).b;
		resultColor.a = factor;
#elif BLEND_ADD
    blendColor = blendColor * factor;
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, factor);
#endif

  mainColor = resultColor;
}
ENDCG
#END
