
#DEFPARAMS
AXIS_RIGHT = { "axis right",  VEC3, "0.0,0.0,0.0" },
AXIS_UP = { "axis up",  VEC3, "0.0,0.0,0.0" },
[Keywords(VIEWPLANE, VIEWPOSITION, AXIS, VELOCITY)]
ORIENT = { "orient",  FLOAT, "1.0" },
LOCK_Y = { "lock y",  FLOAT, "1.0" },
SIM_SPACE = {"sim space", FLOAT, "0.0"},
IMAGE_INFO = {"image info", VEC4, "0.0,0.0,1.0,1.0"},
STRETCHED_SCALE = {"stretched scale", VEC2, "0.0,1.0"},
ROTATE_CENTER = {"rotate center", VEC4, "1.0,1.0,1.0,0.0"},
PIVOT_OFFSET_SCALE = {"pivot offset scale", VEC3, "0.0,0.0,0.0"},
_MainTex = { "Main Tex", TEXTURE2D, "white" },
_MainTexTile = { "Main Tex Tile", VEC2, "1.0,1.0"},
_MainTexOffset = { "Main Tex Offset", VEC2, "0.0,0.0"},
_Color = { "Color", COLOR, "1.0,1.0,1.0,1.0"},
_ColorScale = { "Color Scale", FLOAT, "1.0"},
_MainTex_UV_Speed = { "MainTex UV Speed", VEC2, "0.0,0.0"},
_DisortTex = { "Disort Tex", TEXTURE2D, "white"},
_Itensity = { "Itensity", FLOAT, "0.0"},
_DisortTex_UV_Speed = { "DisortTex UV Speed", VEC2, "0.0,0.0"},
_MaskTex = { "Mask Tex", TEXTURE2D, "white"},
_MaskTexTile = { "Mask Tex Tile", VEC2, "1.0,1.0"},
_MaskTexOffset = { "Mask Tex Offset", VEC2, "0.0,0.0"},
_Power = {"Power", FLOAT, "1.0"},
[Keywords(DISORT_ON,DISORT_OFF)]
_Disort = {"Disort", FLOAT, "1.0"},
[Keywords(BLEND_NORMAL,BLEND_ADD)]
_BlendMode = {"Blend Mode", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_DefMode = { "Def Mode", FLOAT, "0.0"},

_FadeScale = {"Fade Scale", FLOAT, "1.0"},
_EdgeSmoothScale = {"Edge Smooth Scale", FLOAT, "1.0"},
_Tex2 = { "Tex2", TEXTURE2D, "white" },
_Tex2_UV_Speed = { "Tex2 UV Speed", VEC2, "0.0,0.0"},
_Tex2Tile = { "Tex2 Tile", VEC2, "1.0,1.0"},
_Tex2Offset = { "Tex2 Offset", VEC2, "0.0,0.0"},

#END

#DEFTAG
ShaderName = "particle_billboard_uv_disort"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc",  "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile VIEWPLANE VIEWPOSITION AXIS VELOCITY
#pragma multi_compile DISORT_ON DISORT_OFF
#pragma multi_compile BLEND_NORMAL BLEND_ADD
#include "common.inc"

struct appdata
{
  float2 vertex : POSITION;
  float2 uv : TEXCOORD0;
  float3 in_Position : TEXCOORD2;
  float4 in_Particle_Color : COLOR0;
  float4 in_Size_Frame : TEXCOORD1;
  float3 in_Velocity : TEXCOORD3;
  float3 in_Rotation : NORMAL;
};

struct v2f
{
  float4 vertex : SV_POSITION;
  float2 uv : TEXCOORD0;
  float4 out_SurfaceColor: TEXCOORD2;
  float disturb : TEXCOORD1; 
};

float3    AXIS_RIGHT;
float3    AXIS_UP;
float     ORIENT;
float     LOCK_Y;
float     SIM_SPACE;
float4    IMAGE_INFO;
float2    STRETCHED_SCALE;
float4    ROTATE_CENTER;
float3    PIVOT_OFFSET_SCALE;
float     _DefMode;
float     _FadeScale;
float     _EdgeSmoothScale;

v2f vert(appdata v)
{
  float4x4 in_LocalWorld = LOCALWORLD_TRANSFORM;
  float4x4 in_View = CAMERA_VIEW;
  float4x4 in_ViewProj = CAMERA_VIEWPROJ;
  float3   in_ViewOrigin = CAMERA_WORLDPOSITION;

  float3 in_AxisRight = AXIS_RIGHT;
  float3 in_AxisUp = AXIS_UP;
  float  in_Orient = ORIENT;
  float  in_LockY = LOCK_Y;
  float  in_SimSpace = SIM_SPACE;
  float4 in_subImageInfo = IMAGE_INFO;
  float2 in_StretchedScale = STRETCHED_SCALE;
  float4 in_RotateCenter = ROTATE_CENTER;
  float3 in_PivotOffsetScale = PIVOT_OFFSET_SCALE;

  v2f o;
  o.vertex = float4(v.vertex,0.0,1.0);
  o.out_SurfaceColor = v.in_Particle_Color;

  float3 position = v.in_Position;
  float2 uvflip = sign((v.in_Size_Frame).xy);
  float2 size = abs((v.in_Size_Frame).xy);
  float2 frame = (v.in_Size_Frame).zw;
  float3 velocity = -v.in_Velocity;
  float2 ExtraStretch = float2(1.0,1.0);
  float flag = 0;

  float4 worldPosition = float4(position, 1.0f);
  if(in_SimSpace<2.0) //Local Space
  {
    worldPosition = mul(worldPosition, in_LocalWorld);
    velocity = mul(float4(velocity, 0.0f), in_LocalWorld).xyz;
  }

  float3 axisForward, axisRight, axisUp;
  #ifdef VELOCITY
    axisForward = in_ViewOrigin - worldPosition.xyz;
    axisRight = normalize(velocity);
    axisUp = normalize(cross(axisForward, axisRight));
    float speed = length(velocity);
    ExtraStretch.x = in_StretchedScale.y + speed * in_StretchedScale.x;
    axisForward = normalize(cross(axisRight, axisUp));
 #elif AXIS
    axisRight = normalize(in_AxisRight);
    axisUp = normalize(in_AxisUp);
    if(in_RotateCenter.a > 0.0)
    {
      axisForward = normalize(worldPosition.xyz - in_RotateCenter.xyz);
      axisRight = cross(axisUp, axisForward);
      axisUp= cross(axisForward, axisRight);
    }
    else
    {
      axisForward = normalize(cross(axisRight, axisUp));
    }
  #elif VIEWPOSITION
    axisForward = in_ViewOrigin - worldPosition.xyz;
    axisRight = normalize(cross(float3(in_View[1].x, in_View[1].y, in_View[1].z), axisForward));
    axisUp = in_LockY * float3(0.0, 1.0, 0.0) + (1.0 - in_LockY) * normalize(cross(axisForward, axisRight));
    axisForward = cross(axisRight, axisUp);
  #elif VIEWPLANE
    axisRight = float3(in_View[0].x, in_View[0].y, in_View[0].z);
    axisUp = in_LockY * float3(0.0, 1.0, 0.0) + (1.0 - in_LockY) * float3(in_View[1].x, in_View[1].y, in_View[1].z);
    axisForward = normalize(cross(axisRight, axisUp));
  #endif

  float cx = cos(v.in_Rotation.x);
  float sx = sin(v.in_Rotation.x);
  float cy = cos(v.in_Rotation.y);
  float sy = sin(v.in_Rotation.y);
  float cz = cos(v.in_Rotation.z);
  float sz = sin(v.in_Rotation.z);
  float3x3 rotate = float3x3(cz * cy, cz * sy * sx - cx * sz, sz * sx + cz * cx * sy,
                        cy * sz, cz * cx + sz * sy * sx, cx * sy * sz  - cz * sx,
                        -sy, cy * sx, cy * cx);
  
  float3x3 axis = float3x3( axisRight.x, axisUp.x, axisForward.x,
                                axisRight.y, axisUp.y, axisForward.y,
                                axisRight.z, axisUp.z, axisForward.z);
 
  float3x3 rotMatrix = mul(axis,rotate);
  worldPosition.xyz += mul(rotMatrix, ((o.vertex.xyz*float3(ExtraStretch,0.0) + in_PivotOffsetScale) * float3(size.x,size.y,size.x)));
  
  float2 uv;
  flag = step(0.0f,uvflip.x);
  uv.x = flag * (v.uv).x  + (1.0 - flag) *(1.0f - (v.uv).x);
  flag = step(0.0f,uvflip.y);
  uv.y = flag * (v.uv).y  + (1.0 - flag) *(1.0f - (v.uv).y);

  o.uv = (float2(frame.x, frame.y) + uv) * float2(IMAGE_INFO.z, IMAGE_INFO.w);
  
  o.vertex = mul(in_ViewProj, worldPosition);
  o.vertex = UniformNDC(o.vertex);
  
  //disturb
  o.disturb = sin(v.uv.y) * _FadeScale + (1.0 - _FadeScale);
  float3 worldNormal = axis[2];
  float3 worldViewDir =  normalize(CAMERA_WORLDPOSITION - worldPosition.xyz);
  o.disturb = o.disturb * (abs(dot(worldViewDir, worldNormal)) * _EdgeSmoothScale + (1.0 - _EdgeSmoothScale));
  
  return o;
}

Texture2D _MainTex;
SamplerState _MainSampler;
float2 _MainTexTile;
float2 _MainTexOffset;
float4 _Color;
float  _ColorScale;
float2 _MainTex_UV_Speed;
Texture2D _DisortTex;
SamplerState _DisortSampler;
float _Itensity;
float2 _DisortTex_UV_Speed;
Texture2D _MaskTex;
SamplerState _MaskSampler;
float2 _MaskTexTile;
float2 _MaskTexOffset;
float _Power;
float SYSTEM_TIME;
Texture2D _Tex2;
SamplerState _Tex2Sampler;
float2    _Tex2_UV_Speed;
float2    _Tex2Tile;
float2    _Tex2Offset;

float4 frag(v2f i) : SV_Target
{
  float2 uv = i.uv * _MainTexTile + _MainTexOffset;
  float2 uv_MainTex = uv + _MainTex_UV_Speed * SYSTEM_TIME;
  #ifdef DISORT_ON
    float2 uv_DisortTex = uv + _DisortTex_UV_Speed * SYSTEM_TIME;
    float distort = _DisortTex.Sample(_DisortSampler, uv_DisortTex);
    uv_MainTex += float2(distort,distort) * _Itensity;
  #endif
  
  float4 mainColor = _MainTex.Sample(_MainSampler, uv_MainTex);
  
  float2 uv_Tex2 = i.uv * _Tex2Tile + _Tex2Offset + _Tex2_UV_Speed * SYSTEM_TIME;
  float4 Tex2Color = _Tex2.Sample(_Tex2Sampler, uv_Tex2);
  mainColor *= Tex2Color;
  
  float2 uv_Mask = i.uv * _MaskTexTile + _MaskTexOffset;
  float4 maskColor = _MaskTex.Sample(_MaskSampler, uv_Mask);
  float maskAlpha = pow(maskColor.r,_Power);
  mainColor.a = mainColor.a * _Color.a * _ColorScale * i.out_SurfaceColor.a *  maskAlpha* i.disturb;
  #ifdef BLEND_NORMAL
    mainColor.rgb = mainColor.rgb * _Color.rgb * _ColorScale * i.out_SurfaceColor.rgb;
  #else
    mainColor.rgb = mainColor.rgb * _Color.rgb * _ColorScale * i.out_SurfaceColor.rgb * mainColor.a;
  #endif
  return mainColor;
}

ENDCG
#END
