local likeapp = require "likeapp"
local Object = require "classic"


local soundplayer = Object:extend();


local testVolume = 0.0;
local testIndex = 1;
local cachedvolume = 0.0;
function soundplayer:new()
  self.isplay = false;
  if not _PLATFORM_WINDOWS then
    self.player = likeapp.Sound();
  end  
end

function soundplayer:LoadSound(path)
  if _PLATFORM_WINDOWS then
    LOG("load sound "..path);
    return true;
  end  
  return self.player:LoadSound(path);
end

--loop参数，0是无限循环，1之后是循环次数
function soundplayer:PlaySound(loop)
  if not self.isplay then
    self.isplay = true;
    if _PLATFORM_WINDOWS then
      LOG("play sound");
    else
      self.player:PlaySound(loop);
    end
  end
end

function soundplayer:isPlaying()
  if self.isplay then
    if _PLATFORM_WINDOWS then
      --LOG("is playing?");
      self.isplay = math.random() < 0.99;--伪模拟代码
    else
      self.isplay = self.player:isPlaying();
      return self.isplay;
    end
  end  
  return self.isplay;
end

function soundplayer:StopSound()
  if self.isplay then
    self.isplay = false;
    if _PLATFORM_WINDOWS then
      LOG("stop sound");
    else
      self.player:StopSound();
    end  
  end  
end

function soundplayer.GetVolume()
  if _PLATFORM_WINDOWS then
    --local res = math.random();
   --return res;
   if testVolume > 1.0 then
     testVolume = 0.0;
   end
   
   testVolume = testVolume + 0.001;

   return testVolume;
  else
    local volume = likeapp.Sound:GetVolume(0);
    return volume;
  end  
end

function soundplayer.ResetVolume()
  cachedvolume = soundplayer.GetVolume();
end


function soundplayer.GetCachedVolume()
  return cachedvolume;
end

function soundplayer:ResumeSound()
  if self.isplay then
    self.player:ResumeSound()
  end
end

function soundplayer:PauseSound()
  if self.isplay then
    self.player:PauseSound()
  end
end

function soundplayer:FadingSound(initialFading, deltaFading)
  if self.isplay then
    self.player:FadingSound(initialFading, deltaFading)
  end
end

return soundplayer;