local BundleSystem = require "venuscore.bundle.bundlesystem"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local Object = require "classic"
local apolloDefine = require "apolloutility.defiend"
local BlueDefined = require "bluecore.bluedefined"
local vc = require "venuscore"
local GiftScene = Object:extend();

--avatar1: 主播
--avatar2: 观众
local audience = "avatar_1";
local audience2 = "avatar2_1";
local anchor = "avatar_2";
local ancor2 = "avatar2_2";
--服务端avatar关键字
local attrAudience = "avatar1";
local attrAnchor = "avatar2";
local avatarMap = {avatar1 = "avatar_1", avatar2 = "avatar_2"};

--param: sceneSequence 此scene的渲染顺序
function GiftScene:new(sceneSequence)
  self.nativeScene = nil;
  self.scenePath = nil;
  self.sceneSequence = sceneSequence;
  self.outputCamera = {};  --编辑器素材中没有挂RT的相机
  self.allCameraList = {};  --方便给相机设置固定的分辨率
  self.attributeList = nil; --可更改的配置选项
  self.configBehavior = nil; --自定义礼物配置脚本
  self.controlerBehavior = nil; --控制礼物预览与播放切换的脚本
  self.viewportSizeConfig = nil;
  self.avatarConfig = {};
  self.bluePrints = {};
  --默认不显示头像
  self.oldavatarSetting = {avatar_1 = true, avatar_2 = true};
  self.newavatarSetting = {avatar_1 = false, avatar_2 = false};
  
  self.sceneRoot = nil;  --记录场景根节点(尽量把场景的Ative往后放)
  
end

function GiftScene:HideAvatar()
    self:SetAttribute("avatar1","");
    self:SetAttribute("avatar2","");
    self:_HandleAvatarVibility();
end

function GiftScene:LoadConfig(path)
  local bundlepath = venuscore.IFileSystem:PathAssembly(path);
  --local attributeConfigPath = 
  local nativeScene = BundleSystem:DeserializeFromPath(bundlepath,BundleSystem.DeserializeMode.Scene);
  if nativeScene then
    self:_Setup(nativeScene);
    self.nativeScene = nativeScene;
    self.scenePath = bundlepath;
    
    --素材加载完之后再Active
    self.sceneRoot = nativeScene:GetRootNode();
    --sceneRoot.Active = true;
    return true;
  end
  ERROR("Load scene failed!!!");
  return false;
end

function GiftScene:Active()
  if self.sceneRoot and not venuscore.isNil(self.sceneRoot) then
    if self.sceneRoot.Active == false then
      self.sceneRoot.Active = true;
    end
  end
end

function GiftScene:DeActive()
  if self.sceneRoot and not venuscore.isNil(self.sceneRoot) then
    if self.sceneRoot.Active == true then
      self.sceneRoot.Active = false;
    end
  end
end

function GiftScene:LoadAttributeConfig(path)
  local isExist = vc.IFileSystem:isFileExist(path);
  if isExist == false then
    ERROR("Custom config json do not exist!!!");
    return false;
  end
  
  
  local rootConfig = venusjson.LaodJsonFile(path);
  self.attributeList = rootConfig.Attributes;
  self.viewportSizeConfig = rootConfig.Size;
  
  if not self.viewportSizeConfig then
    ERROR("Config Error!! Can't find the viewport size config");
  end
  if not self.attributeList then
    ERROR("Config Error!! Can't find the attribute config");
  end
  
  if self.attributeList and self.viewportSizeConfig then
    return true;
  end
  
  return false;
end




--behavior中有可能动态创建Node，这里把GetOrCreateScene函数换掉
function GiftScene:_BeginUpdate(def)
  local _oldGetOrCreateScene = apolloengine.SceneManager.GetOrCreateScene;
  apolloengine.SceneManager.GetOrCreateScene = function()
    return self.nativeScene;
  end
  return _oldGetOrCreateScene;
end

function GiftScene:Update(def)

  local _oldGetOrCreateScene = self:_BeginUpdate(def);
  
  --处理头像的显示
  self:_HandleAvatarVibility();
  
  if self.nativeScene then
    self.nativeScene:Update(def);
  end
  
  self:_EndUpdate(_oldGetOrCreateScene);
end

function GiftScene:SetOutputTarget(rt)
  for i = 1, #self.outputCamera do
    local camComp = self.outputCamera[i];
    if camComp then
      WARNING("GiftScene:SetOutputTarget" .. tostring(i));
      camComp:AttachRenderTarget(rt);
    end
  end
end

function GiftScene:_HandleAvatarVibility()
  --首先判断头像是否有变化
  local hasAvatarChanged = false;
  for key ,value in pairs(self.newavatarSetting) do
    if self.oldavatarSetting[key] ~= value then
      hasAvatarChanged = true;
      break;
    end
  end
  --如果头像有变化
  if hasAvatarChanged then
    local newSetting = {}
    local cnt = 0;
    --判断现在是单人头像还是双人头像
    for key, value in pairs(self.newavatarSetting) do
      if value == true then
        cnt = cnt + 1;
      end
      newSetting[key] = value;
    end
    
    --根据人数进行处理
    if cnt == 0 then  --不显示头像
      newSetting[audience2] = false;
      newSetting[ancor2] = false;
    elseif cnt == 1 then --显示单人头像
      newSetting["avatar2_1"] = false;
      newSetting["avatar2_2"] = false;
      --显示单人头像
    elseif cnt == 2 then --显示双人头像
      newSetting[audience] = false;
      newSetting[anchor] = false;
      newSetting["avatar2_1"] = true;
      newSetting["avatar2_2"] = true;
    end
    
    for key, value in pairs(self.newavatarSetting) do
      self.oldavatarSetting[key] = value;
    end
    
    --self.oldavatarSetting = self.newavatarSetting;
    --处理头像的可见性和动画
    for key,value in pairs(newSetting) do
      local nodeRefStrc = self.avatarConfig[key];
      if nodeRefStrc then
        for nodeID, nodeRef in pairs(nodeRefStrc) do
          if value == true then
            nodeRef.Active = true;
            self:_PlayAniAndParticle(nodeRef);
          else
            nodeRef.Active = false;
          end
        end
      end
    end
  end
end

function GiftScene:_PlayAniAndParticle(nodeRef)
  local aniComp = nodeRef:GetComponent(apolloengine.Node.CT_ANIMATION);
  local particleComp = nodeRef:GetComponent(apolloengine.Node.CT_PARTICLE);
  if aniComp then
    aniComp:Reset();
  end
  if particleComp then
    particleComp:Reset();
    particleComp:Play();
  end
  local subNodes = nodeRef:GetChildrens();
  for k,v in pairs(subNodes) do
    self:_PlayAniAndParticle(v);
  end
end



function GiftScene:SetAttribute(attributeName,attributeValue)
  WARNING("********************************SetAttribute key is: " .. attributeName .. " Value is: " .. attributeValue);
  local res = true;
  if self.attributeList and self.configBehavior then
    for i = 1, #self.attributeList do
      local attributeStruct = self.attributeList[i];
      if attributeStruct then
        local attrName = attributeStruct.AttributeName;
        if attributeName == attrName then
          local nodeList = attributeStruct.NodeList;
          for j = 1, #nodeList do
            local nodeStruct = nodeList[j];
            local nodeIndex = nodeStruct.Index;
            local nodeConfigName = nodeStruct.Name;
            local nodeRefList = self.configBehavior:GetNodeList();
            local nodeRef = nodeRefList[nodeIndex];
            if nodeRef then
              local slotList = nodeStruct.SlotList;
              for k = 1, #slotList do
                local slotStruct = slotList[k];
                local slotIndex = slotStruct.Index;
                local slotRefList = self.configBehavior:GetTextureSlotList();
                local slot = slotRefList[slotIndex]
                if slot and slot[2] == true then
                  local slotName = slot[1];
                  
                  local renderComp = nodeRef:GetComponent(apolloengine.Node.CT_RENDER);
                  if renderComp then
                    local venusValue = self:_SetupAttributeValue(attributeName,attributeValue);
                    if venusValue then
                      renderComp:SetParameter(slot[1],venusValue);
                      local nodeName= nodeRef:GetName();
                      WARNING("********************************NodeName is: " .. nodeName .. " Slot name is: " .. slotName .. " set " .. attributeName .. " to: " .. attributeValue);
                    end
                    if attributeName == attrAudience or attributeName == attrAnchor then
                      local nodeName= nodeRef:GetName();
                      
                      self.avatarConfig[nodeName] = self.avatarConfig[nodeName] or {};
                      self.avatarConfig[nodeName][tostring(nodeRef:GetObjectID())] = nodeRef;
                      self.newavatarSetting[avatarMap[attributeName]] = attributeValue ~= "" and true or false;
                    end
                  end
                end
              end
            else
              WARNING("Can't find node! Attrname is: " .. attrName .. "Node index is: " .. tostring(nodeIndex));
            end
          end
        end
      end
    end
  end
  return res;
end

function GiftScene:_SetAvatar(attName,attValue)
  self.newavatarSetting[attName] = attValue ~= "" and true or false; 
end


function GiftScene:_SetCameraViewSize(viewWidth,viewHeight)
  for i = 1, #self.allCameraList do
    local camComp = self.allCameraList[i];
    camComp:ChangeResolution(mathfunction.vector2(viewWidth,viewHeight));
  end
end


--播放场景
function GiftScene:PlayGift()
  self:Active();
  if self.controlerBehavior then
    self.controlerBehavior:PlayGift();
  end
  if self.viewportSizeConfig then
    local playSize = self.viewportSizeConfig.PlaySize;
    if playSize then
      local playWidth = playSize.Width;
      local playHeight = playSize.Height;
      self:_SetCameraViewSize(playWidth,playHeight);
    end
  end
  return true;
end

--预览场景
function GiftScene:PreviewGift()
  self:Active();
  if self.controlerBehavior then
    self.controlerBehavior:PreviewGift();
  end
  if self.viewportSizeConfig then
    local preViewSize = self.viewportSizeConfig.PreviewSize;
    if preViewSize then
      local playWidth = preViewSize.Width;
      local playHeight = preViewSize.Height;
      self:_SetCameraViewSize(playWidth,playHeight);
    end
  end
  return true;
end

function GiftScene:ZoomGift(zoom)
  if self.controlerBehavior then
    self.controlerBehavior:PreviewSetZoom(zoom);
  end
end


function GiftScene:RotateGift(xAngle,yAngle)
  if self.controlerBehavior then
    self.controlerBehavior:PreviewSetRotation(xAngle,yAngle,0.0);
  end
end

function GiftScene:ResetGift()
  if self.controlerBehavior then
    self.controlerBehavior:PreviewReset();
  end
end

function GiftScene:StartCapture()
  if self.controlerBehavior then
    self.controlerBehavior:StartCapture();
  end
end

function GiftScene:_IsAttributeValueValid(attrValue)
  --目前都是字符串(空字符串无效)
  if attrValue == "" then
    return false;
  end
  return true;
end


--创建属性值，目前都是纹理
function GiftScene:_SetupAttributeValue(valueType,attrValue)
  local tex = nil;
  if self:_IsAttributeValueValid(attrValue) == true then
    tex = apolloengine.TextureEntity();
    tex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,
        1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_LINEAR,
        apolloengine.TextureEntity.TF_LINEAR,
        attrValue));
    tex:CreateResource();
  end
  return tex;
end


function GiftScene:_EndUpdate(getOrCreateScene)
  apolloengine.SceneManager.GetOrCreateScene = getOrCreateScene;
end

function GiftScene:_SetupNode(node)
  --一个素材一个Scene应该不需要ResourceType标记了
  if node then
    local camComponent = node:GetComponent(apolloengine.Node.CT_CAMERA);
    local nodeName = node:GetName();
    if camComponent then
      if nodeName ~= "Shadow" then
        camComponent:SetSequenceCulling(false);  --关闭Sequence Culling
        if camComponent:GetAttachedRenderTarget() == nil then
          table.insert(self.outputCamera,camComponent);
        end
        
        camComponent.isFixedResolution = true;   --礼物相机全部设置为固定分辨率
        table.insert(self.allCameraList,camComponent);
      end
    end
    local scriptComponent = node:GetComponent(apolloengine.Node.CT_SCRIPT);
    local blueComponent = node:GetComponent(apolloengine.Node.CT_BLUEPRINT);
    if scriptComponent then
      local insList = scriptComponent.Instances;
      for scrPath, scrIns in pairs(insList) do
        if scrIns:GetTypeName() == "CustomGiftConfigBehavior" then
          self.configBehavior = scrIns;
        elseif scrIns:GetTypeName() == "CustomGiftControllerBehavior" then
          self.controlerBehavior = scrIns;
        end
      end
    end
    if blueComponent then
      local insList = blueComponent.Instances;
      for scrPath, scrIns in pairs(insList) do
        table.insert(self.bluePrints,scrIns);
      end
    end
    
  end
  local subNodes = node:GetChildrens();
  for k,v in pairs(subNodes) do
    self:_SetupNode(v);
  end
end

function GiftScene:_SetupOuputCamera()
  if #self.outputCamera > 0 then
    for i = 1, #self.outputCamera do
      local camComp = self.outputCamera[i];
      camComp:SetClearColor(mathfunction.Color(0.0,0.0,0.0,0.0));
      local hostNode = camComp:GetHostNode();
      local hostNodeName = hostNode:GetName();
      WARNING("Camera node: " .. hostNodeName .. "Clear color(0,0,0,0)");
    end
  end
end


--设置素材输出相机
--第一个输出相机(Sequence最小的)需要将FBO Alpha清理为0
--[[
function GiftScene:_SetupOuputCamera()
  local minOutputCameras = {};
  if #self.outputCamera > 0 then
    local minSequence = self.outputCamera[1]:GetSequence();
    for i = 1, #self.outputCamera do
      local sequence = self.outputCamera[i]:GetSequence();
      if sequence <= minSequence then
        table.insert(minOutputCameras,self.outputCamera[i]);
      end
    end
  end
  for i = 1, #minOutputCameras do
    local camComp = minOutputCameras[i];
    camComp:SetClearColor(mathfunction.Color(0.0,0.0,0.0,0.0));
  end
end
--]]


--[[
function GiftScene:_SetupNode(node)
  --一个素材一个Scene应该不需要ResourceType标记了
  if node then
    local camComponent = node:GetComponent(apolloengine.Node.CT_CAMERA);
    if camComponent then
      camComponent:SetSequenceCulling(false);  --关闭Sequence Culling
      if camComponent:GetAttachedRenderTarget() == nil then
        local clearFlag = apolloengine.RenderTargetEntity.CF_COLOR_DEPTH_STENCIL;
        if self.needClearRt == false or self.needClearRt == nil then  --如果场景中有多个主相机
          local clearFlag = 0;
        end
        camComponent:SetClearFlag(clearFlag);
        camComponent:SetClearColor(mathfunction.Color(0.0,0.0,0.0,0.0));
        table.insert(self.outputCamera,camComponent);
      end
    end
  end
  local subNodes = node:GetChildrens();
  for k,v in pairs(subNodes) do
    self:_SetupNode(v);
  end
end
--]]

--目前一个素材一个Scene，不用在设置ResourceType标记了
--只需要把最终的输出相机找出来，给输出相机挂同一个FBO
function GiftScene:_Setup(scene)
  scene:SetSequence(self.sceneSequence);
  local sceneRoot = scene:GetRootNode();
  self:_SetupNode(sceneRoot);
  self:_SetupOuputCamera();
  return true;
end

function GiftScene:SetClearRT(bClear)
  if bClear == true then
    for i = 1, #self.outputCamera do
      local camCom = self.outputCamera[i];
      local clearFlag = apolloengine.RenderTargetEntity.CF_COLOR_DEPTH_STENCIL;
      camCom:ClearFlag(clearFlag);
    end
  end
end



function GiftScene:Release()
  self:DeActive();
  for i = 1, #self.bluePrints do
    local bluePrint = self.bluePrints[i];
    if bluePrint then
      bluePrint:Destroy();
    end
  end
  
  if self.nativeScene and not venuscore.isNil(self.nativeScene) then
    --apolloengine.SceneManager:DeleteSceneById(self.nativeScene:GetStaticID());
    local sceneID = self.nativeScene:GetStaticID();
    apolloengine.SceneManager:DeleteSceneByID(sceneID);
  end
  self.nativeScene = nil;
  self.scenePath = nil;
  self.outputCamera = {};  --编辑器素材中没有挂RT的相机
  self.allCameraList = {};  --方便给相机设置固定的分辨率
  self.attributeList = nil; --可更改的配置选项
  self.configBehavior = nil; --自定义礼物配置脚本
  self.controlerBehavior = nil; --控制礼物预览与播放切换的脚本
  self.viewportSizeConfig = nil;
  self.avatarConfig = {};
  self.bluePrints = {};
  --默认不显示头像
  self.oldavatarSetting = {avatar_1 = true, avatar_2 = true};
  self.newavatarSetting = {avatar_1 = false, avatar_2 = false};
end


return GiftScene;
