--require "venusdebug"
local asynctexture = require "apolloutility.asynctexture.asynctexture"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local rectnode = require "facecute.facesticker2d.rectnode"
local sticker2drect = require "facecute.facesticker2d.sticker2drect"
local facedefined = require "facecute.facechange.facedefined"
local sticker2ddefine = require "facecute.facesticker2d.sticker2ddefine"
local b3 = require "behavior3"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
local cutebehavior = require "facecute.behavior.cutebehavior"
local behdefined = require "facecute.behavior.behdefined"
local videodecet = require "videodecet"
local bitop = require "bit"
local visConstTexture = nil;
--stickerrect类型
local sticker2drect3 = sticker2drect:extend();
local cnnseg= require "videodecet.cnnseg"


local _ftexupdata = asynctexture.Update;
local _fsetparameter = sticker2drect3.SetParameter;

--由此开始是商汤3.0外部调用接口

function sticker2drect3:Play(delay ,loop,lastingFrame,fadingFrame,donecallback )
  if(self:IsAnimPlaying()) then
    return;
  end
  self:PlayAnimation(delay,loop,lastingFrame,fadingFrame,donecallback);
end

function sticker2drect3:Stop()
  self:SetEnable(false);
  self:StopAnimation();
end

function sticker2drect3:Pause()
  self:StopAnimation();
  --sticker2drect3.super.Pause(self);
  self:setState("paused")
end

function sticker2drect3:PauseInFirstFrame()
  sticker2drect3.super.PauseInFirstFrame(self);
  self:setState("first_frame")
end

function sticker2drect3:PauseInLastFrame()
  sticker2drect3.super.PauseInLastFrame(self);
  self:setState("last_frame")
end

function sticker2drect3:Hide()
  sticker2drect3.super.Hide(self);
  self:Stop();
  self:setState("invisible")
end

function sticker2drect3:TestTrigger()
  if self.triggerFlag then
    self.triggerFlag = false
    return self.cur_state3
  end
  return nil
end

--由此开始是内部逻辑，不要外部调用

function sticker2drect3:setState(state)
  if self.cur_state3 ~= state then
    self.triggerFlag = true
    self.cur_state3 = state
  end
end

function sticker2drect3:new(maincamera)
  self.cur_state3 = "invisible";
  self.triggerFlag = false
  sticker2drect3.super.new(self,maincamera);
  self.texturereader:AutoSkip()
  
  
end

--这个函数是上层在进入的时候根据人头的数量来调用的
--如果是出发类型，就不修改是否显示了，出发类型的显示与否交给节点自己
function sticker2drect3:SetShow(isshow)

  self.IsShow = isshow
  if (self.triggerType==nil or 0 == self.triggerType)
  then
    sticker2drect.super.SetShow(self,isshow );
    self:SetConstTextureForDIFFUSE(isshow);
    if(isshow==false)
    then
      self:ReStart();
    end
  else
     if(isshow==false)
     then
         sticker2drect.super.SetShow(self,false);
         self:SetConstTextureForDIFFUSE(false);
         self:ReStart();
     end
  end
end


function sticker2drect3:GetMaterialPath(blendModeIndex)
  
  local materialPath;
  if self.texturesplit then
    materialPath = sticker2ddefine.materialPathSplit[blendModeIndex];
  else
    materialPath = sticker2ddefine.materialPath3[blendModeIndex];
  end  
  return materialPath;
  
end


function sticker2drect3:GetRenderOrder()
  
  
    --local offset = 0;
   -- if self.positonType == sticker2ddefine.positionType.ForeGround then
      -- offset = -2000;
    --elseif self.positonType == sticker2ddefine.positionType.Background then
    --  offset = -3000;
    --else
      --offset = -2000;
    --end
  local offset = self.renderoffset;
  local zPos = self.zPos+offset;

   return zPos;
end

function sticker2drect3:SetRenderOrder(config)
  local zPos = config["zPosition"];
  self.zPos = zPos;
  
  if self.positonType == sticker2ddefine.positionType.ForeGround then
       self.renderoffset = -2000;
  elseif self.positonType == sticker2ddefine.positionType.Background then
      self.renderoffset = -3000;
  else
      self.renderoffset = -2000;
  end
  
  if(zPos~=nil)
  then
     --local center = mathfunction.vector3(0, 0,-zPos);
     --local bindboxV = mathfunction.Aabbox3d(
      -- center - mathfunction.vector3(1,1,1),
      -- center + mathfunction.vector3(1,1,1));
     --local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,1,0-zPos*10-1000),
     --mathfunction.vector3(1,-1,1-zPos*10-1000));
 
    
    local offset=self.renderoffset;
    --if self.positonType == sticker2ddefine.positionType.ForeGround then
     --  offset = -2000;
    --elseif self.positonType == sticker2ddefine.positionType.Background then
     -- offset = -3000;
    --else
      --offset = -2000;
    --end
    
    
    local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,-1, offset + zPos -1),
    mathfunction.vector3(1,1,offset + zPos));
     self:SetBindBox(bindboxV);
     self:SetCull(false);
  end
end

local function ModelLengthToWorldLength(le)
  local val = 58*le/206.5/1000.0;
  return val;
end

function sticker2drect3:ParseConfig(config,para, compress_root)
  --解析配置表，读取数据，设置初始状态  
  self.bParse =false;
  if(config==nil or para==nil)
  then
      return false;
  end

  if(config["width"]==nil or config["height"]==nil or config["position"]==nil)
  then
      return false;
  end
  if(config["position"]["positionX"]==nil or  config["position"]["positionX"][1]==nil or
  config["position"]["positionX"][1]["x"]==nil or config["position"]["positionX"][1]["y"]==nil or config["position"]["positionX"][1]["index"]==nil)
  then 
    return false;
  end
  
  if(config["positionType"]==nil or config["positionRelationType"]==nil )
  then
    return false;
  end
  
  if(para[1]==nil or para[2]==nil)
  then
    return false;
  end
  
  self.renderoffset =-2000;
  
  if config.original_image_size then--压缩纹理读取原始尺寸
    self.texSize = config.original_image_size;
    self.texSize = mathfunction.vector2(self.texSize[1], self.texSize[2]);
  end

  self.positonType =  config["positionType"];
  self.positionRelationType = config["positionRelationType"];
  if self.positonType ==  0 then
    self.positionRelationType = 0;
  end
  self.blendMode =   config["blendMode"];
  local width  =    config["width"];
  local height =    config["height"];
  local len = table.getn(config["position"]["positionX"]);
  local posOffset = self:GetRectPosOffset(config);
  local scale = self:GetScale(config);
  local targetFPS = config["targetFPS"]
  
  --处理过的配置表的读取
  local imagePath = para[1].."/"..para[2].."/";
  local imageName = nil;
  local digit ,digitstr = self:GetDigit(imagePath,para[2],compress_root);
  if(digit==0)
  then 
    ERROR("sticker 2d: file count failed");
    return false;
  end
  
  if compress_root then
    self.texturesplit = compress_root.compress_split;
    imageName = para[2].."_%0"..digit.."d";
  else
    self.texturesplit = false
    imageName = para[2].."_%0"..digit.."d"; 
  end  

  if self.texturesplit then
    self.settexturefunc = sticker2drect.SetDoubleTexture;
  else
    self.settexturefunc = sticker2drect.SetSingleTexture;
  end

  if targetFPS == nil then
    targetFPS = 30
  end
  
  local confi={{},{},1,imagePath,imageName,targetFPS,false,0};
  --confi[1]={-posOffset[1],posOffset[2],posOffset[1],posOffset[2],-(width-posOffset[1]),-(height-posOffset[2]),width-posOffset[1],-(height-posOffset[2])};
  confi[1]={-posOffset[1],posOffset[2],width-posOffset[1],posOffset[2],-posOffset[1],-(height-posOffset[2]),width-posOffset[1],-(height-posOffset[2])};
  local lenConfi = table.getn(confi[1]);
  self.scale = scale;
  for i=1,lenConfi do
    confi[1][i] = confi[1][i]*scale*sticker2ddefine.stickerScaleMod;
  end
  local pos,posRefAvg,depth =self:GetRectPosDepRef(config);
  confi[2][1]=-pos[1];
  confi[2][2]=pos[2];
  confi[2][3]= depth;
  self:SetLocalPosition(mathfunction.vector3(ModelLengthToWorldLength(confi[2][1]),ModelLengthToWorldLength(confi[2][2]),confi[2][3]));
  local rectPos = confi[1];
  
  self:SetTrigger(config);
  
  if(self:IsHandPosture( self.positonType) and  self.positonType==self.triggerType )
  then
    self.rectPosOrg={};
    for i=1,#confi[1] do
      self.rectPosOrg[i]=confi[1][i];
    end
  end
  self:SetRenderInitalData(width,height,posOffset,posRefAvg,scale,rectPos);
  --init texturereader
  local res = self:InitTextureReader(confi, compress_root);
  --set render order
  self:SetRenderOrder(config);

  self.bParse =true;
  self.curFrame = 0;
  self.stateType = behdefined.stateType.NULL;
  self.version = para[3];
  
  self:SetBgConstAlphaTexture();
  self:SetVisConstAlphaTexture();

  self:RegisterSegNeedFunc();
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_POSOFFSET, mathfunction.vector2(0,0));

  self.animloop = 0;
  self.animdelay = 0;
  self.animlast = 0;
  self.animfade = 0;
  self.animTime = -1.0;

  self.IsShow = false;
  
  

  return res;
end





function sticker2drect3:SetTrigger(config)
  self.triggerType = config["triggerType"];
  self.triggerLoop = config["triggerLoop"];
  self.triggerDelay = config["triggerDelay"];
  self.triggerStop = config["triggerStop"];
  self.updatefunction = sticker2drect3.UpdateParamCallBack;
end

function sticker2drect3:IsAnimPlaying()
  if self.animTime>=0.0 then
    return true;
  else
    return false;
  end
end

function sticker2drect3:PlayAnimation(delay ,loop,lastingFrame,fadingFrame,autohide )
  self.animloop = loop;
  self.animdelay = delay;
  self.animlast = lastingFrame;
  self.animfade = fadingFrame;
  self.animTime = 0.0;
  if autohide~=nil and autohide==true then
    self.onanimdone = sticker2drect3.OnAnimDone;
  elseif autohide~=nil then
    self.onanimdone = autohide;
  end
  self:AnimUpdate(0);
  self:UpdateParam(self.timespan,self.face,self.position,self.rotation,self.action);
end

function sticker2drect3:StopAnimation()
  self.animloop = 0;
  self.animdelay = 0;
  self.animlast = 0;
  self.animfade = 0;
  self.animTime = -1;
  self.onanimdone = nil;
  self:AnimUpdate(0);
  self:UpdateParam(self.timespan,self.face,self.position,self.rotation,self.action);
end

function sticker2drect3:OnAnimDone()
  self:SetEnable(false);
end

function sticker2drect3:AnimUpdate(timespan)
  if self.animTime == -1.0 then
      return;
  end
  if self.animTime == 0.0 then
    self.texturereader:ResetLoopCount();
  end 
  self.animTime = self.animTime + timespan;

  --delay时间已过
  if self.animTime>=self.animdelay/self.texturereader.fps then
    self:SetEnable(true);
    self:SetFade(1);
    --处于fade时间段内
    if (self.animTime - self.animdelay / self.texturereader.fps) < self.animfade / self.texturereader.fps then
      local len = self.animfade;
      local per = self.animTime * self.texturereader.fps - self.animdelay;
      self:SetFade(per/len);
    end
    local pic = self.settexturefunc(self, timespan);
    --全部loop完成
    if self.animloop > 0 and self.texturereader:GetLoopCount() >= self.animloop then
      self.animTime = -1;
      if self.onanimdone~=nil then
        self.onanimdone(self);
      end
    end
  end
end


function sticker2drect3:UpdateParam(timespan,face,position,rotation,action,pic)
  if(self:IsNeedBackGroundSplit())
  then
      local cnnsegTex = cnnseg:GetSegTexture();
      cnnsegTex = cnnsegTex and cnnsegTex or self.bgConstAlphaTex;
      _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_BGALPHA, cnnsegTex); 
  else
    _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_BGALPHA, self.bgConstAlphaTex); 
  end
  
  self:processViewChange();
  local callbacks=self.proCallbacks;
  if(self:IsHandPosture( self.positonType) and  self.positonType==self.triggerType  ) 
  then
    callbacks[sticker2ddefine.positionType.Hand](self,timespan,face,position, rotation,nil,pic);
  else
    local callback = callbacks[self.positonType];
    if(callback~=nil)
    then
      callback(self,timespan,face,position, rotation,nil,pic);
    end
  end
end

function sticker2drect3:UpdateParamCallBack()
    local timespan,face,position,rotation,action;
    timespan =  self.timespan;
    face  = self.face;
    position =  self.position;
    rotation =  self.rotation;
    action   = self.action;
   -- self.rgbtexture,pic = self.texturereader:Update(timespan);
    self:UpdateParam(timespan,face,position,rotation,action);
end

function sticker2drect3:SetEnable(enable)
  self.IsShow = enable;
  sticker2drect.super.SetShow(self,self.IsShow);
  self:SetConstTextureForDIFFUSE( self.IsShow);
  if enable then
    self:setState("playing")
  else
    self:setState("invisible")
  end
  
end

function sticker2drect3:SetFade(enable)
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_FADE, mathfunction.vector1(enable));
end



function sticker2drect3:Update(timespan,face,position,rotation,action)
   if(self.bParse==false)
   then
     return;
   end
   self.curFrame = self.curFrame+1;
   self.events= self.events;
   self.timespan = timespan;
   self.face = face;
   self.position = position;
   self.rotation = rotation;
   self.action = action;
   self.actionRecord = action;

  -- print("gogogogogoggo");
   self:AnimUpdate(timespan);
   self:updatefunction(self);
end



return sticker2drect3;