local behdefined = require "facecute.behavior.behdefined"

local triggerfilter={}

function triggerfilter:Initialize()
end

function triggerfilter:onTrigger(obj)
  self:ProcessAction(obj);
  if(obj.triggerType==nil or obj.triggerType==behdefined.triggerType.NULL)
  then
    obj.stateType = behdefined.stateType.Playing;
    return true;
  else
  end
  local action = obj.action;
  local len =0;
  
  
  if(obj.triggerStop==true)
  then
    len = table.getn(obj.disAction);
    local objdisAction = obj.disAction;
    for i=1,len do
       local actionId = objdisAction[i]:GetActionID();
       if(actionId==obj.triggerType)
       then
          obj.stateType = behdefined.stateType.NULL;
          obj.stateChange = true;
          obj.disAction = {};
          obj.lastAction = {};
          obj.action  ={};
          return true;
        end
    end
  end
  
  
  if(action~=nil)
  then
    len =table.getn(action);
  end
  for i=1,len do
     local actionId = action[i]:GetActionID();
     if(actionId==obj.triggerType)
     then
        obj.stateType = behdefined.stateType.Playing;
        obj.lastActionId = actionId;
        obj.stateChange = true;
       return true;
      end
  end
  

  
  return true;
end

function triggerfilter:IsActionIn(actionId,action)
  
  local len = table.getn(action);
  for i=1,len do
     local id = action[i]:GetActionID();
     if(actionId==id)
     then
           return true;
      end
  end
  return false;
end

function triggerfilter:ProcessAction(obj)
  local action = obj.action;
  if(obj.lastAction==nil)
  then
    obj.lastAction = action;
    obj.disAction ={};
    return;
  end
  
  local proAction={};
  local disAction={};
  local len = table.getn(action);
  --LOG("len")
  --LOG(len)
  --LOG("--------------")
  --action appeard
  for i=1,len do
      local id = action[i]:GetActionID();
      if(not self:IsActionIn(id,obj.lastAction))
      then
        table.insert(proAction,action[i]);
      end
  end
  
  --action disappeared
  local objlastAction = obj.lastAction;
  len =  table.getn(objlastAction);
  for i=1,len do
      local id = objlastAction[i]:GetActionID();
      if(not self:IsActionIn(id,action))
      then
        table.insert(disAction,objlastAction[i]);
      end
  end
  obj.disAction = disAction;
  obj.lastAction = action;
  obj.action = proAction;
end
return triggerfilter;