local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BackgroundBehavior = venuscore.VenusBehavior:extend("BackgroundBehavior");
local BgPartBehaviorTypeName = "BGPartBehavior"
BackgroundBehavior.diff = 0.001;

function BackgroundBehavior:new()
  self.left = nil;
  self.right = nil;
  self.top = nil;
  self.bottom = nil;
  self.leftTop = nil;
  self.rightTop = nil;
  self.leftBottom = nil;
  self.rightBottom = nil;
  self.center = nil;
  self.minSize = mathfunction.vector2(0,0);
  self.sdfComponent = nil;
  self.lastSize = mathfunction.vector2(0,0);
  self.rootNode = nil;
  self.uv = mathfunction.vector2(0,0);
  self.leftRect = mathfunction.vector2(0,0);
  self.rightRect = mathfunction.vector2(0,0);
  self.topRect = mathfunction.vector2(0,0);
  self.bottomRect = mathfunction.vector2(0,0);
  self.leftTopRect = mathfunction.vector2(0,0);
  self.rightTopRect = mathfunction.vector2(0,0);
  self.leftBottomRect = mathfunction.vector2(0,0);
  self.rightBottomRect = mathfunction.vector2(0,0);
  self.lastLeftRect = mathfunction.vector2(0,0);
  self.lastRightRect = mathfunction.vector2(0,0);
  self.lastTopRect = mathfunction.vector2(0,0);
  self.lastBottomRect = mathfunction.vector2(0,0);
  self.lastLeftTopRect = mathfunction.vector2(0,0);
  self.lastRightTopRect = mathfunction.vector2(0,0);
  self.lastLeftBottomRect = mathfunction.vector2(0,0);
  self.lastRightBottomRect = mathfunction.vector2(0,0);
end

function BackgroundBehavior:_OnAwake()
  self.trans = self.Node:GetComponent(apolloengine.Node.CT_TRANSFORM)
  local children = self.Node:GetChildrens();
  for k,v in pairs(children) do
    if v:GetName() == "left" then
      self.left = v;
    elseif v:GetName() == "right" then
      self.right = v;
    elseif v:GetName() == "top" then
      self.top = v;
    elseif v:GetName() == "bottom" then
      self.bottom = v;
    elseif v:GetName() == "leftTop" then
      self.leftTop = v;
    elseif v:GetName() == "rightTop" then
      self.rightTop = v;
    elseif v:GetName() == "leftBottom" then
      self.leftBottom = v;
    elseif v:GetName() == "rightBottom" then
      self.rightBottom = v;
    elseif v:GetName() == "center" then
      self.center = v;
    end
  end

  self.center_bgpart = self:GetPartBehavior(self.center)
  self.left_bgpart = self:GetPartBehavior(self.left)
  self.right_bgpart = self:GetPartBehavior(self.right)
  self.top_bgpart = self:GetPartBehavior(self.top)
  self.bottom_bgpart = self:GetPartBehavior(self.bottom)
  self.left_top_bgpart = self:GetPartBehavior(self.leftTop)
  self.right_top_bgpart = self:GetPartBehavior(self.rightTop)
  self.left_bottom_bgpart = self:GetPartBehavior(self.leftBottom)
  self.right_bottom_bgpart = self:GetPartBehavior(self.rightBottom)

  self.center_bgpart:SetScaleMode(self.center_bgpart.ScaleMode.Center);
  self.left_bgpart:SetScaleMode(self.center_bgpart.ScaleMode.VerticalSide);
  self.right_bgpart:SetScaleMode(self.center_bgpart.ScaleMode.VerticalSide);
  self.top_bgpart:SetScaleMode(self.center_bgpart.ScaleMode.HorizontalSide);
  self.bottom_bgpart:SetScaleMode(self.center_bgpart.ScaleMode.HorizontalSide);
  self.left_top_bgpart:ChangeSize(self.leftTopRect);
  self.right_top_bgpart:ChangeSize(self.rightTopRect);
  self.left_bottom_bgpart:ChangeSize(self.leftBottomRect);
  self.right_bottom_bgpart:ChangeSize(self.rightBottomRect);
  self.rootNode = self.Node:GetRoot();
  self.sdfComponent = self.rootNode:GetComponent(apolloengine.Node.CT_SDF_COM);
end

function BackgroundBehavior:GetPartBehavior(node)
  if node then
    local scriptCom = node:GetComponent(apolloengine.Node.CT_SCRIPT);
    if scriptCom then
      local Instances = scriptCom.Instances;
      for k,v in pairs(Instances) do
        if v:GetTypeName() == BgPartBehaviorTypeName then
          return v;
        end
      end
    end
  end
  return nil;
end

function BackgroundBehavior:_OnStart()
  --编辑器下直接添加的背景需要在start中去找父节点
  self.rootNode = self.Node:GetRoot();
  self.sdfComponent = self.rootNode:GetComponent(apolloengine.Node.CT_SDF_COM);
end

function BackgroundBehavior:_OnUpdate(def)
  if self.sdfComponent == nil then
    return;
  end
  self.uv = self.sdfComponent:GetUnfixedRect();

  if self.uv ~= self.lastSize then
    self:UpdateBackground(self.uv);
    self.lastSize:Set(self.uv:x(), self.uv:y());
  end

  if _KRATOSEDITOR then
    local centerPos = self.trans:GetLocalPosition();
    local width = self.uv:x();
    local height = self.uv:y();
    if self.leftRect ~= self.lastLeftRect then
      local left_width = self.leftRect:x();
      self.left_bgpart:ChangeSize(mathfunction.vector2(left_width, height));
      self.left_bgpart:SetLocalPosition(centerPos + mathfunction.vector3(-0.01 * (width + left_width) * 0.5, 0, 0));
      self.lastLeftRect:Set(self.leftRect:x(),self.leftRect:y());
    end

    if self.rightRect ~= self.lastRightRect then
      local right_width = self.rightRect:x();
      self.right_bgpart:ChangeSize(mathfunction.vector2(right_width, height));
      self.right_bgpart:SetLocalPosition(centerPos + mathfunction.vector3(0.01 * (width + right_width) * 0.5, 0, 0));
      self.lastRightRect:Set(self.rightRect:x(),self.rightRect:y());
    end

    if self.topRect ~= self.lastTopRect then
      local top_height = self.topRect:y();
      self.top_bgpart:ChangeSize(mathfunction.vector2(width, top_height));
      self.top_bgpart:SetLocalPosition(centerPos + mathfunction.vector3(0, 0.01 * (height + top_height) * 0.5, 0));
      self.lastTopRect:Set(self.topRect:x(),self.topRect:y());
    end

    if self.bottomRect ~= self.lastBottomRect then
      local bottom_height = self.bottomRect:y();
      self.bottom_bgpart:ChangeSize(mathfunction.vector2(width, bottom_height));
      self.bottom_bgpart:SetLocalPosition(centerPos + mathfunction.vector3(0, -0.01 * (height + bottom_height) * 0.5, 0));
      self.lastBottomRect:Set(self.bottomRect:x(),self.bottomRect:y());
    end

    if self.leftTopRect ~= self.lastLeftTopRect then
      local leftTop_Width = self.leftTopRect:x();
      local leftTop_Height = self.leftTopRect:y();
      self.left_top_bgpart:ChangeSize(self.leftTopRect);
      self.left_top_bgpart:SetLocalPosition(centerPos
              + mathfunction.vector3(
              -0.01 * (width + leftTop_Width) * 0.5,
              0.01 * (height + leftTop_Height) * 0.5,
              0
      )
      );
      self.lastLeftTopRect:Set(self.leftTopRect:x(),self.leftTopRect:y());
    end

    if self.rightTopRect ~= self.lastRightTopRect then
      local rightTop_Width = self.rightTopRect:x();
      local rightTop_Height = self.rightTopRect:y();
      self.right_top_bgpart:ChangeSize(self.rightTopRect);
      self.right_top_bgpart:SetLocalPosition(centerPos
              + mathfunction.vector3(
              0.01 * (width + rightTop_Width) * 0.5,
              0.01 * (height + rightTop_Height) * 0.5,
              0
      )
      );
      self.lastRightTopRect:Set(self.rightTopRect:x(),self.rightTopRect:y());
    end

    if self.rightBottomRect ~= self.lastRightBottomRect then
      local rightBottom_Width = self.rightBottomRect:x();
      local rightBottom_Height = self.rightBottomRect:y();
      self.right_bottom_bgpart:ChangeSize(self.rightBottomRect);
      self.right_bottom_bgpart:SetLocalPosition(centerPos
              + mathfunction.vector3(
              0.01 * (width + rightBottom_Width) * 0.5,
              -0.01 * (height + rightBottom_Height) * 0.5,
              0
      )
      );
      self.lastRightBottomRect:Set(self.rightBottomRect:x(),self.rightBottomRect:y());
    end

    if self.leftBottomRect ~= self.lastLeftBottomRect then
      local leftBottom_Width = self.leftBottomRect:x();
      local leftBottom_Height = self.leftBottomRect:y();
      self.left_bottom_bgpart:ChangeSize(self.leftBottomRect);
      self.left_bottom_bgpart:SetLocalPosition(centerPos
              + mathfunction.vector3(
              -0.01 * (width + leftBottom_Width) * 0.5,
              -0.01 * (height + leftBottom_Height) * 0.5,
              0
      )
      );
      self.lastLeftBottomRect:Set(self.leftBottomRect:x(),self.leftBottomRect:y());
    end
  end
end

function BackgroundBehavior:UpdateBackground(size)
  local centerPos = self.trans:GetLocalPosition();
  local width = size:x();
  local height = size:y();
  if width < self.minSize:x() then
    width = self.minSize:x();
  end
  if height < self.minSize:y() then
    height = self.minSize:y();
  end
  --center
  self.center_bgpart:ChangeSize(mathfunction.vector2(width, height));
  --left
  local left_width = self.leftRect:x();
  self.left_bgpart:ChangeSize(mathfunction.vector2(left_width, height));
  self.left_bgpart:SetLocalPosition(centerPos + mathfunction.vector3(-0.01 * (width + left_width) * 0.5, 0, 0));
  --right
  local right_width = self.rightRect:x();
  self.right_bgpart:ChangeSize(mathfunction.vector2(right_width, height));
  self.right_bgpart:SetLocalPosition(centerPos + mathfunction.vector3(0.01 * (width + right_width) * 0.5, 0, 0));
  --top
  local top_height = self.topRect:y();
  self.top_bgpart:ChangeSize(mathfunction.vector2(width, top_height));
  self.top_bgpart:SetLocalPosition(centerPos + mathfunction.vector3(0, 0.01 * (height + top_height) * 0.5, 0));
  --bottom
  local bottom_height = self.bottomRect:y();
  self.bottom_bgpart:ChangeSize(mathfunction.vector2(width, bottom_height));
  self.bottom_bgpart:SetLocalPosition(centerPos + mathfunction.vector3(0, -0.01 * (height + bottom_height) * 0.5, 0));
  --leftTop
  local leftTop_Width = self.leftTopRect:x();
  local leftTop_Height = self.leftTopRect:y();
  self.left_top_bgpart:SetLocalPosition(centerPos
          + mathfunction.vector3(
            -0.01 * (width + leftTop_Width) * 0.5,
            0.01 * (height + leftTop_Height) * 0.5,
            0
          )
  );
  --rightTop
  local rightTop_Width = self.rightTopRect:x();
  local rightTop_Height = self.rightTopRect:y();
  self.right_top_bgpart:SetLocalPosition(centerPos
          + mathfunction.vector3(
            0.01 * (width + rightTop_Width) * 0.5,
            0.01 * (height + rightTop_Height) * 0.5,
            0
          )
  );
  --rightBottom
  local rightBottom_Width = self.rightBottomRect:x();
  local rightBottom_Height = self.rightBottomRect:y();
  self.right_bottom_bgpart:SetLocalPosition(centerPos
          + mathfunction.vector3(
            0.01 * (width + rightBottom_Width) * 0.5,
            -0.01 * (height + rightBottom_Height) * 0.5,
            0
          )
  );
  --leftBottom
  local leftBottom_Width = self.leftBottomRect:x();
  local leftBottom_Height = self.leftBottomRect:y();
  self.left_bottom_bgpart:SetLocalPosition(centerPos
          + mathfunction.vector3(
          -0.01 * (width + leftBottom_Width) * 0.5,
          -0.01 * (height + leftBottom_Height) * 0.5,
          0)
  );
end

function BackgroundBehavior:GetMaxRect()
  local centerRect = self.sdfComponent:GetUnfixedRect();
  local width = centerRect:x();
  local height = centerRect:y();
  if width < self.minSize:x() then
    width = self.minSize:x();
  end
  if height < self.minSize:y() then
    height = self.minSize:y();
  end
  local finalWidth = width + math.max(self.leftRect:x(), self.leftTopRect:x(), self.leftBottomRect:x())
          + math.max(self.rightRect:x(), self.rightTopRect:x(), self.rightBottomRect:x());
  local finalHeight = height + math.max(self.bottomRect:y(), self.rightBottomRect:y(), self.leftBottomRect:y())
          + math.max(self.topRect:y(), self.rightTopRect:y(), self.leftTopRect:y());
  return mathfunction.vector2(finalWidth, finalHeight);
end

--BackgroundBehavior:MemberRegister("uv");
BackgroundBehavior:MemberRegister("minSize");
BackgroundBehavior:MemberRegister("leftRect");
BackgroundBehavior:MemberRegister("rightRect");
BackgroundBehavior:MemberRegister("topRect");
BackgroundBehavior:MemberRegister("bottomRect");
BackgroundBehavior:MemberRegister("leftTopRect");
BackgroundBehavior:MemberRegister("rightTopRect");
BackgroundBehavior:MemberRegister("leftBottomRect");
BackgroundBehavior:MemberRegister("rightBottomRect");


return BackgroundBehavior;