local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local makeup_common = require "behavior.makeup.makeup_common"
local cv = require "computervisionfunction"

local makeup_base = venuscore.VenusBehavior:extend("makeup_base");

function makeup_base:new()
  self.hasInit = false;
  self.render = nil
  self.recognition = nil
  self.MakeupType = makeup_common.NONE
  self.FaceID = 1
  self.vertexStream = nil
  self.vertexNumber = 0
  self.errorThreshold = 0.9
  self.faceMeshType = nil
end

function makeup_base:_OnAwake(def)
  self:BInitialParameters();
end

function makeup_base:_OnLateUpdate(def)
  if self.hasInit then
    self:BUpdateFaceData()
    self:IUpdateParameters()
    cv.RecognitionUtility:UpdateMakeupVertex(self.recognition, self.render, self.faceMeshType, self:BGetFaceID())
  else
    self:BInitialParameters();
  end
end 

function makeup_base:_OnDestroy()
  self:IDestroy(); --删除Script时需要删除动态创建的Node
end


--Base class methods that can be overwrite, beginning with "I,"I" was "implementation"
function makeup_base:IInitialParameters()
  --return bool type flag
  --type:return true or return false
  return true
end

function makeup_base:IUpdateParameters()
  return true
end

function makeup_base:IDestroy()
  return true
end

--Base class methods begin with "B",not overwrite,"B" was "Basic"
function makeup_base:BGetMakeupType()
    return self.MakeupType;
end

function makeup_base:BSetMakeupType(value)
    self.MakeupType = value
    -- 重置makeup
    self:BInitialParameters();
end

function makeup_base:BGetRecongnition()
  self.recognition = self.Node:GetComponent(apolloengine.Node.CT_CV_RECOGNITION);
  if nil == self.recognition then
    ERROR("[makeup_base]"..makeup_common.makeup_types[self:BGetMakeupType()].key..": We Have No Recognition Component!")
    return nil
  end
  return self.recognition
end

function makeup_base:BGetFaceID()
  return self.FaceID
end

function makeup_base:BSetFaceID(value)
  self.FaceID = value;
end

function makeup_base:BGetRender()
  if nil == self.render and nil~=self.Node then
      self.render = self.Node:GetComponent(apolloengine.Node.CT_RENDER);
      if nil == self.render then
          ERROR("[makeup_base]"..makeup_common.makeup_types[self:BGetMakeupType()].key..": We Have No Render Component!")
          return nil
      end
  end
  return  self.render
end

function makeup_base:BInitialParameters()
  local result = self:IInitialParameters();
  self.hasInit = true;
  self.render = self:BGetRender()
  if self.render then 
    local makeup_type_value = self:BGetMakeupType()
    local materialEntity = self.render.MaterialEntities[1]
    if makeup_type_value >= 2 and materialEntity then
      local mask_position = makeup_common.makeup_uv_offset[makeup_type_value - 1][1]
      local mask_size = makeup_common.makeup_uv_offset[makeup_type_value - 1][2]
      materialEntity:SetParameter("_MaskInfo",mathfunction.vector4(
        mask_position[1],mask_position[2],mask_size[1],mask_size[2]))
      -- materialEntity:SetParameter("_Polygon",mathfunction.vector1(2.0));
    end
  end
  return result;
end


function SqrDistance(pt1, pt2)
  return (pt1[1]-pt2[1])*(pt1[1]-pt2[1]) + (pt1[2]-pt2[2])*(pt1[2]-pt2[2]);
end

function makeup_base:BUpdateFaceData()
  if not self.faceMeshType then
    self.render = self:BGetRender()
    self.recognition = self:BGetRecongnition()
    local makeup_type = self:BGetMakeupType()
    if nil == self.recognition or makeup_type == makeup_common.NONE then
      return nil 
    end
    --根据cv的类型选择读取不同类型的cv数据
    local bvt_facemesh_type = makeup_common.makeup_uv_offset[makeup_type - 1][3]
    self.faceMeshType = bvt_facemesh_type[1]
  end
    -- 检测模型两点间的最大距离，如果检测到过大，则报错
    --[[if self.render then
      self.indexStream = self.render:GetIndexStream()
      if self.indexStream ~= nil then
        local indexCount = self.indexStream:GetIndicesCount();
        local indexArray = self.indexStream:GetIndicesData();
        local longestDis = 0.0;
        local ptidx1 = 0
        local ptidx2 = 0
        for i = 1,indexCount,3 do
          local idx1,idx2,idx3 = indexArray[i]+1,indexArray[i+1]+1,indexArray[i+2]+1;
          local tmpdis = SqrDistance(finalfaceData[idx1], finalfaceData[idx2]);
          if longestDis < tmpdis then
            longestDis = tmpdis;
            ptidx1, ptidx2 = idx1,idx2;
          end
          tmpdis = SqrDistance(finalfaceData[idx1], finalfaceData[idx3]);
          if longestDis < tmpdis then
            longestDis = tmpdis;
            ptidx1, ptidx2 = idx1,idx3;
          end
          tmpdis = SqrDistance(finalfaceData[idx2], finalfaceData[idx3]);
          if longestDis < tmpdis then
            longestDis = tmpdis;
            ptidx1, ptidx2 = idx2,idx3;
          end
        end

        if longestDis > self.errorThreshold then
          ERROR("[makeup_base]: Invalid bvt "..tostring(makeup_common.makeup_types[self:BGetMakeupType()].key)
          .." data. Detect size= "..tostring(videoFrame:x()).." "..tostring(videoFrame:y())
          ..". Largest sqr distance: "..tostring(longestDis)
          ..". pt1 = "..tostring(finalfaceData[ptidx1][1]).." "..tostring(finalfaceData[ptidx1][2])
          ..". pt2 = "..tostring(finalfaceData[ptidx2][1]).." "..tostring(finalfaceData[ptidx2][2])
        );
        end
      end
    end ]]
end


makeup_base:MemberRegister("MakeupType", 
    venuscore.ScriptTypes.ComboType(
        makeup_common.makeup_types,    
        makeup_base.BGetMakeupType,
        makeup_base.BSetMakeupType));


makeup_base:MemberRegister("FaceID", 
    venuscore.ScriptTypes.ComboType(
        makeup_common.faceId,    
        makeup_base.BGetFaceID,
        makeup_base.BSetFaceID));

return makeup_base;
