
local Object       = require "classic"
local apolloengine  = require "apolloengine"
local apollocore = require "apollocore"
local apolloDefine = require "apolloutility.defiend"
local rendernode    = require "apolloutility.apollonode.rendernode"
local mathfunction  = require "mathfunction"
local cv            = require "computervisionfunction"
local venuscore     = require "venuscore"
local defined       = require "apolloutility.defiend"
local apollonode   = require "apolloutility.apollonode"
local DeviceResource = require "apolloengine.deviceresource"
local ContourFeatherRender = require "contour_mask.feather_render"
--[[
    Render Blings as billboards on background frame.
    Usage:
    1. Create a BlingEffect object, make sure patch_creator_render_sequence is less than that of the main camera.
    2. call Update() in rendering Update()
]]

local ContourBehavior = venuscore.VenusBehavior:extend("ContourBehavior");
local ContourBehavior1 = venuscore.VenusBehavior:extend("ContourBehavior1");

function ContourBehavior:new()
  self.color_num = 1;
  self.density = 20;
  self.dilate = 2;
  self.dilatePoint = 0;
  self.time = 0;
  self.enableInContour = true;
  self.enableRandomColor = false;
  self.enableFixDirection = false;
  self.ContourMaskType = 1.0;
  self.isActive = false;
  self.Overlay_mode = 1.0;
  self.Texture_mode = 1.0;
  self.Material_mode = 1.0;
  self.Blend_opacity = 1.0;
  self.lightRange = 0;
  self.GlowIntense = 0;
  self.featherRange = 0;
  self.lineContrast = 0.0;
  self.glowContrast = 0.0;
  self.textureX = 1.0;
  self.step = 0;
  
  self.BlendColor = mathfunction.Color(1,0,0,0);
  self.LightColor = mathfunction.Color(1,0,0,0);


  self.frameX = 0;
  self.frameY = 0;
  self.Texture_contour_path = "comm:documents/texture/material/blank.jpg";
  self.Texture_path = "comm:documents/texture/material/blank.jpg";
  self.Texture_paths = {"comm:documents/texture/material/blank.jpg"};
  self.Pre_texture_paths = {"comm:documents/texture/material/blank.jpg"};
  self.NumColms ={1}
  self.NumRows = {1};
  self.FPS = {30};

  self.color_texs = {self:LoadTexture(self.Texture_path)};
  self.maxRenderNum = 0;
  self.renderNodes = {};
  self.contourNode = nil;
  self.contourRender = nil;
  self.is_show = true;
  self.contour_texture_change = false;
  --self.contourRender = self.Node:GetComponent(apolloengine.Node.CT_RENDER);

  self.node_uuid = nil; 
  self.render_uuid = nil;
  self.node_name = nil;
  self.initialized = false;
end

--第一次Update的时候会调用Start
function ContourBehavior:OnStart(node)
  if self.initialized then
    return;
  end
  self:Initialize(node);
end

function ContourBehavior:_OnAwake(def)
  
end

function ContourBehavior:OnCreateRender(node, id)
    self.Node = node;
    local scene = node:GetHostScene();
    local renderNode = scene:CreateNode(apolloengine.Node.CT_NODE);
    local render = renderNode:CreateComponent(apolloengine.Node.CT_RENDER);
    if _KRATOSEDITOR then
      renderNode.EditorUIType = apollocore.IContent.UNVISUAL;
    end
    local rootnode = renderNode:GetRoot();
    rootnode:DetachNode(renderNode);
    node:AttachNode(renderNode);

    render:PushMetadata(
      apollocore.RenderObjectMeshFileMetadate(
        apollocore.VertexBufferEntity.MU_DYNAMIC, 
        "comm:documents/mesh/default.dynamicmesh")
    );

    render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
    apolloengine.PathMetadata("comm:documents/contour_line/contour_sticker.material")));
    render:CreateResource();

    self.vertexstream = apolloengine.VertexStream();--创建顶点流
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
    self.vertexstream:ReserveBuffer(8);
    self.indexstream = apolloengine.IndicesStream(); 
    self.indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
    self.indexstream:ReserveBuffer(6);
    self.indexstream:PushIndicesData(0);
    self.indexstream:PushIndicesData(1);
    self.indexstream:PushIndicesData(2);
    self.indexstream:PushIndicesData(2);
    self.indexstream:PushIndicesData(1);
    self.indexstream:PushIndicesData(3);
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(-1, 1, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(-1, -1, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(1, 1, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(1, -1, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 1));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 1));
    render:ChangeIndexBuffer(self.indexstream);
    render:ChangeVertexBuffer(self.vertexstream);

    render:EraseRenderProperty(apolloengine.RenderComponent.RP_CULL);
    render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);

    self.contourNode = renderNode;
    self.contourRender = render;

    if self.node_name ~= nil then
      self.contourNode:SetName(self.node_name);
    else
      self.contourNode:SetName("contour"..tostring(id));
    end
end

function ContourBehavior:OnAwake(node)
    self.Node = node;
    local scene = self.Node:GetHostScene();
    self.contourNode = scene:GetNode(self.node_uuid);
    self.contourRender = self.contourNode:GetComponent(apolloengine.Node.CT_RENDER);
    
    self.vertexstream = apolloengine.VertexStream();--创建顶点流
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
    self.vertexstream:ReserveBuffer(8);
    self.indexstream = apolloengine.IndicesStream(); 
    self.indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
    self.indexstream:ReserveBuffer(6);
    self.indexstream:PushIndicesData(0);
    self.indexstream:PushIndicesData(1);
    self.indexstream:PushIndicesData(2);
    self.indexstream:PushIndicesData(2);
    self.indexstream:PushIndicesData(1);
    self.indexstream:PushIndicesData(3);
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(-1, 1, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(-1, -1, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(1, 1, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(1, -1, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 1));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 1));

    self.contourRender:ChangeIndexBuffer(self.indexstream);
    self.contourRender:ChangeVertexBuffer(self.vertexstream);
end

function ContourBehavior:Initialize(node)
  if not self.initialized then
    if self.node_uuid == nil or self.render_uuid == nil then
      return
    end

    self.Node = node;
    local scene = self.Node:GetHostScene();--apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);--nil;--self.Node:GetHostScene();
    --self.color_tex = self:LoadTexture(self.Texture_path);
    self.seg = self.Node:GetComponent(apolloengine.Node.CT_CV_SEGMENT);
    self.id = self.seg:InitContour();
    
    self.contourNode = scene:GetNode(self.node_uuid);
    self.contourRender = self.contourNode:GetComponent(apolloengine.Node.CT_RENDER);
    
    self.CameraInput = apolloengine.TextureEntity();
    self.CameraInput:PushMetadata(apolloengine.TextureReferenceMetadata(defined.LAST_QUEUE_TEXTURE));
    self.CameraInput:CreateResource();

    self.cameraWidth = self.CameraInput:GetSize():x();
    self.cameraHeight = self.CameraInput:GetSize():y();

    self.contour_feather_render = ContourFeatherRender(scene, -600, "contour_feather_layer", "comm:documents/contour_line/alpha_mask.material", self.cameraWidth, self.cameraHeight);
    self.contour_feather_render:SetShow(false);
    self.contour_feather_tex = nil;
    self.texture_contour_tex = self:LoadTexture(self.Texture_contour_path);
    self.contourRender:SetParameter("TEXTURE_DIFFUSE", self.texture_contour_tex);
    self.initialized = true;
  end
end

function ContourBehavior:LoadTexture(texture_path)
  local texture = apolloengine.TextureEntity();
  texture:PushMetadata(apolloengine.TextureFileMetadata(
                                 apolloengine.TextureEntity.TU_STATIC,
                                 apolloengine.TextureEntity.PF_AUTO,
                                 1, false,
                                 apolloengine.TextureEntity.TW_REPEAT,
                                 apolloengine.TextureEntity.TW_REPEAT,
                                 apolloengine.TextureEntity.TF_LINEAR,
                                 apolloengine.TextureEntity.TF_LINEAR,
                                 venuscore.IFileSystem:PathAssembly(texture_path)));
  texture:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  texture:CreateResource();
  return texture;
end

function ContourBehavior:OnDestroy()
  for _, node in ipairs(self.renderNodes) do
    self.Node:DetachNode(node.node);
    node:Destroy();
    node = nil;
  end

  local scene = self.Node:GetHostScene();
  if  self.contourNode ~= nil then
    self.Node:DetachNode(self.contourNode);
    scene:DeleteNode(self.contourNode);
    self.contourNode = nil;
    self.contourRender = nil;
  end


  if self.contour_feather_render ~= nil then
    self.contour_feather_render:Clear()
    self.contour_feather_render = nil;
  end

  self.renderNodes = {}
  self.initialized = false;
end


function ContourBehavior:OnUpdate(node, mask_layer, render_order, def)
    self:Initialize(node);
    
    --if self.Texture_mode == 2 then 
    if def > 0.1 then
      self.time = self.time + 0.1;
    else
      self.time = self.time + def;
    end
    --end

    if #self.Pre_texture_paths ~= #self.Texture_paths then
      for i=1, #self.color_texs do
        self.color_texs[i] = nil;
      end
      self.color_texs = {};
      self.Pre_texture_paths = {};
      for i=1, #self.Texture_paths do
        table.insert(self.color_texs, self:LoadTexture(self.Texture_paths[i]));
        table.insert(self.Pre_texture_paths, self.Texture_paths[i]);
      end
    else
      for i=1, #self.Texture_paths do
        if self.Texture_paths[i] ~= self.Pre_texture_paths[i] then
          self.color_texs[i] = self:LoadTexture(self.Texture_paths[i]);
          self.Pre_texture_paths[i] = self.Texture_paths[i];
        end
      end
    end
    self.color_num = #self.Texture_paths;

    self.seg = self.Node:GetComponent(apolloengine.Node.CT_CV_SEGMENT);
    self.seg.ColorNum = self.color_num;
    self.seg.Density = self.density + 5;
    self.seg.DilateFactor = self.dilatePoint;
    self.seg.EnableInContour = self.enableInContour;
    self.seg.EnableRandomColor = self.enableRandomColor;

    for i=1, self.maxRenderNum do
      self.renderNodes[i]:SetShow(false);
      self.renderNodes[i]:SetLayer(mask_layer);
    end

    -- self.contourNode:SetShow(false);
    self.contourNode:SetLayer(mask_layer);
    self.contourRender:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);

    local cameraSize = self.CameraInput:GetSize();
    local cameraWidth = cameraSize:x();
    local cameraHeight = cameraSize:y();
    local cameraSize = math.min(cameraWidth, cameraHeight);

    if self.ContourMaskType == 2.0 then
      self.contourMask = self.seg:GetMask();
      self.contour_feather_render:PreUpdate(-600-self.id, cameraWidth, cameraHeight);
      self.contour_feather_render:SetParameter("TEXTURE_MASK", self.contourMask);
      
      self.contour_feather_render:SetPostParameter("inexpendstep", self.step * cameraSize/10000);
      self.contour_feather_render:SetPostParameter("outexpendstep", self.dilate * cameraSize/10000);
      self.contour_feather_render:SetPostParameter("glowstep", self.lightRange);
      self.contour_feather_render:SetPostParameter("blurstep", self.featherRange);

      self.contour_feather_render:SetShow(true);
      self.contour_feather_tex = self.contour_feather_render:GetResultImage();

      self.contourRender:SetRenderOrder(render_order+1);
      self.contourRender:SetParameter("TEXTURE_MASK", self.contour_feather_tex);
      if self.contour_texture_change  then 
        self.contourRender:SetParameter("TEXTURE_DIFFUSE", self.texture_contour_tex);
        self.contour_texture_change = false;
      end
      self.contourRender:SetParameter("TEXTURE_COLOR", self.CameraInput);
      self.contourRender:SetParameter("BLEND_MODE", mathfunction.vector1(self.Overlay_mode));
      self.contourRender:SetParameter("BlendOpacity", mathfunction.vector1(self.Blend_opacity));
      self.contourRender:SetParameter("BGSIZE",mathfunction.vector2(cameraWidth, cameraHeight));
      self.contourRender:SetParameter("LightRange",mathfunction.vector1(self.lightRange));
      self.contourRender:SetParameter("LineContrast",mathfunction.vector1(1.0-0.9*self.lineContrast));
      self.contourRender:SetParameter("GlowContrast",mathfunction.vector1(1.0-0.9*self.glowContrast));
      local t = math.sqrt(math.abs(self.dilate - self.step));
      if t == 0 then
        self.contourRender:SetParameter("GlowIntense",mathfunction.vector1(0));
      else
        self.contourRender:SetParameter("GlowIntense",mathfunction.vector1(self.GlowIntense));
      end
    
      self.contourRender:SetParameter("BlendColor",mathfunction.vector4(self.BlendColor:x(), self.BlendColor:y(), self.BlendColor:z(), self.BlendColor:w()));
      self.contourRender:SetParameter("LightColor",mathfunction.vector4(self.LightColor:x(), self.LightColor:y(), self.LightColor:z(), self.LightColor:w()));
      self.contourRender:SetParameter("MATERIAL_MODE",mathfunction.vector1(self.Material_mode));
      self.contourRender:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      return render_order+1;
    else
      self.contour = self.seg:GetContour(self.id);
      local num = 0;
      if self.contour:Size() > 0 then
        num = self.contour:Get(1):x();
      end   
  
      if num > self.maxRenderNum then
          for i=self.maxRenderNum+1, num do
            self.renderNodes[i] = self:CreateRender();
          end
          self.maxRenderNum = num;
      end

      local maskWidth = self.contour:Get(2):y();
      local maskHeight = self.contour:Get(2):x();
      local size = math.min(cameraWidth, cameraHeight);
      for i=1, num do
        self.renderNodes[i].render:SetRenderOrder(render_order + i);
        self.renderNodes[i]:SetParameter("CENTER",mathfunction.vector2(self.contour:Get(3*i):x()/maskWidth*cameraWidth, self.contour:Get(3*i):y()/maskHeight*cameraHeight));
        if self.enableFixDirection then
          self.renderNodes[i]:SetParameter("GRAD",mathfunction.vector2(0, 1));
        else
          self.renderNodes[i]:SetParameter("GRAD",mathfunction.vector2(self.contour:Get(3*i+1):x(), self.contour:Get(3*i+1):y()));
        end
        self.renderNodes[i]:SetParameter("BGSIZE",mathfunction.vector2(cameraWidth, cameraHeight));
        local j = math.floor(self.contour:Get(3*i+2):x());
        local textureSize = self.color_texs[j+1]:GetSize();
        self.renderNodes[i]:SetParameter("TEXTURE_DIFFUSE",self.color_texs[j+1]);

        if self.Texture_mode == 2 then 
          local frame_id = math.floor(math.fmod(self.time * self.FPS[j+1], self.NumColms[j+1]*self.NumRows[j+1]));
          self.frameX = math.floor(math.fmod(frame_id,self.NumColms[j+1]));
          self.frameY = math.floor(frame_id / self.NumColms[j+1]);
          textureSize = textureSize / mathfunction.vector2( self.NumColms[j+1], self.NumRows[j+1] );
        else
          self.NumColms[j+1] = 1;
          self.NumRows[j+1] = 1;
        end
        self.renderNodes[i]:SetParameter("TEXTURESIZE",mathfunction.vector2(textureSize:x()*self.textureX, textureSize:y()*self.textureX));
        self.renderNodes[i]:SetParameter("TEXTURE_COLOR",self.CameraInput);
        self.renderNodes[i]:SetParameter("BLEND_MODE", mathfunction.vector1(self.Overlay_mode));
        self.renderNodes[i]:SetParameter("BlendOpacity", mathfunction.vector1(self.Blend_opacity));
        self.renderNodes[i]:SetParameter("IMAGE_INFO", mathfunction.vector2(1/self.NumColms[j+1], 1/self.NumRows[j+1]));
        self.renderNodes[i]:SetParameter("INFRAME", mathfunction.vector2(self.frameX, self.frameY));
        self.renderNodes[i]:SetShow(true);
      end
      return render_order + num;
    end
end

function ContourBehavior:CreateRender()
  local node = apollonode.QuadNode();
  local material = venuscore.IFileSystem:PathAssembly("comm:documents/contour_line/rotate_sticker.material");
  node:CreateResource(material, true);
  local rootnode = node.node:GetRoot();
  rootnode:DetachNode(node.node);
  self.Node:AttachNode(node.node);
  node:SetShow(false);
  node:SetCull(false);
  return node;
end

--编辑器回调属性Get、Set
-- function ContourBehavior:GetTexturePath()
--   return self.Texture_path;
-- end

-- function ContourBehavior:SetTexturePath(value)
--   self.Texture_path = value;
--   -- self.color_tex = nil;
--   -- self.color_tex = self:LoadTexture(self.Texture_path);
-- end

function ContourBehavior:LoadTexture(texture_path)
  local texture = apolloengine.TextureEntity();
  texture:PushMetadata(apolloengine.TextureFileMetadata(
                                 apolloengine.TextureEntity.TU_STATIC,
                                 apolloengine.TextureEntity.PF_AUTO,
                                 1, false,
                                 apolloengine.TextureEntity.TW_REPEAT,
                                 apolloengine.TextureEntity.TW_REPEAT,
                                 apolloengine.TextureEntity.TF_LINEAR,
                                 apolloengine.TextureEntity.TF_LINEAR,
                                 venuscore.IFileSystem:PathAssembly(texture_path)));
  texture:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  texture:CreateResource();
  return texture;
end

function ContourBehavior:GetActive()
  return self.isActive;
end

function ContourBehavior:SetActive(isActive)
  self.isActive = isActive;
  if self.isActive then
    for i=1, self.maxRenderNum do
      self.renderNodes[i]:SetShow(true);
    end

    if self.contourNode ~= nil then
      self.contourRender:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    else
      self.OnCreateRender(self.Node, 1);
      self.contourNode:SetStaticID(self.node_uuid);
      self.contourRender:SetStaticID(self.render_uuid);
    end
  else
    for i=1, self.maxRenderNum do
      self.renderNodes[i]:SetShow(false);
    end
    if self.contourNode ~= nil then
      self.contourRender:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      local scene = self.Node:GetHostScene();
      if  self.contourNode ~= nil then
        self.Node:DetachNode(self.contourNode);
        scene:DeleteNode(self.contourNode);
        self.contourNode = nil;
        self.contourRender = nil;
      end
    end
  end 
end

function ContourBehavior:GetBlendOpacityMode()
  return self.Blend_opacity;
end

function ContourBehavior:SetBlendOpacityMode(value)
  self.Blend_opacity = value;
end

function ContourBehavior:GettextureX()
  return self.textureX;
end

function ContourBehavior:SettextureX(value)
  self.textureX = value;
end

function ContourBehavior:GetOverlayMode()
  return self.Overlay_mode;
end

function ContourBehavior:SetOverlayMode(value)
  self.Overlay_mode = value;
end

function ContourBehavior:GetTextureMode()
  return self.Texture_mode;
end

function ContourBehavior:SetTextureMode(value)
  self.Texture_mode = value;
end

function ContourBehavior:GetContourMaskType()
  return self.ContourMaskType;
end

function ContourBehavior:SetContourMaskType(value)
  self.ContourMaskType = value;
end

function ContourBehavior:GetMaterialMode()
  return self.Material_mode;
end

function ContourBehavior:SetMaterialMode(value)
  self.Material_mode = value;
end

function ContourBehavior:GetTextureContourPath()
  return self.Texture_contour_path;
end

function ContourBehavior:SetTextureContourPath(value)
  self.contour_texture_change = true;
  self.Texture_contour_path = value;
  self.texture_contour_tex = nil;
  self.texture_contour_tex = self:LoadTexture(self.Texture_contour_path);
end

ContourBehavior:MemberRegister("density");
ContourBehavior:MemberRegister("dilatePoint");
ContourBehavior:MemberRegister("featherRange");
ContourBehavior:MemberRegister("lineContrast");
ContourBehavior:MemberRegister("glowContrast");

ContourBehavior:MemberRegister("enableInContour");
ContourBehavior:MemberRegister("enableRandomColor");
ContourBehavior:MemberRegister("enableFixDirection");
ContourBehavior:MemberRegister("BlendColor");
ContourBehavior:MemberRegister("LightColor");

ContourBehavior:MemberRegister("node_uuid",
  venuscore.ScriptTypes.StringType(
     function(self)
      return self.node_uuid;
     end ,
     function(self, value)
      if self.contourNode ~= nil then
        self.contourNode:SetStaticID(value);
      end
      self.node_uuid = value;
     end 
));

ContourBehavior:MemberRegister("render_uuid",
  venuscore.ScriptTypes.StringType(
     function(self)
      return self.render_uuid;
     end ,
     function(self, value)
      if self.contourRender ~= nil then
        self.contourRender:SetStaticID(value);
      end
      self.render_uuid = value;
     end 
));


ContourBehavior:MemberRegister("textureX",
  venuscore.ScriptTypes.FloatType(
    0.5, 1.5,
     function(self)
      return self.textureX;
     end ,
     function(self, value)
      self.textureX = value;
     end 
));

ContourBehavior:MemberRegister("dilate",
  venuscore.ScriptTypes.FloatType(
    -50.0, 100.0,
     function(self)
      return self.dilate;
     end ,
     function(self, value)
      self.dilate = value;
     end 
));

ContourBehavior:MemberRegister("step",
  venuscore.ScriptTypes.FloatType(
    -50.0, 100.0,
     function(self)
      return self.step;
     end ,
     function(self, value)
      self.step = value;
     end 
));

ContourBehavior:MemberRegister("lightRange",
  venuscore.ScriptTypes.FloatType(
    0, 100.0,
     function(self)
      return self.lightRange;
     end ,
     function(self, value)
      self.lightRange = value;
     end 
));

ContourBehavior:MemberRegister("GlowIntense",
  venuscore.ScriptTypes.FloatType(
    0, 100.0,
     function(self)
      return self.GlowIntense;
     end ,
     function(self, value)
      self.GlowIntense = value;
     end 
));



ContourBehavior:MemberRegister("isActive",
venuscore.ScriptTypes.BoolType(
  ContourBehavior.GetActive,
  ContourBehavior.SetActive
));

ContourBehavior:MemberRegister("Texture_contour_path",
  venuscore.ScriptTypes.FilePathType(
    apolloengine.TextureEntity:RTTI(),
    ContourBehavior.GetTextureContourPath,
    ContourBehavior.SetTextureContourPath
));

function ContourBehavior:GetTexturePath()
  return self.Texture_path;
end

function ContourBehavior:SetTexturePath(value)
  self.Texture_path = value;
end

-- ContourBehavior:MemberRegister("Texture_path",
--   venuscore.ScriptTypes.FilePathType(
--     apolloengine.TextureEntity:RTTI(),
--     ContourBehavior.GetTexturePath,
--     ContourBehavior.SetTexturePath
-- ));



ContourBehavior:MemberRegister("Texture_paths",
venuscore.ScriptTypes.FilePathArrayType(
  function(thiz)
    return thiz.Texture_path; --thiz:GetScriptValue("Texture_path"); --thiz.Texture_path;
  end,
  function (thiz)
    return { unpack(thiz.Texture_paths) }
  end,
  function (thiz, value)
    thiz.Texture_paths = { unpack(value) }
  end));


ContourBehavior:MemberRegister("FPS",
venuscore.ScriptTypes.ArrayType(
  function(thiz)
    return 30;
  end,
  function (thiz)
    return { unpack(thiz.FPS) }
  end,
  function (thiz, value)
    thiz.FPS = { unpack(value) }
  end));

ContourBehavior:MemberRegister("NumColms",
venuscore.ScriptTypes.ArrayType(
  function(thiz)
    return 1;
  end,
  function (thiz)
    return { unpack(thiz.NumColms) }
  end,
  function (thiz, value)
    thiz.NumColms = { unpack(value) }
  end));

ContourBehavior:MemberRegister("NumRows",
venuscore.ScriptTypes.ArrayType(
  function(thiz)
    return 1;
  end,
  function (thiz)
    return { unpack(thiz.NumRows) }
  end,
  function (thiz, value)
    thiz.NumRows = { unpack(value) }
  end));

ContourBehavior:MemberRegister("Blend_opacity",
  venuscore.ScriptTypes.FloatType(
    0, 1,
    ContourBehavior.GetBlendOpacityMode,
    ContourBehavior.SetBlendOpacityMode
));

ContourBehavior:MemberRegister("Overlay_mode",
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "Normal", -- 正常
        value = 1.0
      },
      {
        key = "Add", -- 变暗
        value = 2.0
      },
      {
        key = "Lighten",
        value = 3.0
      },
      {
        key = "Multiply",
        value = 4.0
      },
      {
        key = "Overlay",
        value = 5.0
      },
      {
        key = "Screen",
        value = 6.0
      },
      {
        key = "Linear Light",
        value = 7.0
      },
      {
        key = "Pin Light",
        value = 8.0
      },
    },
    ContourBehavior.GetOverlayMode,
    ContourBehavior.SetOverlayMode
));

ContourBehavior:MemberRegister("Texture_mode",
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "Static", -- 正常
        value = 1.0
      },
      {
        key = "Dynamic", -- 变暗
        value = 2.0
      },
    },
    ContourBehavior.GetTextureMode,
    ContourBehavior.SetTextureMode
));

ContourBehavior:MemberRegister("Material_mode",
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "texture", 
        value = 1.0
      },
      {
        key = "color", 
        value = 2.0
      },
    },
    ContourBehavior.GetMaterialMode,
    ContourBehavior.SetMaterialMode
));

ContourBehavior:MemberRegister("ContourMaskType",
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "Texture", 
        value = 1.0
      },
      {
        key = "Line", 
        value = 2.0
      },
    },
    ContourBehavior.GetContourMaskType,
    ContourBehavior.SetContourMaskType
));
------------------------------------------------------------------------
local ContourBehaviors = venuscore.VenusBehavior:extend("ContourBehaviors");

function ContourBehaviors:new()
  self.contourBehaviors = {};
  self.contour_num = 0;
  self.render_order = 0;
end

function ContourBehaviors:_OnUpdate(def)
  local camera = self.Node:GetComponent(apolloengine.Node.CT_CAMERA);
  if camera == nil then
    return
  end

  local layerMask = camera.LayerMask;
  local render_order = self.render_order;
  for _, contour in ipairs(self.contourBehaviors) do
    render_order = contour:OnUpdate(self.Node, layerMask, render_order, def)
  end
end

function ContourBehaviors:_OnStart()
  for _, contour in ipairs(self.contourBehaviors) do
    contour:OnStart(self.Node)
  end
end

function ContourBehaviors:_OnAwake()
  for _, contour in ipairs(self.contourBehaviors) do
    contour:OnAwake(self.Node)
  end
end


function ContourBehaviors:_OnDestroy()
  for _, contour in ipairs(self.contourBehaviors) do
    contour:OnDestroy()
  end
end

ContourBehaviors:MemberRegister("contour_num");

ContourBehaviors:MemberRegister(
  "contourBehaviors",
  venuscore.ScriptTypes.ArrayType(
    function(thiz)
      thiz.contour_num = thiz.contour_num + 1;
      local behavior = ContourBehavior();
      behavior:OnCreateRender(thiz.Node,  thiz.contour_num);
      return behavior;
    end,
    function (thiz)
      return { unpack(thiz.contourBehaviors) }
    end,
    function (thiz, value)
      thiz.contourBehaviors = { unpack(value) }
    end
  ),
  {
    type = "defaultClosed"
  }
);


return ContourBehaviors;