local asynctexture = require "apolloutility.asynctexture.asynctexture"
local emptyimage = require "apolloutility.emptyimage"
local apolloengine = require "apolloengine"
local am = require "mathfunction"
local Object = require "classic"
local vc = require "venuscore"
require "math"
local apolloDefine = require "apolloutility.defiend"



local SequenceAnimation = Object:extend();

function SequenceAnimation:new(materialpath)
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  self.node = scene:CreateNode(apolloengine.Node.CT_NODE);
  --self.node = apolloengine.Node();
  self.trans = self.node:CreateComponent(apolloengine.Node.CT_TRANSFORM);
  self.rotation = am.Quaternion();
  self.trans:SetLocalRotation(self.rotation);
  self.render = self.node:CreateComponent(apolloengine.Node.CT_RENDER);
  self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_CULL);
  self.render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata(materialpath)));
  
  self.render:PushMetadata(
		apolloengine.RenderObjectMeshMetadate( 
			apolloengine.RenderComponent.RM_TRIANGLES,
      apolloengine.QuadVertexMetadata(),
      apolloengine.QuadIndicesMetadata()));
  self.render:CreateResource();
  self.render:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    emptyimage:GetImage());
  self.render:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_OPACITY,
    emptyimage:GetImage());
end

function SequenceAnimation:Play(imagepath, rgbTextureName,alphaTextureName,fps, isloop, beginid, keep)
  self.imagepath = imagepath;
  self.beginid = beginid;
  self.rgbtexturename = rgbTextureName;
  self.alphatexturename = alphaTextureName;
  self.originalalpha = 1;
  self.realalpha = 1;
  self.originalfps = fps;
  self.realfps = fps;
  self.isloop = isloop;
  self.playing = true;
  local alphapth = nil;
  if self.alphatexturename then
    alphapth = self.imagepath.."/"..self.alphatexturename;
  end  
  self.imagereader = asynctexture();
  self.imagereader:SetKeepSource(keep or false);
  self.imagereader:SequentialLoad(self.realfps, self.isloop, self.beginid, self.imagepath.."/"..self.rgbtexturename, alphapth);
  self.imagereader:Preloading();
  self.playing = true;
  return self.playing;
end

--更新播放结束时返回false
function SequenceAnimation:Update(dtime)
  local rgb, alpha, frame, isplaying = 0;
  rgb, frame, alpha, isplaying = self.imagereader:Update(dtime);
  if rgb and isplaying then
    self.rgbtexture = rgb;
    self.render:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.rgbtexture);
    if alpha then
      self.alphatexture = alpha;
      self.render:SetParameter(
        apolloengine.ShaderEntity.TEXTURE_OPACITY,
        self.alphatexture);
    end
  else
      self.playing = false;
      self.rgbtexture = emptyimage:GetImage();
      self.render:SetParameter(
        apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
        self.rgbtexture);
      self.alphatexture = emptyimage:GetImage();
      self.render:SetParameter(
        apolloengine.ShaderEntity.TEXTURE_OPACITY,
        self.alphatexture);
  end
  return self.playing, frame;
end

function SequenceAnimation:SetLoop(isloop)
  self.isloop = isloop;
end

--在time时间内将fps过渡到targetfps
function SequenceAnimation:FadeFps(time, targetfps)
  local now = 0;
  self.fpsclosuer = function (dtime)
    now = math.max(time, now + dtime);
    self.realfps = self.originalfps - (self.originalfps - targetfps) * (now / time);
  end  
end

--结束时候返回false
function SequenceAnimation:UpdateFps(dtime)
  return self.fpsclosuer(dtime);
end

--在time时间内将alpha过渡到target
function SequenceAnimation:FadeAlpha(time, targetalpha)
  local now = 0;
  self.alphaclosuer = function (dtime)
    now = math.max(time, now + dtime);
    self.realalpha = self.originalalpha - (self.originalalpha - targetalpha) * (now / time);
  end  
end

--结束时候返回false
function SequenceAnimation:UpdateAlpha(dtime)
  return self.alphaclosuer(dtime);
end
  
--旋转动画
function SequenceAnimation:RotateAnimation(radian)
  local lr = self.trans:GetLocalRotation();
  local r = am.Mathutility:RotateAxis(am.vector3(0,0,1), radian);
  self.rotation = self.rotation * r;
  self.trans:SetLocalRotation(self.rotation);
  --lr = lr * r;
  --self.trans:SetLocalRotation(lr);
end

--得到当前的纹理
function SequenceAnimation:GetCurrentTexture()
  return self.rgbtexture, self.alphatexture;
end

function SequenceAnimation:SetSequence(s)
  self.render:SetSequence(s);
end

function SequenceAnimation:SetShow(isshow)
  if isshow then
    self.render:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  else
    self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  end
end


return SequenceAnimation;