local b3 = require 'behavior3.b3';
require 'behavior3.core.Decorator'
local soundpalyer = require "soundplayer";

local soundscope = b3.Class("SoundScope", b3.Decorator)

function soundscope:ctor(properties, target)
  b3.Decorator.ctor(self)
	self.name = "SoundScope"  
  self.soundfile = properties.soundfile;
end


--新增的这种初始化接口，需要解决一个问题，同一个节点会调用多次初始化，
--那么被调用多次产生的多个数据如何储存的问题，而如何解决这个问题
--目前尽量不保存本地数据，通过将自身id传递给target取出对应数据来实现
function soundscope:init(tick)
  local board = tick.blackboard;
  local targetscope = board:get("targetscope");
  local soundscope = targetscope:LoadSound(self.soundfile, self.id);
  
  local oldscope = board:get("soundscope");
  board:set("soundscope", soundscope);
  self.child:init(tick);
  board:set("soundscope", oldscope);
end

function soundscope:tick(tick)
	if not self.child then
		return b3.ERROR
	end
  local board = tick.blackboard;
  local targetscope = board:get("targetscope");
  local soundscope = targetscope:GetSound(self.id);  
  local sp = soundpalyer:cast(soundscope);
  if sp and sp.ResetVolume then
	 sp.ResetVolume(); --reset volume
  end
  local oldscope = board:get("soundscope");
  board:set("soundscope", soundscope);
  local status = self.child:_execute(tick);
  board:set("soundscope", oldscope);
	return status;
end

return soundscope;