#include "functions/util.function"
#SHADER_DEFINE DirblurVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
       
	}
	FUNCTION_OUTPUT =
	{
        { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;  
    vec2 out_TexCooridate;
    out_TexCooridate= in_TexCoordinate.xy;     // upper left corner
 
#END_CODE

#END_DEFINE


#SHADER_DEFINE DirblurFragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_uDab,		    	NONE,	TEXTURE2D,	  "uDab" },
        { ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,	"vUV"},
		{ UNIFORM_uOs,				HIGH,	VEC2,	"uOs"},
		{ UNIFORM_uHiu,            	MEDIUM, FLOAT,   "uHiu"},
        { UNIFORM_uVer,            MEDIUM, FLOAT,   "uVer"}
	}
  
#SHADER_CODE

    float k = gauss(0.0, uHiu);
    float sum = k;
    vec4 vfs = texture2D(uDab, vUV);
    highp vec3 result;
    //if (abs(uVer - 2.0) < 0.0001) {
        result = vec3(decode(vfs), 0.0) * k;
   // }
    //else {
    //    result = vfs.xyz * k;
    //}

    for (int i = 1; i <= 3; ++i) {
        k = gauss(float(i), uHiu);
        sum += k + k;
        vec2 offset = vec2(uOs.x * float(i), 0.0);

        vec4 qw0 = texture2D(uDab, vUV + offset);
        vec4 qw1 = texture2D(uDab, vUV - offset);
        //if (abs(uVer - 2.0) < 0.0001) {
            result += vec3(decode(qw0), 0.0) * k;
            result += vec3(decode(qw1), 0.0) * k;
        //}
        //else {
        //    result += qw0.xyz * k;
         //   result += qw1.xyz * k;
        //}
    }
    result /= sum;

    //if (abs(uVer - 2.0) < 0.0001) {
        gl_FragColor = encode(result.xy);
    //}
    //else {
    //    gl_FragColor = vec4(result, 0.);
    //}
 
#END_CODE

#END_DEFINE
