local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local dolly =  {}


dolly.Do = 0;
dolly.Mat = 0;
dolly.Queue = 310;

function dolly:Initialize(host, size)
  
  self.UNIFORM_CENTER =apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"UNIFORM_CENTER");
  self.UNIFORM_SCALE =apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"UNIFORM_SCALE");
  local pathout = venuscore.IFileSystem:PathAssembly("docs:filter/dramatic/filter/resource/material/dramadolly.material");
  self.Mat = host:CreateMaterial(pathout);  
  self.Do = host:CreateRenderObject();
  return self.Queue;
end

function dolly:Resizeview(size)
end

function dolly:Process(context, Original, Scene, Output)
  --Output:PushRenderTarget();
  --Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(Output,apolloengine.RenderTargetEntity.CF_COLOR);
  self.Mat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.Do,self.Mat);
  context:EndRenderPass();
end

return dolly;

