// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{getMiniAppsAllowed as t,getPopularSites as e,getShortcutSites as o,getToolsSites as s,getMostVisitedSites as i}from"./utils/topsites.js";import{LitElement as r,html as n,css as a,repeat as c,classMap as h,when as d}from"../common/lit.js";import{proxyHttpFetch as l}from"../common/proxy.js";import{sendMessage as p}from"../common/message.js";import{market as u}from"../common/environment.js";import{showTooltip as m}from"../common/controls/edge-tooltip.js";import g from"../common/i18n.js";import{init as _}from"../common/index.js";import{addDrawerObserver as w}from"./components/edge-drawer.js";import{GetCurrentList as S,GetPopularSites as f,LogError as y}from"./utils/actions.js";import{urlEqual as x,TOPSISE_SERVER as v,isFirst as $,isIconPreloadEnabled as k,isMostVisitedSitesEnabled as C,isNoBorderIconEnabled as b,getAndIncreaseNextDefaultIconGroupId as L}from"./utils/index.js";import{ActionName as I,GuideValue as A,ItemValue as j,SiteValue as R}from"./utils/histogram.js";import{RecordBool as F,RecordEnum as M}from"../common/log.js";import"./components/edge-navigation-bar.js";import"./components/edge-search.js";import"./components/search-suggestion.js";import"./components/edge-topsite-custom.js";import"./components/edge-tp-item.js";const P=`${v}/market_topsites?market=${u}&topk=8`,T=`popular_sites_${u}`;const E="topsite-page-home";customElements.define(E,class extends r{static get properties(){return{shortcut_section:{type:Object},tools_section:{type:Object},popular_section:{type:Object},current_list:{type:Array},keywords:{type:String},showSearchList:{type:Boolean},showCustomAdd:{type:Boolean},drawerShown:{type:Boolean},tooltipsShown:{type:Boolean}}}static get styles(){return a`
      :host {
        background: var(--surfaces-primary);
        width: 100%;
        height: 100%;
        display: flex;
        flex-flow: column;
      }

      .content {
        flex: 1;
        display: flex;
        flex-direction: column;
        position: relative;
        max-width: 500px;
        left: 50%;
        transform: translateX(-50%);
      }

      edge-topsite-custom {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        opacity: 0;
        transition: opacity 250ms ease;
        pointer-events: none;
      }

      .content-custom edge-topsite-custom {
        pointer-events: unset;
        opacity: 1;
      }

      .content-custom > *:not(edge-topsite-custom) {
        pointer-events: none;
        opacity: 0;
      }

      .search {
        padding: 8px 16px;
        margin-bottom: 16px;
        display: flex;
        transition: opacity 250ms ease;
      }

      topsite-search {
        flex: 1;
        width: 0;
      }

      .list {
        flex: 1;
        position: relative;
        transition: opacity 250ms ease;
      }

      .sections {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        overflow: auto;
        transition: opacity 250ms ease;
      }

      .tile-container {
        background-color: #F8FBFE;
      }

      .feature-area .section:nth-child(1) .tile-container {
        background-color: #F8F8FE;
      }

      .feature-area .section:nth-child(2) .tile-container {
        background-color: #F8FDFE;
      }

      .section {
        margin: 0 16px 24px;
        display: block;
      }

      .title {
        font-size: 17rem;
        line-height: 22rem;
        color: var(--text-primary);
        font-weight: 600;
        margin-bottom: 12px;
      }

      .tile-container {
        padding: 10px 0;
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        border-radius: 12px;
      }

      .tile {
        padding: 10px 0;
        overflow: hidden;
      }

      search-suggestion {
        pointer-events: none;
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        opacity: 0;
        transition: opacity 250ms ease;
      }

      .list-search search-suggestion {
        opacity: 1;
        pointer-events: unset;
      }

      .list-search .sections {
        opacity: 0;
        pointer-events: none;
      }

      @media (prefers-color-scheme: dark) {
        :host {
          background: var(--surfaces-tertiary);
        }

        .tile-container {
          background-color: #21252D;
        }

        .feature-area .section:nth-child(1) .tile-container {
          background-color: #25252D;
        }

        .feature-area .section:nth-child(2) .tile-container {
          background-color: #202626;
        }

        .title {
          color: var(--text-dominant);
        }
      }
    `}constructor(){super(),this.most_visited_section=i(),this.shortcut_section=o(),this.popular_section=e(),this.is_popular_loaded=!1,this.updateCurrentList=this.updateCurrentList.bind(this),this.onDrawerUpdate=this.onDrawerUpdate.bind(this),w(this.onDrawerUpdate)}requestMiniAppList(){const e=t();p({action:"get_mini_app_list"},(({payload:t})=>{const o=t.filter((t=>Object.keys(e).includes(t.appId))).map((t=>({title:t.appName,iconUrl:t.icons.light,iconUrlDark:t.icons.dark,localImageName:t.localImageName,iconSource:t.iconSource,url:`edge-miniapp://${t.appId}`,...e[t.appId]})));o&&o.length>0&&(this.tools_section={...s(),items:o},this.tools_section.items?.forEach((t=>{void 0===t.defaultIconGroupId&&(t.defaultIconGroupId=L()),M(I.ShowItem,t.item_id,j.Max)})),M(I.ShowSite,R.Tools,R.Max)),F(I.ToolsLoadResult,o&&o.length>0)}))}requestMostVisitedSitesList(){C&&p({action:"get_most_visited_sites"},(({payload:t})=>{if(this.most_visited_section={title:g.text("tsp_most_visited_sites"),items:t.map((t=>({...t,site_id:R.MostVisitedSites})))},this.most_visited_section?.items.length>0){for(const t of this.most_visited_section.items)void 0===t.defaultIconGroupId&&(t.defaultIconGroupId=L());M(I.ShowSite,R.MostVisitedSites,R.Max)}F(I.MostVisitedLoadResult,this.most_visited_section.items&&this.most_visited_section?.items?.length>0)}))}requestShortcutSitesList(){b&&p({action:"get_shortcut_sites"},(({payload:t})=>{this.shortcut_section={title:g.text("tsp_shortcut_sites"),items:t.map((t=>({...t,site_id:R.FeatureShortcuts})))},this.shortcut_section.items?.forEach((t=>{void 0===t.defaultIconGroupId&&(t.defaultIconGroupId=L())}))}))}connectedCallback(){super.connectedCallback(),this.requestMostVisitedSitesList(),this.requestShortcutSitesList(),this.requestMiniAppList(),this.updateCurrentList(),this.loadPopularFromCache(),l(P).then((t=>(t.ok||y(`Adding page popular sites load failed, error code: ${t.status}, error msg: ${t.statusText}`),t.json()))).then((t=>{this.is_popular_loaded||0!==t?.marketSiteResult?.length||F(I.PopularSitesLoadResult,!1),this.updatePopularListByResponse(t),localStorage.setItem(T,JSON.stringify(t))})).catch((t=>{}))}loadPopularFromCache(){const t=localStorage.getItem(T);if(t)try{const e=JSON.parse(t);this.updatePopularListByResponse(e)}catch(t){}else k&&this.loadPreloadPopularSites()}loadPreloadPopularSites(){f().then((({payload:t})=>{t?.length>0&&this.updatePopularList(t)}))}updatePopularListByResponse(t){t?.marketSiteResult?.length>0&&this.updatePopularList(t.marketSiteResult)}updatePopularList(t){t?.length>0&&!this.is_popular_loaded&&(this.is_popular_loaded=!0,this.popular_section={title:g.text("tsp_popular_sites"),items:t.map((t=>({...t,site_id:R.PopularSites})))},this.popular_section.items?.forEach((t=>{void 0===t.defaultIconGroupId&&(t.defaultIconGroupId=L())})),M(I.ShowSite,R.PopularSites,R.Max),F(I.PopularSitesLoadResult,!0))}updateShortcutList(){if(this.current_list?.some((t=>t.managed))){const t=this.shortcut_section.items.filter((t=>t.item_id!==j.FrequentlyVisited));this.shortcut_section={...this.shortcut_section,items:t}}this.shortcut_section.items?.forEach((t=>{M(I.ShowItem,t.item_id,j.Max)})),this.shortcut_section.items?.length>0&&M(I.ShowSite,R.FeatureShortcuts,R.Max),F(I.FeatureShortcutsLoadResult,this.shortcut_section?.items?.length>0)}updateCurrentList(){S().then((({payload:t})=>{this.current_list=t,this.updateShortcutList()}))}firstUpdated(){super.firstUpdated(),$&&this.showSearchTooltip()}showSearchTooltip(){M(I.GuideShow,A.SEARCH,A.Max);const t=this.shadowRoot.querySelector(".search");this.tooltip=m({target:t,placement:"bottom",text:g.text("tsp_tooltip_search"),icon:"resources/tooltip.png",showTipAnimationDuration:400,maskAnimation:!1,actions:[{title:g.text("common_skip"),onClick:()=>{this.tooltip.dismiss(),this.tooltipsShown=!1}},{title:g.text("common_next"),onClick:()=>{this.showRecommendTooltip()}}]}),this.tooltipsShown=!0}showRecommendTooltip(){M(I.GuideShow,A.FEATURE,A.Max);const t=this.shadowRoot.querySelector(".feature-area");this.tooltip.update({target:t,placement:"top",text:g.text("tsp_tooltip_feature"),icon:"resources/tooltip.png",maskAnimation:!1,actions:[{title:g.text("common_got_it"),onClick:()=>{this.tooltip.dismiss(),this.tooltip=null,this.tooltipsShown=!1}}],onCancel:()=>{this.tooltip=null,this.tooltipsShown=!1}});const e=new ResizeObserver((()=>{if(!this.tooltip)return void e.disconnect();const o=Math.min(document.documentElement.clientHeight,window.innerHeight);t.getBoundingClientRect().y>o&&t.parentElement.scrollTo(0,200)}));e.observe(t)}onDrawerUpdate(t){this.drawerShown=t}renderSearchBox(){return n`
      <div class='search' aria-hidden=${this.showCustomAdd?"true":"false"}>
        <topsite-search
          .hideTabIndex=${this.showCustomAdd||this.drawerShown||this.tooltipsShown}
          .keywords=${this.keywords}
          .onChange=${t=>{this.keywords=t}}
        ></topsite-search>
      </div>
    `}renderSection(t,e){return n`
      <div class="section">
        <div class="title" role="heading" aria-level="2">${t}</div>
        <div class="tile-container">
          ${c(e.map((t=>({...t,checked:!!this.current_list?.some((e=>x(e.url,t.url)))}))),(t=>t.url),((t,o)=>n`
              <topsite-item-card
                class="tile"
                role="checkbox"
                aria-checked=${t.checked}
                aria-label=${`list ${o+1} of ${e.length},${t.title}`}
                .item=${t}
                .onToggle=${this.updateCurrentList}/>
            `))}
        </div>
    `}renderCustomAdd(){return n`
      <edge-topsite-custom
        .keywords=${this.showCustomAdd?this.keywords:null}
        .onCancel=${()=>{this.showCustomAdd=!1,this.keywords="",this.showSearchList=!1}}
        .onComplete=${()=>{this.showCustomAdd=!1,this.keywords="",this.updateCurrentList(),this.showSearchList=!1}}
        .hideTabIndex=${!this.showCustomAdd||this.drawerShown}
        aria-hidden=${this.showCustomAdd?"false":"true"}
      >
      </edge-topsite-custom>
    `}renderSearchList(){return n`
      <search-suggestion
        .keyword=${this.keywords}
        .currentList=${this.current_list}
        .onToggle=${this.updateCurrentList}
        .onResult=${t=>{this.showSearchList=t}}
        .onClickCustomAdd=${()=>{this.showCustomAdd=!0,F(I.CustomAddClick,!0)}}
        tabindex="${!this.showSearchList||this.showCustomAdd||this.drawerShown?"-1":"0"}"
        aria-hidden=${this.showSearchList&&!this.showCustomAdd?"false":"true"}
      />
      </search-suggestion>
    `}render(){const t=h({content:!0,"content-custom":this.showCustomAdd}),e=h({list:!0,"list-search":this.showSearchList}),o=C&&this.most_visited_section?.items.length>0;return n`
      <topsite-navigation-bar
        aria-hidden=${this.drawerShown||this.tooltipsShown}
        .hideTabIndex=${this.drawerShown||this.tooltipsShown}
        .title=${g.text("tsp_add_to_home")}
      ></topsite-navigation-bar>
      <div class=${t}>
        ${this.renderCustomAdd()}
        ${this.renderSearchBox()}
        <div class=${e} aria-hidden=${this.showCustomAdd?"true":"false"}>
          ${this.renderSearchList()}
          <div class="sections" aria-hidden=${this.showSearchList||this.tooltipsShown}>
            ${d(o,(()=>this.renderSection(this.most_visited_section.title,this.most_visited_section.items)))}
            ${this.renderSection(this.popular_section.title,this.popular_section.items)}
            <div class="feature-area">
              ${this.renderSection(this.shortcut_section.title,this.shortcut_section.items)}
              ${this.tools_section?.items&&this.renderSection(this.tools_section.title,this.tools_section.items)}
            </div>
          </div>
        </div>
      </div>
    `}}),_(E);